/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;

public class PropertyEditorFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected final transient ClientConfiguration configuration = ClientConfiguration.getInstance();
    private JScrollPane paneListProperties;
    private JButton btnExit;
    private JButton btnDefault;
    private JTable tableProperties;
    protected DefaultTableModelExtension tableModel;

    public PropertyEditorFrame() {
        this.initComponents();
    }

    private void btnDefaultMouseMouseClicked(MouseEvent event) {
        String key = (String)this.tableModel.getValueAt(this.tableProperties.convertRowIndexToModel(this.tableProperties.getSelectedRow()), 0);
        String value = (String)this.tableModel.getValueAt(this.tableProperties.convertRowIndexToModel(this.tableProperties.getSelectedRow()), 1);
        int result = JOptionPane.showConfirmDialog(this, "\"" + key + "\"\u3092\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u5024\u306b\u5fa9\u5143\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f\n\n\u73fe\u5728\u306e\u5024: \"" + value + "\"", "\u5143\u306b\u623b\u3059", 2, 3);
        if (result == 0) {
            this.configuration.getConfigProperties().remove(key);
            this.initTableModel();
        }
    }

    protected void btnExitMouseClicked(MouseEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    private JButton getBtnDefault() {
        if (this.btnDefault == null) {
            this.btnDefault = new JButton();
            this.btnDefault.setText("\u5143\u306b\u623b\u3059");
            this.btnDefault.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    PropertyEditorFrame.this.btnDefaultMouseMouseClicked(event);
                }
            });
        }
        return this.btnDefault;
    }

    private JButton getBtnExit() {
        if (this.btnExit == null) {
            this.btnExit = new JButton();
            this.btnExit.setText("\u9589\u3058\u308b(X)");
            this.btnExit.setMnemonic('X');
            this.btnExit.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PropertyEditorFrame.this.btnExitMouseClicked(e);
                }
            });
        }
        return this.btnExit;
    }

    private JScrollPane getPaneListProperties() {
        if (this.paneListProperties == null) {
            this.paneListProperties = new JScrollPane();
            this.paneListProperties.setViewportView(this.getTableProperties());
        }
        return this.paneListProperties;
    }

    private JTable getTableProperties() {
        if (this.tableProperties == null) {
            this.tableProperties = new JTable();
            this.tableProperties.setColumnSelectionAllowed(true);
            this.tableProperties.setColumnSelectionAllowed(false);
            this.tableProperties.getTableHeader().setReorderingAllowed(false);
            this.tableModel = new DefaultTableModelExtension();
            this.tableProperties.setModel(this.tableModel);
            this.tableModel.setColumnCount(0);
            this.tableModel.addColumn("name");
            this.tableModel.addColumn("value");
            this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getType() == 0) {
                        String key = (String)PropertyEditorFrame.this.tableModel.getValueAt(e.getFirstRow(), 0);
                        String value = (String)PropertyEditorFrame.this.tableModel.getValueAt(e.getFirstRow(), 1);
                        PropertyEditorFrame.this.configuration.getConfigProperties().setProperty(key, value);
                    }
                }
            });
            this.tableProperties.setDefaultRenderer(String.class, new DefaultTableCellRendererExtension(this.tableModel));
            TableRowSorter<DefaultTableModelExtension> sorter = new TableRowSorter<DefaultTableModelExtension>(this.tableModel);
            sorter.setSortable(1, false);
            ArrayList<RowSorter.SortKey> s = new ArrayList<RowSorter.SortKey>();
            s.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            sorter.setSortKeys(s);
            this.tableProperties.setRowSorter(sorter);
            this.tableProperties.setCellSelectionEnabled(true);
        }
        return this.tableProperties;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getPaneListProperties()).addContainerGap().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(4, 4, 4).addComponent(this.getBtnDefault(), GroupLayout.Alignment.LEADING).addGap(4).addComponent(this.getBtnExit(), GroupLayout.Alignment.TRAILING).addGap(4, 4, 4)).addGap(4, 4, 4));
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getPaneListProperties()).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(18).addComponent(this.getBtnDefault()).addGap(18).addContainerGap(8, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getBtnExit()).addGap(18)));
        this.setSize(320, 223);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PropertyEditorFrame.this.configuration.getConfigProperties().store();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                PropertyEditorFrame.this.configuration.getConfigProperties().store();
            }
        });
    }

    private void initTableModel() {
        this.tableModel.setRowCount(0);
        ClientProperties configProperties = this.configuration.getConfigProperties();
        Enumeration<?> enumeration = configProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.tableModel.addRow(new Object[]{key, configProperties.getProperty(key)});
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.initTableModel();
        }
    }

    private final class DefaultTableCellRendererExtension
    extends DefaultTableCellRenderer {
        private final DefaultTableModelExtension model;

        public DefaultTableCellRendererExtension(DefaultTableModelExtension tableModel) {
            this.model = tableModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object key = column == 0 ? value : this.model.getValueAt(table.convertRowIndexToModel(row), 0);
            if (PropertyEditorFrame.this.configuration.getConfigProperties().containsKey(key)) {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    private static final class DefaultTableModelExtension
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        Class<?>[] types = new Class[]{String.class, String.class};

        private DefaultTableModelExtension() {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }
    }
}

