/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.StatusPanel;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.gui.DefaultClientTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class TimelineViewTab
extends DefaultClientTab {
    static final Logger logger = LoggerFactory.getLogger(TimelineViewTab.class);
    private static final String TAB_ID = "timeline";
    private DefaultClientTab.DefaultRenderer renderer = new DefaultClientTab.DefaultRenderer(){

        @Override
        public void onChangeAccount(boolean forWrite) {
            StatusData statusData = new StatusData(null, new Date());
            statusData.backgroundColor = Color.LIGHT_GRAY;
            statusData.foregroundColor = Color.BLACK;
            statusData.image = new JLabel();
            statusData.sentBy = new JLabel("elnetw");
            if (forWrite) {
                statusData.user = "!core.change.account!write";
                statusData.data = new JLabel("\u66f8\u304d\u8fbc\u307f\u7528\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002");
            } else {
                statusData.user = "!core.change.account!read";
                statusData.data = new JLabel("\u8aad\u307f\u8fbc\u307f\u7528\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002");
            }
            TimelineViewTab.this.addStatus(statusData, TimelineViewTab.this.frameApi.getInfoSurviveTime());
        }

        @Override
        public void onCleanUp() {
        }

        @Override
        public void onConnect() {
        }

        @Override
        public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
            logger.trace("onDeletionNotice: {}", (Object)statusDeletionNotice);
            StatusData statusData = TimelineViewTab.this.getStatus(statusDeletionNotice.getStatusId());
            if (statusData != null) {
                if (!(statusData.tag instanceof Status)) {
                    return;
                }
                Status status = (Status)statusData.tag;
                StatusData deletionStatusData = new StatusData(statusDeletionNotice, new Date());
                deletionStatusData.backgroundColor = Color.LIGHT_GRAY;
                deletionStatusData.foregroundColor = Color.RED;
                deletionStatusData.image = new JLabel();
                deletionStatusData.sentBy = new JLabel(status.getUser().getScreenName());
                deletionStatusData.user = "!twdel." + statusDeletionNotice.getUserId();
                deletionStatusData.data = new JLabel("DELETED: " + status.getText());
                TimelineViewTab.this.addStatus(deletionStatusData, this.getInfoSurviveTime() * 2);
                TimelineViewTab.this.removeStatus(statusData, this.getInfoSurviveTime() * 2);
            }
        }

        @Override
        public void onDirectMessage(DirectMessage directMessage) {
            StatusData statusData = new StatusData(directMessage, directMessage.getCreatedAt());
            statusData.backgroundColor = Color.LIGHT_GRAY;
            statusData.foregroundColor = Color.CYAN;
            statusData.image = new JLabel();
            statusData.sentBy = new JLabel(directMessage.getSenderScreenName());
            statusData.user = "!dm." + directMessage.getSenderScreenName();
            String message = MessageFormat.format("DM\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f: \"{0}\"", directMessage.getText());
            statusData.data = new JLabel(message);
            TimelineViewTab.this.addStatus(statusData);
        }

        @Override
        public void onException(Exception ex) {
            TwitterException twex;
            StatusData statusData = new StatusData(ex, new Date());
            statusData.backgroundColor = Color.BLACK;
            statusData.foregroundColor = Color.RED;
            statusData.image = new JLabel();
            statusData.sentBy = new JLabel("!ERROR!");
            statusData.user = "!ex." + ex.getClass().getName();
            String exString = ex instanceof TwitterException ? ((twex = (TwitterException)((Object)ex)).isCausedByNetworkIssue() ? twex.getCause().toString() : twex.getStatusCode() + ": " + twex.getErrorMessage()) : ex.toString();
            if (exString.length() > 256) {
                exString = new StringBuilder().append(exString, 0, 254).append("..").toString();
            }
            statusData.data = new JLabel(exString);
            TimelineViewTab.this.addStatus(statusData);
        }

        @Override
        public void onFavorite(User source, User target, Status favoritedStatus) {
            StatusData statusData;
            if (target.getId() == TimelineViewTab.this.frameApi.getLoginUser().getId()) {
                statusData = new StatusData(favoritedStatus, new Date());
                statusData.backgroundColor = Color.GRAY;
                statusData.foregroundColor = Color.YELLOW;
                statusData.image = new JLabel(new ImageIcon(source.getProfileImageURL()));
                statusData.sentBy = new JLabel(source.getScreenName());
                statusData.user = "!fav." + source.getScreenName();
                String message = MessageFormat.format("\u3075\u3041\u307c\u3089\u308c\u307e\u3057\u305f: \"{0}\"", favoritedStatus.getText());
                statusData.data = new JLabel(message);
                TimelineViewTab.this.addStatus(statusData);
                try {
                    TimelineViewTab.this.configuration.getUtility().sendNotify(MessageFormat.format("{0} ({1})", source.getScreenName(), source.getName()), message, TimelineViewTab.this.imageCacher.getImageFile(source));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (source.getId() == TimelineViewTab.this.frameApi.getLoginUser().getId()) {
                statusData = TimelineViewTab.this.getStatus(favoritedStatus.getId());
                if (statusData.tag instanceof TwitterStatus) {
                    TwitterStatus status = (TwitterStatus)statusData.tag;
                    status.setFavorited(true);
                }
            }
        }

        @Override
        public void onFollow(User source, User followedUser) {
            if (followedUser.getId() == TimelineViewTab.this.frameApi.getLoginUser().getId()) {
                StatusData statusData = new StatusData(null, new Date());
                statusData.backgroundColor = Color.GRAY;
                statusData.foregroundColor = Color.YELLOW;
                statusData.image = new JLabel(new ImageIcon(source.getProfileImageURL()));
                statusData.sentBy = new JLabel(source.getScreenName());
                statusData.user = "!follow." + source.getScreenName();
                String message = "@" + followedUser.getScreenName() + " \u3092\u30d5\u30a9\u30ed\u30fc\u3057\u307e\u3057\u305f";
                statusData.data = new JLabel(message);
                TimelineViewTab.this.addStatus(statusData);
                try {
                    TimelineViewTab.this.configuration.getUtility().sendNotify(MessageFormat.format("{0} ({1})", source.getScreenName(), source.getName()), message, TimelineViewTab.this.imageCacher.getImageFile(source));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
            logger.trace("onTrackLimitationNotice: {}", (Object)numberOfLimitedStatuses);
            StatusData statusData = new StatusData(null, new Date());
            statusData.backgroundColor = Color.BLACK;
            statusData.foregroundColor = Color.LIGHT_GRAY;
            statusData.image = new JLabel();
            statusData.sentBy = new JLabel();
            statusData.user = "!stream.overlimit";
            statusData.data = new JLabel("TwitterStream\u306f " + numberOfLimitedStatuses + " \u30c4\u30a4\u30fc\u30c8\u6570\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3057\u305f\uff1a TrackLimitationNotice");
            TimelineViewTab.this.addStatus(statusData, this.getInfoSurviveTime() * 2);
        }

        @Override
        public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
            StatusData statusData;
            if (logger.isTraceEnabled()) {
                logger.trace("onUnFavorite: source={}, target={}, unfavoritedStatus={}", new Object[]{source, target, unfavoritedStatus});
            }
            if (target.getId() == TimelineViewTab.this.frameApi.getLoginUser().getId()) {
                statusData = new StatusData(unfavoritedStatus, new Date());
                statusData.backgroundColor = Color.GRAY;
                statusData.foregroundColor = Color.LIGHT_GRAY;
                statusData.image = new JLabel(new ImageIcon(source.getProfileImageURL()));
                statusData.sentBy = new JLabel(source.getScreenName());
                statusData.user = "!unfav." + source.getScreenName();
                String message = "\u3075\u3041\u307c\u3084\u3081\u3089\u308c\u307e\u3057\u305f: \"" + unfavoritedStatus.getText() + "\"";
                statusData.data = new JLabel(message);
                TimelineViewTab.this.addStatus(statusData);
                try {
                    TimelineViewTab.this.configuration.getUtility().sendNotify(MessageFormat.format("{0} ({1})", source.getScreenName(), source.getName()), message, TimelineViewTab.this.imageCacher.getImageFile(source));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (source.getId() == TimelineViewTab.this.frameApi.getLoginUser().getId()) {
                statusData = TimelineViewTab.this.getStatus(unfavoritedStatus.getId());
                if (statusData.tag instanceof TwitterStatus) {
                    TwitterStatus status = (TwitterStatus)statusData.tag;
                    status.setFavorited(false);
                }
            }
        }
    };
    private volatile boolean focusGained;
    private volatile boolean isDirty;

    public TimelineViewTab() {
        this.configuration.getFetchScheduler().establish(this.accountId, "my/timeline", this.getRenderer());
    }

    public TimelineViewTab(String data) throws JSONException {
        super(data);
        this.configuration.getFetchScheduler().establish(this.accountId, "my/timeline", this.getRenderer());
    }

    @Override
    public StatusPanel addStatus(StatusData statusData) {
        if (!this.focusGained && !this.isDirty) {
            this.isDirty = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineViewTab.this.configuration.refreshTab(TimelineViewTab.this);
                }
            });
        }
        return super.addStatus(statusData);
    }

    @Override
    public void focusGained() {
        super.focusGained();
        this.focusGained = true;
        this.isDirty = false;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimelineViewTab.this.configuration.refreshTab(TimelineViewTab.this);
            }
        });
    }

    @Override
    public void focusLost() {
        this.focusGained = false;
    }

    @Override
    public DefaultClientTab.DefaultRenderer getActualRenderer() {
        return this.renderer;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    protected Object getSerializedExtendedData() {
        return JSONObject.NULL;
    }

    @Override
    public String getTabId() {
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return this.isDirty ? "Timeline*" : "Timeline";
    }

    @Override
    public String getToolTip() {
        return "HomeTimeline";
    }
}

