/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.gui;

import com.twitter.Regex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.StatusPanel;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.TeeFilter;
import jp.syuriken.snsw.twclient.gui.DefaultClientTab;
import jp.syuriken.snsw.twclient.gui.TabRenderer;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.UserInfoViewActionHandler;
import jp.syuriken.snsw.twclient.internal.HTMLFactoryDelegator;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class UserInfoFrameTab
extends DefaultClientTab {
    private static final String TAB_ID = "userinfo";
    private static final Logger logger = LoggerFactory.getLogger(UserInfoFrameTab.class);
    private final Font operationFont;
    protected User user;
    protected TabRenderer renderer;
    private JScrollPane componentBio;
    private JLabel componentLocation;
    private JPanel componentOperationsPanel;
    private JLabel componentUserIcon;
    private JLabel componentUserName;
    private JLabel componentUserURL;
    private JPanel componentUserInfoPanel;
    private JPanel tabComponent;
    private boolean focusGained;
    private boolean isDirty;
    JCheckBox muteCheckBox;
    private JLabel componentTwitterLogo;
    private JEditorPane componentBioEditorPane;
    private ImageIcon imageIcon;

    public UserInfoFrameTab(JSONObject jsonObject) throws JSONException, IllegalSyntaxException {
        super(jsonObject);
        this.operationFont = this.frameApi.getUiFont().deriveFont(this.frameApi.getUiFont().getSize() - 1);
        this.renderer = new UserInfoTweetsRenderer();
        final long userId = jsonObject.getJSONObject("extended").getLong("userId");
        this.configuration.addJob(new TwitterRunnable(){

            @Override
            protected void access() throws TwitterException {
                ResponseList timeline = this.configuration.getTwitterForRead().getUserTimeline(userId);
                for (Status status : timeline) {
                    UserInfoFrameTab.this.getRenderer().onStatus(status);
                }
            }

            @Override
            protected void onException(TwitterException ex) {
                UserInfoFrameTab.this.getRenderer().onException((Exception)((Object)ex));
            }

            @Override
            public void run() {
                UserInfoFrameTab.this.setUser(this.configuration.getCacheManager().getUser(userId));
                super.run();
            }
        });
    }

    public UserInfoFrameTab(String jsonString) throws JSONException, IllegalSyntaxException {
        this(new JSONObject(jsonString));
    }

    public UserInfoFrameTab(User user) {
        this.operationFont = this.frameApi.getUiFont().deriveFont(this.frameApi.getUiFont().getSize() - 1);
        this.renderer = new UserInfoTweetsRenderer();
        this.setUser(user);
    }

    @Override
    public StatusPanel addStatus(StatusData statusData) {
        if (!this.focusGained && !this.isDirty) {
            this.isDirty = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserInfoFrameTab.this.configuration.refreshTab(UserInfoFrameTab.this);
                }
            });
        }
        return super.addStatus(statusData);
    }

    @Override
    public void focusGained() {
        super.focusGained();
        this.focusGained = true;
        this.isDirty = false;
        this.configuration.refreshTab(this);
    }

    @Override
    public void focusLost() {
        this.focusGained = false;
    }

    @Override
    public TabRenderer getActualRenderer() {
        return this.renderer;
    }

    private String getBioHtml() {
        String bio = this.user.getDescription();
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        int index = 0;
        while (index < bio.length()) {
            int end = bio.indexOf(10, index);
            if (end == -1) {
                end = bio.length();
            }
            builder.append(bio, index, end).append("<br>");
            index = end + 1;
        }
        bio = builder.toString();
        StringBuffer buffer = new StringBuffer(bio.length());
        Matcher matcher = Regex.VALID_URL.matcher(bio);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "$2<a href='$3'>$3</a>");
        }
        matcher.appendTail(buffer);
        bio = buffer.toString();
        buffer.setLength(0);
        matcher = Regex.VALID_HASHTAG.matcher(bio);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "$1<a href='http://command/hashtag!name=$3'>$2$3</a>");
        }
        matcher.appendTail(buffer);
        bio = buffer.toString();
        buffer.setLength(0);
        matcher = Regex.VALID_MENTION_OR_LIST.matcher(bio);
        while (matcher.find()) {
            String list = matcher.group(4);
            if (list == null) {
                matcher.appendReplacement(buffer, "$1<a href='http://command/userinfo!screenName=$3'>$2$3</a>");
                continue;
            }
            matcher.appendReplacement(buffer, "$1<a href='http://command/list!user=$3&listName=$4'>$2$3$4</a>");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    private JScrollPane getComponentBio() {
        if (this.componentBio == null) {
            this.componentBio = new JScrollPane();
            this.componentBio.setOpaque(false);
            this.componentBio.getViewport().setOpaque(false);
            this.componentBio.getViewport().setView(this.getComponentBioEditorPane());
        }
        return this.componentBio;
    }

    private JEditorPane getComponentBioEditorPane() {
        if (this.componentBioEditorPane == null) {
            this.componentBioEditorPane = new JEditorPane();
            this.componentBioEditorPane.setEditorKit(new HTMLEditorKitExtension());
            this.componentBioEditorPane.setContentType("text/html");
            this.componentBioEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.componentBioEditorPane.setEditable(false);
            this.componentBioEditorPane.setFont(this.frameApi.getUiFont());
            this.componentBioEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String url = e.getURL().toString();
                        if (url.startsWith("http://command/")) {
                            String command = url.substring("http://command/".length());
                            UserInfoFrameTab.this.handleAction(UserInfoFrameTab.this.getIntentArguments(command));
                        } else {
                            try {
                                UserInfoFrameTab.this.getConfiguration().getUtility().openBrowser(url);
                            }
                            catch (Exception e1) {
                                UserInfoFrameTab.this.getRenderer().onException(e1);
                            }
                        }
                    }
                }
            });
            Color bkgrnd = this.getComponentLocation().getBackground();
            this.componentBioEditorPane.setBackground(bkgrnd);
            this.componentBioEditorPane.setOpaque(false);
            this.componentBioEditorPane.setText("\u8aad\u8fbc\u4e2d...");
        }
        return this.componentBioEditorPane;
    }

    private JLabel getComponentLocation() {
        if (this.componentLocation == null) {
            this.componentLocation = new JLabel();
        }
        return this.componentLocation;
    }

    private JCheckBox getComponentMuteCheckBox() {
        if (this.muteCheckBox == null) {
            this.muteCheckBox = new JCheckBox("\u30df\u30e5\u30fc\u30c8");
            this.muteCheckBox.setEnabled(false);
            this.muteCheckBox.setFont(this.operationFont);
            this.muteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientProperties configProperties = UserInfoFrameTab.this.getConfiguration().getConfigProperties();
                    String idsString = configProperties.getProperty("core.filter.user.ids");
                    idsString = UserInfoFrameTab.this.muteCheckBox.isSelected() ? (idsString == null || idsString.trim().isEmpty() ? String.valueOf(UserInfoFrameTab.this.user.getId()) : idsString + " " + UserInfoFrameTab.this.user.getId()) : (idsString == null ? "" : idsString.replace(String.valueOf(UserInfoFrameTab.this.user.getId()), ""));
                    configProperties.setProperty("core.filter.user.ids", idsString);
                }
            });
        }
        return this.muteCheckBox;
    }

    private Component getComponentOperationsPanel() {
        if (this.componentOperationsPanel == null) {
            this.componentOperationsPanel = new JPanel();
            this.componentOperationsPanel.setLayout(new BoxLayout(this.componentOperationsPanel, 1));
            try {
                JLabel closeIcon = new JLabel(new ImageIcon(ImageIO.read(UserInfoViewActionHandler.class.getResource("/jp/syuriken/snsw/twclient/img/close16.png"))));
                closeIcon.setText("\u9589\u3058\u308b");
                closeIcon.setFont(this.operationFont);
                closeIcon.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        UserInfoFrameTab.this.getConfiguration().removeFrameTab(UserInfoFrameTab.this);
                    }
                });
                this.componentOperationsPanel.add(closeIcon);
            }
            catch (IOException e) {
                logger.warn("#getComponentOperationsPanel: Failed load resource");
            }
            this.componentOperationsPanel.add(this.getComponentMuteCheckBox());
        }
        return this.componentOperationsPanel;
    }

    private Component getComponentTweetsScrollPane() {
        return this.getScrollPane();
    }

    private Component getComponentTwitterLogo() {
        if (this.componentTwitterLogo == null) {
            Image scaledInstance = IMG_TWITTER_LOGO.getImage().getScaledInstance(16, 16, 4);
            this.componentTwitterLogo = new JLabel(new ImageIcon(scaledInstance));
            this.componentTwitterLogo.setMaximumSize(new Dimension(16, 16));
        }
        return this.componentTwitterLogo;
    }

    private JLabel getComponentUserIcon() {
        if (this.componentUserIcon == null) {
            this.componentUserIcon = new JLabel();
        }
        return this.componentUserIcon;
    }

    private JPanel getComponentUserInfo() {
        if (this.componentUserInfoPanel == null) {
            this.componentUserInfoPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.componentUserInfoPanel);
            this.componentUserInfoPanel.setLayout(layout);
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.getComponentUserIcon(), 48, 48, 48).addContainerGap(4, 4).addComponent(this.getComponentOperationsPanel())).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.getComponentTwitterLogo(), GroupLayout.Alignment.CENTER, 16, 16, 16).addComponent(this.getComponentUserName()).addComponent(this.getComponentLocation())).addGap(4, 4, 4).addComponent(this.getComponentUserURL()).addGap(4, 4, 4).addComponent(this.getComponentBio())));
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup().addComponent(this.getComponentUserIcon(), GroupLayout.Alignment.CENTER, 48, 48, 48).addComponent(this.getComponentOperationsPanel())).addGap(4, 4, 4).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.getComponentTwitterLogo(), 16, 16, 16).addComponent(this.getComponentUserName(), 64, -1, -2).addGap(16, 128, 128).addComponent(this.getComponentLocation(), 64, -1, -1)).addComponent(this.getComponentUserURL()).addComponent(this.getComponentBio(), 64, -2, Short.MAX_VALUE)));
        }
        return this.componentUserInfoPanel;
    }

    private JLabel getComponentUserName() {
        if (this.componentUserName == null) {
            this.componentUserName = new JLabel();
        }
        return this.componentUserName;
    }

    private JLabel getComponentUserURL() {
        if (this.componentUserURL == null) {
            this.componentUserURL = new JLabel();
        }
        return this.componentUserURL;
    }

    ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Icon getIcon() {
        Image image;
        if (this.imageIcon != null) {
            return this.imageIcon;
        }
        if (this.user != null && (image = this.imageCacher.getImage(this.user)) != null) {
            image = image.getScaledInstance(24, 24, 16);
            this.imageIcon = new ImageIcon(image);
            return this.imageIcon;
        }
        return null;
    }

    @Override
    public TabRenderer getRenderer() {
        if (this.teeFilter == null) {
            this.teeFilter = new TeeFilter(this.uniqId, this.getActualRenderer(), false);
        }
        return this.teeFilter;
    }

    @Override
    protected Object getSerializedExtendedData() throws JSONException {
        return new JSONObject().put("userId", this.user.getId());
    }

    @Override
    public JComponent getTabComponent() {
        this.tabComponent = new JPanel();
        GroupLayout layout = new GroupLayout(this.tabComponent);
        this.tabComponent.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getComponentUserInfo(), 128, -2, Short.MAX_VALUE).addComponent(this.getComponentTweetsScrollPane()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getComponentUserInfo(), 96, -2, -2).addComponent(this.getComponentTweetsScrollPane()));
        return this.tabComponent;
    }

    @Override
    public String getTabId() {
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.user == null) {
            stringBuilder.append("\u8aad\u8fbc\u4e2d");
        } else {
            stringBuilder.append('@').append(this.user.getScreenName());
        }
        if (this.isDirty) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getToolTip() {
        return this.user.getName() + " \u306e\u30e6\u30fc\u30b6\u30fc\u60c5\u5831";
    }

    @Override
    public void initTimeline() {
    }

    void setUser(final User user) {
        this.user = user;
        this.configuration.getFetchScheduler().establish(this.accountId, "all", this.getRenderer());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder stringBuilder = new StringBuilder();
                String location = user.getLocation();
                if (location != null) {
                    stringBuilder.append("<html><i>Location: </i>").append(location);
                    UserInfoFrameTab.this.getComponentLocation().setText(stringBuilder.toString());
                }
                UserInfoFrameTab.this.getComponentUserName().setText(MessageFormat.format("@{0} ({1})", user.getScreenName(), user.getName()));
                JLabel componentUserURL = UserInfoFrameTab.this.getComponentUserURL();
                if (user.getURL() != null) {
                    stringBuilder.setLength(0);
                    stringBuilder.append("<html>URL:&nbsp;<a style='color:blue;text-decoration: underline;'>");
                    stringBuilder.append(user.getURL()).append("</a>");
                    componentUserURL.setText(stringBuilder.toString());
                }
                componentUserURL.setCursor(Cursor.getPredefinedCursor(12));
                componentUserURL.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (user.getURL() != null) {
                            IntentArguments arg = UserInfoFrameTab.this.getIntentArguments("url").putExtra("url", user.getURL());
                            UserInfoFrameTab.this.handleAction(arg);
                        }
                    }
                });
                UserInfoFrameTab.this.configuration.getImageCacher().setImageIcon(UserInfoFrameTab.this.getComponentUserIcon(), user);
                UserInfoFrameTab.this.getComponentUserName().setText(MessageFormat.format("@{0} ({1})", user.getScreenName(), user.getName()));
                UserInfoFrameTab.this.getComponentBioEditorPane().setText(UserInfoFrameTab.this.getBioHtml());
                String idsString = UserInfoFrameTab.this.configuration.getConfigProperties().getProperty("core.filter.user.ids");
                String[] ids = idsString.split(" ");
                String userIdString = String.valueOf(user.getId());
                boolean filtered = false;
                for (String id : ids) {
                    if (!id.equals(userIdString)) continue;
                    filtered = true;
                    break;
                }
                JCheckBox componentMuteCheckBox = UserInfoFrameTab.this.getComponentMuteCheckBox();
                componentMuteCheckBox.setSelected(filtered);
                if (UserInfoFrameTab.this.frameApi.getLoginUser().getId() == user.getId()) {
                    componentMuteCheckBox.setEnabled(false);
                    componentMuteCheckBox.setToolTipText("\u305d\u3001\u305d\u308c\u306f\u3042\u306a\u305f\u306a\u3093\u3060\u304b\u3089\u306d\uff01");
                } else {
                    componentMuteCheckBox.setEnabled(true);
                }
            }
        });
    }

    public class UserInfoTweetsRenderer
    extends DefaultClientTab.DefaultRenderer {
        public UserInfoTweetsRenderer() {
            super(UserInfoFrameTab.this);
        }

        @Override
        public void onStatus(Status originalStatus) {
            if (originalStatus.getUser().getId() == UserInfoFrameTab.this.user.getId()) {
                UserInfoFrameTab.this.addStatus(originalStatus);
            }
        }
    }

    private static final class HTMLEditorKitExtension
    extends HTMLEditorKit {
        private static final long serialVersionUID = 7554202708087468592L;
        private transient HTMLEditorKit.HTMLFactory viewFactory = new HTMLFactoryDelegator();

        private HTMLEditorKitExtension() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }
    }
}

