/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.gui;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.VersionInfo;
import jp.syuriken.snsw.twclient.jni.JavaGnome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Version;

public class VersionInfoFrame
extends JFrame {
    private static Logger logger = LoggerFactory.getLogger(VersionInfoFrame.class);
    private List<LibraryInfo> libraryInfoList = new ArrayList<LibraryInfo>();
    private JSplitPane splitPane;
    private JScrollPane libraryListScrollPane;
    private JScrollPane infoTextScrollPane;
    private JTextArea infoTextPane;
    private JList<String> libraryList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getData(String resourceName) {
        BufferedReader bufferedReader = null;
        try {
            int len;
            InputStream stream = VersionInfoFrame.class.getClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                logger.error("Error reading resource, Class#getResourceAsStream returned null");
                String string = "Error reading resource, Class#getResourceAsStream returned null";
                return string;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(stream, ClientConfiguration.UTF8_CHARSET));
            char[] buf = new char[65536];
            StringBuffer stringBuffer = new StringBuffer();
            while ((len = bufferedReader.read(buf)) != -1) {
                stringBuffer.append(buf, 0, len);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("Error reading resource", (Throwable)e);
            String string = "Error reading resource";
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.warn("Failed close reader", (Throwable)e);
                }
            }
        }
    }

    public VersionInfoFrame() {
        this.initLibraryInfos();
        this.initComponents();
    }

    public boolean addLibraryInfo(LibraryInfo libraryInfo) {
        return this.libraryInfoList.add(libraryInfo);
    }

    private JTextComponent getInfoTextPane() {
        if (this.infoTextPane == null) {
            this.infoTextPane = new JTextArea();
            this.infoTextPane.setEditable(false);
            this.infoTextPane.setFont(new Font("Dialog", 0, 12));
            this.infoTextPane.setLineWrap(true);
            this.infoTextPane.setWrapStyleWord(true);
        }
        return this.infoTextPane;
    }

    private JScrollPane getInfoTextScrollPane() {
        if (this.infoTextScrollPane == null) {
            this.infoTextScrollPane = new JScrollPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.getInfoTextPane());
            this.infoTextScrollPane.setViewportView(jPanel);
        }
        return this.infoTextScrollPane;
    }

    private JList<String> getLibraryList() {
        if (this.libraryList == null) {
            this.libraryList = new JList();
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (LibraryInfo libraryName : this.libraryInfoList) {
                defaultListModel.addElement(libraryName.getName());
            }
            this.libraryList.setModel(defaultListModel);
            this.libraryList.setSelectedIndex(0);
            this.libraryList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    VersionInfoFrame.this.updateLibraryInfo(e);
                }
            });
        }
        return this.libraryList;
    }

    private JScrollPane getLibraryListScrollPane() {
        if (this.libraryListScrollPane == null) {
            this.libraryListScrollPane = new JScrollPane();
            this.libraryListScrollPane.setViewportView(this.getLibraryList());
            this.libraryListScrollPane.getVerticalScrollBar().setUnitIncrement(ClientConfiguration.getInstance().getConfigProperties().getInteger("gui.list.scroll"));
        }
        return this.libraryListScrollPane;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(1);
            this.splitPane.setLeftComponent(this.getLibraryListScrollPane());
            this.splitPane.setBottomComponent(this.getInfoTextScrollPane());
        }
        return this.splitPane;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.add(this.getSplitPane());
        this.pack();
        this.setSize(600, 450);
        this.getSplitPane().setDividerLocation(150);
    }

    private void initLibraryInfos() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("elnetw (\u30a8\u30eb\u30ca\u30c8): version").append(VersionInfo.getUniqueVersion()).append("\nTwitter Client for hitobasira").append("\n\n\u958b\u767a\u5143: Turenai Project (@ture7)").append("\n\u914d\u5e03\u5143: http://code.google.com/p/turetwcl").append("\n\nThis software included library:\n - twitter4j (").append(Version.getVersion()).append(")\n   - json\n - slf4j\n   - logback\n - twitter-text\n - java-gnome (optional");
        JavaGnome javaGnome = JavaGnome.getInstance();
        if (javaGnome.isFound()) {
            stringBuilder.append(";api=").append(javaGnome.getApiVersion()).append(";version=").append(javaGnome.getVersion());
            if (javaGnome.isDisabled()) {
                stringBuilder.append(";disabled");
            }
        } else {
            stringBuilder.append(";missing");
        }
        stringBuilder.append(')');
        this.addLibraryInfo(new LibraryInfo("version", stringBuilder.toString()));
        this.addLibraryInfo(new LibraryInfo("elnetw", VersionInfoFrame.getData("elnetw.txt")));
        this.addLibraryInfo(new LibraryInfo("twitter4j", VersionInfoFrame.getData("twitter4j.txt")));
        this.addLibraryInfo(new LibraryInfo("json.org", VersionInfoFrame.getData("json.txt")));
        this.addLibraryInfo(new LibraryInfo("slf4j", VersionInfoFrame.getData("slf4j.txt")));
        this.addLibraryInfo(new LibraryInfo("logback", VersionInfoFrame.getData("logback.txt")));
        this.addLibraryInfo(new LibraryInfo("twitter-text", VersionInfoFrame.getData("twitter-text.txt")));
        this.addLibraryInfo(new LibraryInfo("java-gnome", VersionInfoFrame.getData("java-gnome.txt")));
    }

    protected void updateLibraryInfo(ListSelectionEvent e) {
        JList<String> list = this.getLibraryList();
        String selectedValue = list.getSelectedValue();
        for (LibraryInfo libraryInfo : this.libraryInfoList) {
            if (!libraryInfo.name.equals(selectedValue)) continue;
            this.getInfoTextPane().setText(libraryInfo.getInfo());
            break;
        }
    }

    public static class LibraryInfo {
        protected String name;
        protected String info;

        public LibraryInfo(String name, String info) {
            this.name = name;
            this.info = info;
        }

        public String getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }
    }
}

