/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import javax.swing.JMenuItem;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.StatusActionHandlerBase;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import twitter4j.Status;
import twitter4j.TwitterException;

public class FavoriteActionHandler
extends StatusActionHandlerBase {
    @Override
    public JMenuItem createJMenuItem(IntentArguments arguments) {
        JMenuItem favMenuItem = new JMenuItem("\u3075\u3041\u307c\u308b(F)", 70);
        return favMenuItem;
    }

    @Override
    public void handleAction(IntentArguments arguments) throws IllegalArgumentException {
        Status status = this.getStatus(arguments);
        if (status == null) {
            this.throwIllegalArgument();
        }
        boolean favFlag = !status.isFavorited();
        String forceFlag = arguments.getExtraObj("force", String.class);
        if ("f".equals(forceFlag) || "fav".equals(forceFlag)) {
            favFlag = true;
        } else if ("u".equals(forceFlag) || "unfav".equals(forceFlag)) {
            favFlag = false;
        }
        ClientConfiguration.getInstance().addJob(new FavTask(favFlag, status));
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments arguments) {
        Status status = this.getStatus(arguments);
        if (status != null) {
            if (status instanceof TwitterStatus) {
                TwitterStatus tag = (TwitterStatus)status;
                menuItem.setText(tag.isFavorited() ? "\u3075\u3041\u307c\u3092\u89e3\u9664\u3059\u308b(F)" : "\u3075\u3041\u307c\u308b(F)");
            } else {
                menuItem.setText("\u3075\u3041\u307c\u308b(F)");
            }
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
    }

    private static class FavTask
    extends TwitterRunnable {
        private final boolean favFlag;
        private final long statusId;
        private final Status status;

        public FavTask(boolean favFlag, Status status) {
            this.favFlag = favFlag;
            this.statusId = status.getId();
            this.status = status;
        }

        @Override
        public void access() throws TwitterException {
            Status newStatus = this.favFlag ? this.configuration.getTwitterForWrite().createFavorite(this.statusId) : this.configuration.getTwitterForWrite().destroyFavorite(this.statusId);
            if (this.status instanceof TwitterStatus) {
                ((TwitterStatus)this.status).update(newStatus);
            }
        }
    }
}

