/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.StatusActionHandlerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Status;
import twitter4j.User;

public class MuteActionHandler
extends StatusActionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(MuteActionHandler.class);

    @Override
    public JMenuItem createJMenuItem(IntentArguments arguments) {
        return new JMenuItem("\u30df\u30e5\u30fc\u30c8\u306b\u8ffd\u52a0\u3059\u308b");
    }

    @Override
    public void handleAction(IntentArguments arguments) {
        User user;
        boolean isTweetedByMe;
        Status status = this.getStatus(arguments);
        if (status == null) {
            this.throwIllegalArgument();
        }
        if (status.isRetweet()) {
            status = status.getRetweetedStatus();
        }
        boolean bl = isTweetedByMe = (user = status.getUser()).getId() == this.getLoginUserId();
        if (!isTweetedByMe) {
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, 1);
            panel.setLayout(layout);
            panel.add(new JLabel("\u6b21\u306e\u30c4\u30a4\u30fc\u30c8\u3092\u30df\u30e5\u30fc\u30c8\u3057\u307e\u3059\u304b\uff1f"));
            panel.add(Box.createVerticalStrut(15));
            panel.add(new JLabel(MessageFormat.format("@{0} ({1})", user.getScreenName(), user.getName())));
            final JOptionPane pane = new JOptionPane(panel, 3, 2);
            JDialog dialog = pane.createDialog(null, "\u78ba\u8a8d");
            dialog.setDefaultCloseOperation(2);
            pane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("value") && Integer.valueOf(0).equals(pane.getValue())) {
                        ClientProperties configProperties = MuteActionHandler.this.configuration.getConfigProperties();
                        String idsString = configProperties.getProperty("core.filter.user.ids");
                        idsString = idsString == null || idsString.trim().isEmpty() ? String.valueOf(user.getId()) : idsString + " " + user.getId();
                        configProperties.setProperty("core.filter.user.ids", idsString);
                    }
                }
            });
            dialog.setVisible(true);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments arguments) {
        Status status = this.getStatus(arguments);
        if (status != null) {
            User user;
            if (status.isRetweet()) {
                status = status.getRetweetedStatus();
            }
            boolean isTweetedByMe = (user = status.getUser()).getId() == this.getLoginUserId();
            String idsString = this.configuration.getConfigProperties().getProperty("core.filter.user.ids");
            String[] ids = idsString.split(" ");
            String userIdString = String.valueOf(user.getId());
            boolean filtered = false;
            for (String id : ids) {
                if (!id.equals(userIdString)) continue;
                filtered = true;
                break;
            }
            logger.trace("filtered: {}", (Object)filtered);
            menuItem.setText("\u30df\u30e5\u30fc\u30c8\u306b\u8ffd\u52a0\u3059\u308b");
            menuItem.setToolTipText(filtered ? "\u3059\u3067\u306b\u8ffd\u52a0\u6e08\u307f\u3060\u3088\uff01" : (isTweetedByMe ? "\u305d\u308c\u306f\u3042\u306a\u305f\u306a\u3093\u3060\u304b\u3089\u306d\u3063\uff01" : null));
            menuItem.setVisible(!isTweetedByMe);
            menuItem.setEnabled(!(isTweetedByMe || filtered));
        } else {
            menuItem.setVisible(false);
            menuItem.setEnabled(false);
        }
    }
}

