/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.StatusActionHandlerBase;
import twitter4j.Status;
import twitter4j.TwitterException;

public class RemoveTweetActionHandler
extends StatusActionHandlerBase {
    @Override
    public JMenuItem createJMenuItem(IntentArguments arguments) {
        JMenuItem deleteMenuItem = new JMenuItem("\u524a\u9664(D)...", 68);
        return deleteMenuItem;
    }

    @Override
    public void handleAction(IntentArguments arguments) {
        boolean isTweetedByMe;
        final Status status = this.getStatus(arguments);
        if (status == null) {
            this.throwIllegalArgument();
        }
        boolean bl = isTweetedByMe = status.getUser().getId() == this.getLoginUserId();
        if (isTweetedByMe) {
            JPanel panel = new JPanel();
            BoxLayout layout = new BoxLayout(panel, 1);
            panel.setLayout(layout);
            panel.add(new JLabel("\u6b21\u306e\u30c4\u30a4\u30fc\u30c8\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f"));
            panel.add(Box.createVerticalStrut(15));
            panel.add(new JLabel(status.getText()));
            final JOptionPane pane = new JOptionPane(panel, 3, 2);
            JDialog dialog = pane.createDialog(null, "\u78ba\u8a8d");
            dialog.setDefaultCloseOperation(2);
            pane.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("value") && Integer.valueOf(0).equals(pane.getValue())) {
                        RemoveTweetActionHandler.this.configuration.addJob(new TweetDeleteTask(status));
                    }
                }
            });
            dialog.setVisible(true);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments arguments) {
        Status status = this.getStatus(arguments);
        if (status != null) {
            boolean isTweetedByMe = status.getUser().getId() == this.getLoginUserId();
            menuItem.setVisible(isTweetedByMe);
            menuItem.setEnabled(isTweetedByMe);
        } else {
            menuItem.setVisible(false);
            menuItem.setEnabled(false);
        }
    }

    private class TweetDeleteTask
    implements ParallelRunnable {
        private final Status status;

        public TweetDeleteTask(Status status) {
            this.status = status;
        }

        @Override
        public void run() {
            try {
                RemoveTweetActionHandler.this.configuration.getTwitterForWrite().destroyStatus(this.status.getId());
            }
            catch (TwitterException e) {
                e.printStackTrace();
            }
        }
    }
}

