/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import javax.swing.JMenuItem;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.StatusActionHandlerBase;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import twitter4j.Status;
import twitter4j.TwitterException;

public class RetweetActionHandler
extends StatusActionHandlerBase {
    private final ClientConfiguration configuration = ClientConfiguration.getInstance();

    @Override
    public JMenuItem createJMenuItem(IntentArguments args) {
        JMenuItem retweetMenuItem = new JMenuItem("\u30ea\u30c4\u30a4\u30fc\u30c8(T)", 84);
        return retweetMenuItem;
    }

    @Override
    public void handleAction(IntentArguments args) {
        Status status = this.getStatus(args);
        if (status == null) {
            this.throwIllegalArgument();
        }
        this.configuration.addJob(new RetweetTask(status));
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments args) {
        Status status = this.getStatus(args);
        if (status == null) {
            menuItem.setVisible(false);
            menuItem.setEnabled(false);
        } else {
            menuItem.setEnabled(!status.getUser().isProtected());
            menuItem.setVisible(status.getUser().getId() != this.getLoginUserId());
        }
    }

    private static class RetweetTask
    extends TwitterRunnable {
        private final Status status;

        public RetweetTask(Status status) {
            this.status = status;
        }

        @Override
        public void access() throws TwitterException {
            this.configuration.getTwitterForWrite().retweetStatus(this.status.getId());
        }
    }
}

