/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import java.text.MessageFormat;
import javax.swing.JMenuItem;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.gui.UserInfoFrameTab;
import jp.syuriken.snsw.twclient.handler.IntentArguments;
import jp.syuriken.snsw.twclient.handler.StatusActionHandlerBase;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;

public class UserInfoViewActionHandler
extends StatusActionHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(UserInfoViewActionHandler.class);

    @Override
    public JMenuItem createJMenuItem(IntentArguments arguments) {
        JMenuItem aboutMenuItem = new JMenuItem("\u30e6\u30fc\u30b6\u30fc\u306b\u3064\u3044\u3066(A)...", 65);
        return aboutMenuItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleAction(IntentArguments arguments) {
        User user = arguments.getExtraObj("user", User.class);
        if (user == null) {
            String screenName = arguments.getExtraObj("screenName", String.class);
            if (screenName == null) {
                StatusData statusData = arguments.getExtraObj("selectingPost", StatusData.class);
                if (statusData == null || !(statusData.tag instanceof Status)) throw new IllegalArgumentException("[userinfo AH] must call as userinfo!screenName=<screenName> or must statusData.tag is Status");
                Status status = (Status)statusData.tag;
                if (status.isRetweet()) {
                    status = status.getRetweetedStatus();
                }
                user = status.getUser();
            } else {
                user = new UserFetcher(screenName).getUser();
            }
        }
        ClientConfiguration configuration = ClientConfiguration.getInstance();
        UserInfoFrameTab tab = new UserInfoFrameTab(user);
        long userId = user.getId();
        configuration.addJob(new UserTimelineFetcher(tab, userId));
        configuration.addFrameTab(tab);
        configuration.focusFrameTab(tab);
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, IntentArguments arguments) {
        Status status = this.getStatus(arguments);
        if (status != null) {
            if (status.isRetweet()) {
                status = status.getRetweetedStatus();
            }
            menuItem.setText(MessageFormat.format("@{0} ({1}) \u306b\u3064\u3044\u3066(A)", status.getUser().getScreenName(), status.getUser().getName()));
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
    }

    private static final class UserTimelineFetcher
    extends TwitterRunnable {
        private final UserInfoFrameTab tab;
        private final long userId;

        private UserTimelineFetcher(UserInfoFrameTab tab, long userId) {
            this.tab = tab;
            this.userId = userId;
        }

        @Override
        protected void access() throws TwitterException {
            ResponseList timeline = this.configuration.getTwitterForRead().getUserTimeline(this.userId);
            for (Status status : timeline) {
                this.tab.getRenderer().onStatus(status);
            }
            for (Status status : this.configuration.getCacheManager().getStatusSet()) {
                if (status.getUser().getId() != this.userId) continue;
                this.tab.getRenderer().onStatus(status);
            }
        }

        @Override
        protected void onException(TwitterException ex) {
            this.tab.getRenderer().onException((Exception)((Object)ex));
        }
    }

    static final class UserFetcher
    extends TwitterRunnable {
        private final String userScreenName;
        private User user = null;

        protected UserFetcher(String userScreenName) {
            super(false);
            this.userScreenName = userScreenName;
        }

        @Override
        protected void access() throws TwitterException {
            this.user = this.configuration.getTwitterForRead().showUser(this.userScreenName);
        }

        protected User getUser() {
            this.run();
            return this.user;
        }
    }
}

