/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.init;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.init.InitCondition;
import jp.syuriken.snsw.twclient.init.InitializeException;
import jp.syuriken.snsw.twclient.init.InitializeService;
import jp.syuriken.snsw.twclient.init.Initializer;
import jp.syuriken.snsw.twclient.init.InitializerInfo;
import jp.syuriken.snsw.twclient.init.InitializerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicInitializeService
extends InitializeService {
    private static final Logger logger = LoggerFactory.getLogger(DynamicInitializeService.class);
    protected final ClientConfiguration configuration;
    protected final HashSet<String> initializedSet;
    protected HashMap<String, InitializerInfoImpl> initializerInfoMap;
    protected HashMap<String, ArrayList<InitializerInfoImpl>> initializerDependencyMap;
    protected LinkedList<InitializerInfoImpl> initQueue;
    protected Stack<InitializerInfoImpl> uninitStack;
    private HashSet<String> phaseSet;

    public static DynamicInitializeService use(ClientConfiguration configuration) throws IllegalStateException {
        DynamicInitializeService service = new DynamicInitializeService(configuration);
        InitializeService.setService(service);
        return service;
    }

    private DynamicInitializeService(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.initializerInfoMap = new HashMap();
        this.initializerDependencyMap = new HashMap();
        this.initQueue = new LinkedList();
        this.initializedSet = new HashSet();
        this.uninitStack = new Stack();
        this.phaseSet = new HashSet();
    }

    private void ensureNotCalledUninit() {
        if (this.uninitStack == null) {
            throw new IllegalStateException("Already #uninit() is called!");
        }
    }

    @Override
    public synchronized InitializeService enterPhase(String phase) throws InitializeException {
        this.ensureNotCalledUninit();
        logger.info("Entering {} phase", (Object)phase);
        this.resolve("phase-" + phase);
        this.runResolvedInitializer();
        return this;
    }

    @Override
    public InitializerInfo getInfo(String name) {
        return this.initializerInfoMap.get(name);
    }

    @Override
    public synchronized boolean isInitialized(String name) {
        this.ensureNotCalledUninit();
        return this.initializedSet.contains(name);
    }

    @Override
    public synchronized boolean isRegistered(String name) {
        this.ensureNotCalledUninit();
        return this.initializerInfoMap.containsKey(name);
    }

    @Override
    public InitializeService provideInitializer(String name) throws IllegalArgumentException {
        return this.provideInitializer(name, false);
    }

    @Override
    public InitializeService provideInitializer(String name, boolean force) {
        if (this.initializerInfoMap.containsKey(name)) {
            if (force) {
                InitializerInfoImpl initializerInfo = this.initializerInfoMap.get(name);
                initializerInfo.setSkip();
            } else {
                throw new IllegalArgumentException(name + " is already registered as initializer");
            }
        }
        this.resolve(name);
        return this;
    }

    @Override
    public synchronized InitializeService register(Object instance, Method method) throws IllegalArgumentException {
        Initializer initializer = method.getAnnotation(Initializer.class);
        if (initializer == null) {
            throw new IllegalArgumentException("method must have @Initializer annotation.");
        }
        this.register(instance, method, initializer);
        return this;
    }

    @Override
    public synchronized InitializeService register(Class<?> initClass) throws IllegalArgumentException {
        Method[] declaredMethods;
        Field[] declaredFields = initClass.getDeclaredFields();
        Object instance = null;
        for (Field field : declaredFields) {
            InitializerInstance initializerInstance = field.getAnnotation(InitializerInstance.class);
            if (initializerInstance == null) continue;
            field.setAccessible(true);
            try {
                instance = field.get(null);
                break;
            }
            catch (IllegalAccessException e) {
                logger.warn("not accessible to " + field.getName(), (Throwable)e);
            }
        }
        for (Method method : declaredMethods = initClass.getDeclaredMethods()) {
            Initializer initializer = method.getAnnotation(Initializer.class);
            if (initializer == null) continue;
            this.register(instance, method, initializer);
        }
        return this;
    }

    private void register(Object instance, Method method, Initializer initializer) throws IllegalArgumentException {
        this.ensureNotCalledUninit();
        String name = initializer.name();
        if (this.initializerInfoMap.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is already registered");
        }
        if (this.initializedSet.contains(name)) {
            throw new IllegalArgumentException("'" + name + "' is already provided");
        }
        InitializerInfoImpl initializerInfo = new InitializerInfoImpl(instance, method, initializer);
        this.initializerInfoMap.put(name, initializerInfo);
        if (initializerInfo.depCount <= 0) {
            this.initQueue.push(initializerInfo);
        }
    }

    @Override
    public InitializeService registerPhase(String phase) {
        this.phaseSet.add(phase);
        return this;
    }

    private void resolve(String name) {
        if (this.initializedSet.contains(name)) {
            return;
        }
        this.initializedSet.add(name);
        ArrayList<InitializerInfoImpl> infos = this.initializerDependencyMap.get(name);
        if (infos == null) {
            return;
        }
        for (InitializerInfoImpl info : infos) {
            info.resolveDependency(name);
            if (info.getDepCount() > 0) continue;
            this.initQueue.push(info);
        }
    }

    private void runResolvedInitializer() throws InitializeException {
        while (!this.initQueue.isEmpty()) {
            InitializerInfoImpl info = this.initQueue.poll();
            if (logger.isTraceEnabled()) {
                logger.trace(" {}{}:{}", new Object[]{info.isSkip() ? "(skip)" : "", info.getPhase(), info});
            }
            info.run(true);
            this.uninitStack.push(info);
            this.resolve(info.getName());
        }
    }

    @Override
    public void uninit() throws InitializeException {
        if (this.uninitStack == null) {
            throw new IllegalStateException("already uninitialized");
        }
        logger.info("Starting uninitializing");
        while (!this.uninitStack.isEmpty()) {
            InitializerInfoImpl info = this.uninitStack.pop();
            info.isUninitable();
            info.run(false);
        }
        this.uninitStack = null;
    }

    @Override
    public InitializeService waitConsumeQueue() throws IllegalStateException, InitializeException {
        this.ensureNotCalledUninit();
        this.runResolvedInitializer();
        return this;
    }

    protected class InitializerInfoImpl
    implements InitializerInfo {
        private final Method initializer;
        private final Initializer annotation;
        private final String phase;
        private final Object instance;
        private LinkedList<String> remainDependencies;
        private int depCount;
        private boolean isExecuted;
        private boolean uninitable;
        private boolean skip;

        public InitializerInfoImpl(Object instance, Method initializer, Initializer annotation) {
            String[] dependencies;
            this.initializer = initializer;
            this.instance = instance;
            this.annotation = annotation;
            this.phase = annotation.phase();
            if (!DynamicInitializeService.this.phaseSet.contains(this.phase)) {
                logger.warn("QA: {} has unknown phase: {}", (Object)this.toString(), (Object)this.phase);
            }
            LinkedList<String> remainDependencies = new LinkedList<String>();
            this.remainDependencies = remainDependencies;
            for (String dependency : dependencies = annotation.dependencies()) {
                if (DynamicInitializeService.this.initializedSet.contains(dependency)) continue;
                remainDependencies.add(dependency);
            }
            remainDependencies.add("phase-" + this.phase);
            ListIterator iterator = remainDependencies.listIterator();
            while (iterator.hasNext()) {
                String dependency = (String)iterator.next();
                if (DynamicInitializeService.this.initializedSet.contains(dependency)) {
                    iterator.remove();
                    continue;
                }
                ArrayList<InitializerInfoImpl> initializerInfos = DynamicInitializeService.this.initializerDependencyMap.get(dependency);
                if (initializerInfos == null) {
                    initializerInfos = new ArrayList(1);
                    DynamicInitializeService.this.initializerDependencyMap.put(dependency, initializerInfos);
                }
                initializerInfos.add(this);
            }
            this.depCount = remainDependencies.size();
            Class<?>[] parameterTypes = initializer.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(InitCondition.class)) {
                this.uninitable = true;
            }
        }

        @Override
        public Initializer getAnnotation() {
            return this.annotation;
        }

        @Override
        public int getDepCount() {
            return this.depCount;
        }

        @Override
        public String[] getDependencies() {
            return this.annotation.dependencies();
        }

        @Override
        public Method getInitializer() {
            return this.initializer;
        }

        public Object getInstance() {
            return this.instance;
        }

        @Override
        public String getName() {
            return this.annotation.name();
        }

        @Override
        public String getPhase() {
            return this.phase;
        }

        @Override
        public LinkedList<String> getRemainDependencies() {
            return this.remainDependencies;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public boolean isUninitable() {
            return this.uninitable;
        }

        public void resolveDependency(String name) {
            boolean isRemoved = this.remainDependencies.remove(name);
            if (isRemoved) {
                --this.depCount;
            }
        }

        public void run(boolean initializePhase) throws InitializeException {
            block15: {
                if (this.skip) {
                    return;
                }
                if (initializePhase && this.isExecuted) {
                    logger.error("BUG:{} is already initialized", (Object)this);
                    return;
                }
                if (!initializePhase) {
                    if (!this.isExecuted) {
                        logger.error("BUG:{} is to be uninitialized, but not executed", (Object)this);
                        return;
                    }
                    if (!this.isUninitable()) {
                        return;
                    }
                    logger.trace(" uninit: {}", (Object)this);
                }
                try {
                    Class<?>[] parameterTypes = this.initializer.getParameterTypes();
                    int parameterCount = parameterTypes.length;
                    if (parameterCount == 0) {
                        if (!initializePhase) break block15;
                        try {
                            this.initializer.invoke(this.instance, new Object[0]);
                            break block15;
                        }
                        catch (NullPointerException e) {
                            throw new InitializeException((InitializerInfo)this, e, "initializer is not static method!!");
                        }
                    }
                    if (parameterCount == 1 && parameterTypes[0].isAssignableFrom(InitCondition.class)) {
                        InitConditionImpl initCondition = new InitConditionImpl(this, initializePhase);
                        try {
                            this.initializer.invoke(this.instance, initCondition);
                        }
                        catch (NullPointerException e) {
                            throw new InitializeException((InitializerInfo)this, e, "initializer is not static method!!");
                        }
                        if (initCondition.isSetFailStatus()) {
                            throw initCondition.getException();
                        }
                        break block15;
                    }
                    throw new InitializeException(this, "Registered exception has non-usable initializer");
                }
                catch (IllegalAccessException e) {
                    throw new InitializeException((InitializerInfo)this, e, "not accessible for " + this.initializer.getName());
                }
                catch (InvocationTargetException e) {
                    throw new InitializeException((InitializerInfo)this, e.getCause(), null);
                }
            }
            this.isExecuted = true;
        }

        public void setSkip() {
            if (!this.isExecuted) {
                this.skip = true;
            }
        }

        public String toString() {
            return this.getName() + " (" + this.initializer.getDeclaringClass().getSimpleName() + "#" + this.initializer.getName() + ")";
        }
    }

    protected class InitConditionImpl
    implements InitCondition {
        private final InitializerInfoImpl initializerInfo;
        private final boolean initializingPhase;
        private InitializeException failException;

        protected InitConditionImpl(InitializerInfoImpl info, boolean isInitializingPhase) {
            this.initializerInfo = info;
            this.initializingPhase = isInitializingPhase;
        }

        @Override
        public void clearFailStatus() {
            this.failException = null;
        }

        @Override
        public ClientConfiguration getConfiguration() {
            return DynamicInitializeService.this.configuration;
        }

        protected InitializeException getException() {
            return this.failException;
        }

        @Override
        public boolean isInitializingPhase() {
            return this.initializingPhase;
        }

        @Override
        public boolean isSetFailStatus() {
            return this.failException != null;
        }

        @Override
        public void setFailStatus(Throwable cause, String reason, int exitCode) {
            this.failException = new InitializeException(this.initializerInfo, cause, reason, exitCode);
        }

        @Override
        public void setFailStatus(String reason, int exitCode) {
            this.failException = new InitializeException((InitializerInfo)this.initializerInfo, reason, exitCode);
        }
    }
}

