/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import com.twitter.Regex;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.TweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.TweetLengthUpdater;
import twitter4j.TwitterAPIConfiguration;

public class DefaultTweetLengthCalculator
implements TweetLengthCalculator {
    public static final Pattern urlPattern = Regex.VALID_URL;
    private static TwitterAPIConfiguration apiConfiguration;
    private final TweetLengthUpdater updater;

    static void clearApiConfiguration() {
        apiConfiguration = null;
    }

    public static int getTweetLength(String original) {
        if (apiConfiguration == null) {
            apiConfiguration = ClientConfiguration.getInstance().getFetchScheduler().getApiConfiguration();
        }
        int shortURLLength = apiConfiguration == null ? 22 : apiConfiguration.getShortURLLength();
        int shortURLLengthHttps = apiConfiguration == null ? 23 : apiConfiguration.getShortURLLengthHttps();
        int length = original.length();
        Matcher matcher = urlPattern.matcher(original);
        while (matcher.find()) {
            int start = matcher.start(3);
            int end = matcher.end(3);
            String protocol = matcher.group(4);
            int newUrlLength = "https://".equalsIgnoreCase(protocol) ? shortURLLengthHttps : shortURLLength;
            int fat = end - start - newUrlLength;
            length -= fat;
        }
        return length;
    }

    public DefaultTweetLengthCalculator(TweetLengthUpdater updater) {
        this.updater = updater;
    }

    @Override
    public void calcTweetLength(String original) {
        int length = DefaultTweetLengthCalculator.getTweetLength(original);
        Color color = length > 140 ? Color.RED : (length > 120 ? Color.ORANGE : Color.BLUE);
        this.updater.updatePostLength(String.valueOf(length), color, null);
    }

    @Override
    public String getShortenedText(String original) {
        return original;
    }
}

