/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import jp.syuriken.snsw.twclient.internal.FetchEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSupport {
    private static final int BUFFER_SIZE = 65536;
    private static final Logger logger = LoggerFactory.getLogger(NetworkSupport.class);
    public static final NullFetchEventHandler NULL_FETCH_EVENT_HANDLER = new NullFetchEventHandler();

    private static byte[] copyOfRange(byte[] data, int imageLen) {
        return data.length == imageLen ? data : Arrays.copyOfRange(data, 0, imageLen);
    }

    public static byte[] fetchContents(URL url) throws InterruptedException {
        return NetworkSupport.fetchContents(url, NULL_FETCH_EVENT_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fetchContents(URL url, FetchEventHandler handler) throws InterruptedException {
        URLConnection connection = null;
        InputStream stream = null;
        try {
            int loadLen;
            connection = url.openConnection();
            int contentLength = connection.getContentLength();
            handler.onContentLength(contentLength);
            stream = connection.getInputStream();
            int bufLength = contentLength < 0 ? 65536 : contentLength;
            byte[] data = new byte[bufLength];
            int imageLen = 0;
            while ((loadLen = stream.read(data, imageLen, bufLength - imageLen)) != -1) {
                if (loadLen == 0 && bufLength == (imageLen += loadLen)) {
                    int nextByte = stream.read();
                    if (nextByte == -1) break;
                    if ((bufLength <<= 1) < 0) {
                        bufLength = Integer.MAX_VALUE;
                    }
                    byte[] newData = new byte[bufLength];
                    System.arraycopy(data, 0, newData, 0, imageLen);
                    newData[imageLen++] = (byte)nextByte;
                    data = newData;
                }
                handler.onLoaded(imageLen);
                logger.trace("Image: Loaded {} bytes: buffer {}/{}", new Object[]{loadLen, imageLen, bufLength});
                Thread.sleep(1L);
            }
            byte[] byArray = NetworkSupport.copyOfRange(data, imageLen);
            return byArray;
        }
        catch (IOException e) {
            handler.onException(connection, e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("fail closing stream", (Throwable)e);
                }
            }
        }
    }

    private static class NullFetchEventHandler
    implements FetchEventHandler {
        private NullFetchEventHandler() {
        }

        @Override
        public void onContentLength(int contentLength) {
        }

        @Override
        public void onException(URLConnection connection, IOException e) {
        }

        @Override
        public void onLoaded(int imageLen) {
        }
    }
}

