/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import com.twitter.Regex;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.TweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.DefaultTweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.TweetLengthUpdater;
import twitter4j.TwitterAPIConfiguration;

public class QuoteTweetLengthCalculator
implements TweetLengthCalculator {
    private static final Pattern qtPattern = Pattern.compile("[QR]T\\s?@[a-zA-Z0-9_]{1,20}:?+");
    private static final Pattern tokenPattern = Pattern.compile("(?:" + Regex.VALID_URL + "|" + Regex.VALID_HASHTAG + "|" + Regex.VALID_MENTION_OR_LIST + ")", 2);
    private static final Pattern urlPattern = Regex.VALID_URL;
    private final TweetLengthUpdater updater;
    private TwitterAPIConfiguration apiConfiguration;
    private int shortURLLength = 22;
    private int shortURLLengthHttps = 23;

    public QuoteTweetLengthCalculator(TweetLengthUpdater api) {
        this.updater = api;
    }

    @Override
    public void calcTweetLength(String original) {
        this.initUrlLength();
        int length = original.length();
        boolean shortened = false;
        Matcher qtMatcher = qtPattern.matcher(original);
        if (qtMatcher.find()) {
            int qtIndex = qtMatcher.end();
            Matcher matcher = urlPattern.matcher(original);
            int fat = 0;
            int fatBeforeQT = 0;
            while (matcher.find()) {
                int start = matcher.start(3);
                int end = matcher.end(3);
                String protocol = matcher.group(4);
                int newUrlLength = "https://".equalsIgnoreCase(protocol) ? this.shortURLLengthHttps : this.shortURLLength;
                fat += end - start - newUrlLength;
                if (end >= qtIndex) continue;
                fatBeforeQT = fat;
            }
            if (length - fat > 140) {
                shortened = true;
                length = qtMatcher.end() - fatBeforeQT;
            } else {
                length -= fat;
            }
        } else {
            length = DefaultTweetLengthCalculator.getTweetLength(original);
        }
        Color color = length > 140 ? Color.RED : (length > 120 ? Color.ORANGE : Color.BLUE);
        if (shortened) {
            this.updater.updatePostLength(length + "+", color, "\u77ed\u7e2e\u3055\u308c\u307e\u3059 (\u5b9f\u969b\u306e\u6295\u7a3f\u306f" + this.getShortenedText(original).length() + "\u6587\u5b57\u3067\u3059)");
        } else {
            this.updater.updatePostLength(String.valueOf(length), color, null);
        }
    }

    @Override
    public String getShortenedText(String original) {
        this.initUrlLength();
        Matcher qtMatcher = qtPattern.matcher(original);
        if (original.length() <= 140 || !qtMatcher.find()) {
            return original;
        }
        int qtTokenStart = qtMatcher.start();
        int qtTokenEnd = qtMatcher.end();
        int userTextLength = DefaultTweetLengthCalculator.getTweetLength(original.substring(0, qtTokenStart));
        int qtLength = qtTokenEnd - qtTokenStart;
        Matcher tokenMatcher = tokenPattern.matcher(original.substring(qtTokenEnd));
        int remainLength = 140 - userTextLength - qtLength;
        if (remainLength <= 0) {
            return original.substring(0, qtTokenEnd);
        }
        int fat = 0;
        while (tokenMatcher.find()) {
            int oldFat = fat;
            int start = tokenMatcher.start();
            int end = tokenMatcher.end();
            Matcher urlMatcher = urlPattern.matcher(tokenMatcher.group());
            if (urlMatcher.find()) {
                String protocol = urlMatcher.group(4);
                int newUrlLength = "https://".equalsIgnoreCase(protocol) ? this.shortURLLengthHttps : this.shortURLLength;
                fat += end - (start += urlMatcher.start(3)) - newUrlLength;
            } else {
                Matcher hashtagMatcher = Regex.VALID_HASHTAG.matcher(tokenMatcher.group());
                if (hashtagMatcher.find()) {
                    start += hashtagMatcher.start(2);
                } else {
                    Matcher mentionMatcher = Regex.VALID_MENTION_OR_LIST.matcher(tokenMatcher.group());
                    if (mentionMatcher.find()) {
                        start += mentionMatcher.start(2);
                    } else {
                        throw new AssertionError();
                    }
                }
            }
            if (start - oldFat > remainLength) {
                return original.substring(0, qtTokenEnd + remainLength + oldFat);
            }
            if (end - fat <= remainLength) continue;
            return original.substring(0, qtTokenEnd + start);
        }
        return original.substring(0, qtTokenEnd + remainLength + fat);
    }

    private void initUrlLength() {
        if (this.apiConfiguration == null) {
            this.apiConfiguration = ClientConfiguration.getInstance().getFetchScheduler().getApiConfiguration();
            if (this.apiConfiguration != null) {
                this.shortURLLength = this.apiConfiguration.getShortURLLength();
                this.shortURLLengthHttps = this.apiConfiguration.getShortURLLengthHttps();
            }
        }
    }
}

