/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public class ScrollUtility {
    private static final int MAX_SPEED = 100;
    private final JScrollPane scrollPane;
    private final BoundsTranslator translator;
    int deltaY;
    Timer scrollTimer;
    JComponent target;
    private boolean momemtumEnabled;

    public ScrollUtility(final JScrollPane scrollPane, BoundsTranslator translator, boolean momemtumEnabled) {
        this.scrollPane = scrollPane;
        this.translator = translator;
        this.momemtumEnabled = momemtumEnabled;
        if (momemtumEnabled) {
            this.scrollTimer = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ScrollUtility.this.isInside(ScrollUtility.this.target)) {
                        ScrollUtility.this.deltaY = 0;
                        ScrollUtility.this.scrollTimer.stop();
                        return;
                    }
                    Point viewPosition = scrollPane.getViewport().getViewPosition();
                    int vectorY = ScrollUtility.this.getVectorY(viewPosition);
                    ScrollUtility.this.momemtumTranslate(vectorY);
                    viewPosition.translate(0, ScrollUtility.this.deltaY);
                    scrollPane.getViewport().setViewPosition(viewPosition);
                }
            });
        }
    }

    protected int getVectorY(Point viewPosition) {
        Rectangle bounds = this.translator.translate(this.target);
        int vectorY = viewPosition.y > bounds.y ? bounds.y - viewPosition.y : bounds.y + bounds.height - (viewPosition.y + this.scrollPane.getViewport().getHeight());
        return vectorY;
    }

    boolean isInside(JComponent component) {
        Point viewPosition = this.scrollPane.getViewport().getViewPosition();
        Rectangle bounds = this.translator.translate(component);
        return viewPosition.y <= bounds.y && viewPosition.y + this.scrollPane.getViewport().getHeight() >= bounds.y + bounds.height;
    }

    private void momemtumTranslate(int vectorY) {
        if (Math.abs(vectorY) < 5) {
            this.deltaY = vectorY;
        } else if (Math.abs(this.deltaY) * 2 > Math.abs(vectorY)) {
            this.deltaY /= 2;
        } else {
            if (Math.abs(vectorY) > 100) {
                vectorY = vectorY > 0 ? 100 : -100;
            }
            this.deltaY = (this.deltaY + vectorY) / 2;
            if (Math.abs(this.deltaY) > 100) {
                this.deltaY = this.deltaY > 0 ? 100 : -100;
            }
        }
    }

    public boolean scrollTo(JComponent target) {
        if (this.momemtumEnabled) {
            this.target = target;
            this.scrollTimer.stop();
            if (this.isInside(target)) {
                return false;
            }
            this.scrollTimer.start();
            return true;
        }
        this.target = target;
        if (this.isInside(target)) {
            return false;
        }
        Point viewPosition = this.scrollPane.getViewport().getViewPosition();
        this.scrollPane.getViewport().setViewPosition(new Point(0, viewPosition.y + this.getVectorY(viewPosition)));
        return true;
    }

    public static interface BoundsTranslator {
        public Rectangle translate(JComponent var1);
    }
}

