/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.StatusPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedPostListPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -6160168801034111076L;
    private static final Logger logger = LoggerFactory.getLogger(SortedPostListPanel.class);
    private static final String PROPERTY_LEAF_SIZE = "gui.splp.leaf_size";
    private static final String PROPERTY_MAX_SIZE = "gui.splp.max_size";
    private static final String PROPERTY_LIMIT_ELAPSED_TIME = "gui.splp.limit_elapsed_time";
    private static final String PROPERTY_BUCKET_SIZE = "gui.splp.bucket_size";
    private int leafSize;
    private int maxContainSize;
    private LinkedList<JPanel> branches;
    private int size;
    private long limitElapsedTime;
    private Bucket bucket;
    private int bucketMaxSize;

    private static int binarySearch(JComponent panel, StatusPanel key, int start) {
        int low = start;
        int high = panel.getComponentCount() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            StatusPanel midVal = (StatusPanel)panel.getComponent(mid);
            int cmp = midVal.compareTo(key);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            throw new IllegalArgumentException("duplicate id");
        }
        return low;
    }

    private static boolean checkOverTime(long limitTime) {
        return System.currentTimeMillis() > limitTime;
    }

    protected static int compareDate(StatusPanel a, StatusPanel b) {
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    private static int getProperty(String key) {
        return ClientConfiguration.getInstance().getConfigProperties().getInteger(key);
    }

    public SortedPostListPanel() {
        this(SortedPostListPanel.getProperty(PROPERTY_LEAF_SIZE), SortedPostListPanel.getProperty(PROPERTY_MAX_SIZE));
    }

    public SortedPostListPanel(int leafSize, int maxSize) {
        this.setLayout(new BoxLayout(this, 1));
        this.leafSize = leafSize;
        this.maxContainSize = maxSize;
        this.branches = new LinkedList();
        ClientConfiguration.getInstance().getConfigProperties().addPropertyChangedListener(this);
        this.limitElapsedTime = SortedPostListPanel.getProperty(PROPERTY_LIMIT_ELAPSED_TIME);
        this.bucketMaxSize = SortedPostListPanel.getProperty(PROPERTY_BUCKET_SIZE);
        this.bucket = new Bucket(this.bucketMaxSize);
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        if (comp instanceof StatusPanel) {
            LinkedList<StatusPanel> list = new LinkedList<StatusPanel>();
            list.add((StatusPanel)comp);
            this.add(list);
            return comp;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public Component add(Component comp, int index) {
        return this.add(comp);
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints) {
        this.add(comp);
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints, int index) {
        this.add(comp);
    }

    public synchronized int add(LinkedList<StatusPanel> values) {
        if (values.size() == 0) {
            return 0;
        }
        Bucket bucket = this.bucket;
        long limitTime = System.currentTimeMillis() + this.limitElapsedTime;
        bucket.make(values, this.bucketMaxSize);
        ListIterator<JPanel> listIterator = this.branches.listIterator();
        while (listIterator.hasNext()) {
            JPanel branch = (JPanel)listIterator.next();
            this.addPanelIntoBranch(bucket, branch, listIterator, limitTime, false);
            if (!bucket.isEmpty() && !SortedPostListPanel.checkOverTime(limitTime)) continue;
            break;
        }
        if (!bucket.isEmpty() && !SortedPostListPanel.checkOverTime(limitTime)) {
            JPanel branch;
            if (this.branches.isEmpty()) {
                branch = this.createPanel();
                this.branches.add(branch);
                super.add(branch);
            } else {
                branch = this.branches.getLast();
            }
            this.addPanelIntoBranch(bucket, branch, this.branches.listIterator(this.branches.size()), limitTime, true);
        }
        this.tryRelease();
        if (logger.isTraceEnabled()) {
            logger.trace("took {}ms: {}/{}", new Object[]{System.currentTimeMillis() + this.limitElapsedTime - limitTime, bucket.processedSize(), bucket.size()});
            this.assertSequence();
        }
        this.validate();
        return bucket.processedSize();
    }

    public void add(StatusPanel panel) {
        LinkedList<StatusPanel> list = new LinkedList<StatusPanel>();
        list.add(panel);
        this.add(list);
    }

    @Override
    @Deprecated
    public Component add(String name, Component comp) {
        return this.add(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPanelIntoBranch(Bucket values, JPanel branch, ListIterator<JPanel> listIteratorOfBranches, long limitTime, boolean addAll) {
        StatusPanel lastOfBranch;
        StatusPanel statusPanel = lastOfBranch = addAll ? null : (StatusPanel)branch.getComponent(branch.getComponentCount() - 1);
        if (SortedPostListPanel.compareDate(values.peek(), lastOfBranch) >= 0) {
            Object object = branch.getTreeLock();
            synchronized (object) {
                boolean panelAppendFlag;
                int insertPos = 0;
                do {
                    StatusPanel panel = values.poll();
                    insertPos = SortedPostListPanel.binarySearch(branch, panel, insertPos);
                    branch.add((Component)panel, insertPos);
                    ++this.size;
                } while (!values.isEmpty() && !SortedPostListPanel.checkOverTime(limitTime) && SortedPostListPanel.compareDate(values.peek(), lastOfBranch) >= 0);
                int componentCount = branch.getComponentCount();
                boolean bl = panelAppendFlag = componentCount > this.leafSize << 1;
                if (panelAppendFlag) {
                    int i;
                    int min = componentCount >>> 1;
                    int len = componentCount - min;
                    Component[] array = new Component[len];
                    JPanel panel = this.createPanel();
                    for (i = len - 1; i >= 0; --i) {
                        int j = min + i;
                        array[i] = branch.getComponent(j);
                        branch.remove(j);
                    }
                    for (i = 0; i < len; ++i) {
                        panel.add(array[i]);
                    }
                    int indexOfAddedPanel = listIteratorOfBranches.nextIndex();
                    listIteratorOfBranches.add(panel);
                    super.add((Component)panel, indexOfAddedPanel);
                }
            }
        }
    }

    private void assertSequence() {
        StatusPanel previous = null;
        for (JPanel panel : this.branches) {
            for (Component comp : panel.getComponents()) {
                StatusPanel status = (StatusPanel)comp;
                if (previous != null && SortedPostListPanel.compareDate(previous, status) <= 0) {
                    throw new AssertionError();
                }
                previous = status;
            }
        }
    }

    protected JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        return panel;
    }

    public synchronized Rectangle getBoundsOf(StatusPanel panel) {
        if (panel == null) {
            throw new NullPointerException();
        }
        Rectangle bounds = panel.getBounds();
        for (JPanel branch : this.branches) {
            int componentCount;
            StatusPanel lastComponent = (StatusPanel)branch.getComponent((componentCount = branch.getComponentCount()) - 1);
            if (SortedPostListPanel.compareDate(panel, lastComponent) < 0) continue;
            Rectangle branchBounds = branch.getBounds();
            bounds.y += branchBounds.y;
            break;
        }
        return bounds;
    }

    @Override
    public StatusPanel getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    @Override
    public StatusPanel getComponentAt(int x, int y) {
        JPanel parentPanel = (JPanel)super.getComponentAt(x, y);
        if (parentPanel == this && (parentPanel = this.branches.peekFirst()) == null) {
            return null;
        }
        Point bounds = parentPanel.getLocation();
        Component componentAt = parentPanel.getComponentAt(x - bounds.x, y - bounds.y);
        if (!(componentAt instanceof StatusPanel)) {
            componentAt = parentPanel.getComponent(0);
        }
        return (StatusPanel)componentAt;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "gui.splp.bucket_size": {
                this.bucketMaxSize = SortedPostListPanel.getProperty(PROPERTY_BUCKET_SIZE);
                break;
            }
            case "gui.splp.leaf_size": {
                this.leafSize = SortedPostListPanel.getProperty(PROPERTY_LEAF_SIZE);
                break;
            }
            case "gui.splp.limit_elapsed_time": {
                this.limitElapsedTime = SortedPostListPanel.getProperty(PROPERTY_LIMIT_ELAPSED_TIME);
                break;
            }
            case "gui.splp.max_size": {
                this.maxContainSize = SortedPostListPanel.getProperty(PROPERTY_MAX_SIZE);
            }
        }
    }

    public synchronized boolean remove(StatusPanel value) {
        for (JPanel container : this.branches) {
            if (SortedPostListPanel.compareDate((StatusPanel)container.getComponent(container.getComponentCount() - 1), value) >= 0) continue;
            container.remove(value);
            --this.size;
            return true;
        }
        return false;
    }

    public synchronized boolean requestFocusFirstComponent() {
        Component panel = this.branches.getFirst().getComponent(0);
        return panel != null && panel.requestFocusInWindow();
    }

    public synchronized boolean requestFocusNextOf(StatusPanel panel) {
        for (JPanel branch : this.branches) {
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)branch.getComponent(0)) > 0) {
                return branch.getComponent(0).requestFocusInWindow();
            }
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)branch.getComponent(branch.getComponentCount() - 1)) <= 0) continue;
            Component[] components = branch.getComponents();
            for (int i = 0; i < components.length - 1; ++i) {
                StatusPanel statusPanel = (StatusPanel)components[i];
                if (SortedPostListPanel.compareDate(panel, statusPanel) != 0) continue;
                return components[i + 1].requestFocusInWindow();
            }
        }
        return false;
    }

    public synchronized boolean requestFocusPreviousOf(StatusPanel panel) {
        ListIterator<JPanel> iterator = this.branches.listIterator(this.branches.size());
        while (iterator.hasPrevious()) {
            JPanel previous = iterator.previous();
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)previous.getComponent(previous.getComponentCount() - 1)) < 0) {
                return previous.getComponent(previous.getComponentCount() - 1).requestFocusInWindow();
            }
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)previous.getComponent(0)) >= 0) continue;
            Component[] components = previous.getComponents();
            for (int i = components.length - 1; i > 0; --i) {
                StatusPanel statusPanel = (StatusPanel)components[i];
                if (SortedPostListPanel.compareDate(panel, statusPanel) != 0) continue;
                return components[i - 1].requestFocusInWindow();
            }
        }
        return false;
    }

    @Override
    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SortedPostListPanel{leaf=").append(this.leafSize).append(",max=").append(this.maxContainSize).append(",size=").append(this.size);
        stringBuilder.append("}[");
        for (JPanel container : this.branches) {
            stringBuilder.append(container.getComponentCount()).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private synchronized void tryRelease() {
        while (this.branches.size() > 1 && this.size > this.maxContainSize + this.leafSize) {
            this.remove(this.getComponentCount() - 1);
            this.size -= this.branches.removeLast().getComponentCount();
        }
    }

    protected static final class ComponentComparator
    implements Comparator<StatusPanel> {
        public static final ComponentComparator SINGLETON = new ComponentComparator();

        private ComponentComparator() {
        }

        @Override
        public int compare(StatusPanel o1, StatusPanel o2) {
            return -SortedPostListPanel.compareDate(o1, o2);
        }
    }

    private static class Bucket {
        private static final Logger logger = LoggerFactory.getLogger(Bucket.class);
        private StatusPanel[] bucket;
        private int startIndex;
        private int nextIndex;
        private int len;

        public Bucket(int maxSize) {
            this.bucket = new StatusPanel[maxSize];
        }

        public boolean isEmpty() {
            return this.nextIndex >= this.len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void make(LinkedList<StatusPanel> list, int maxSize) {
            int newSize;
            int remainedSize = this.len - this.nextIndex;
            if (remainedSize > maxSize >>> 1) {
                logger.trace("skip make bucket: {}", (Object)remainedSize);
                this.startIndex = this.nextIndex;
                return;
            }
            LinkedList<StatusPanel> linkedList = list;
            synchronized (linkedList) {
                newSize = remainedSize + list.size();
                if (newSize > maxSize) {
                    newSize = maxSize;
                }
                if (newSize > this.bucket.length) {
                    StatusPanel[] newBucket = new StatusPanel[maxSize];
                    System.arraycopy(this.bucket, this.nextIndex, newBucket, 0, remainedSize);
                    this.bucket = newBucket;
                } else if (remainedSize > 0) {
                    System.arraycopy(this.bucket, this.nextIndex, this.bucket, 0, remainedSize);
                }
                int index = remainedSize;
                while (!list.isEmpty()) {
                    this.bucket[index++] = list.pollFirst();
                    if (index < newSize) continue;
                }
                logger.trace("{}+{}/{}", new Object[]{remainedSize, newSize - remainedSize, this.bucket.length});
            }
            Arrays.sort(this.bucket, 0, newSize, ComponentComparator.SINGLETON);
            this.nextIndex = 0;
            this.startIndex = 0;
            this.len = newSize;
        }

        public StatusPanel peek() {
            return this.isEmpty() ? null : this.bucket[this.nextIndex];
        }

        public StatusPanel poll() {
            return this.isEmpty() ? null : this.bucket[this.nextIndex++];
        }

        public int processedSize() {
            return this.nextIndex - this.startIndex;
        }

        public int size() {
            return this.len - this.startIndex;
        }
    }
}

