/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.awt.GraphicsEnvironment;
import java.awt.TrayIcon;
import java.io.File;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.MessageNotifier;
import jp.syuriken.snsw.twclient.ParallelRunnable;

public class TrayIconMessageNotifier
implements MessageNotifier,
ParallelRunnable {
    private final ClientConfiguration configuration;
    private TrayIcon trayIcon;
    private LinkedList<Object[]> queue = new LinkedList();
    private long lastNotified;

    public static boolean checkUsable(ClientConfiguration configuration) {
        return !GraphicsEnvironment.isHeadless();
    }

    public TrayIconMessageNotifier(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.trayIcon = configuration.getTrayIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LinkedList<Object[]> linkedList = this.queue;
        synchronized (linkedList) {
            long tempTime = this.lastNotified + 5000L;
            if (tempTime > System.currentTimeMillis()) {
                this.configuration.getTimer().schedule(new Runnable(){

                    @Override
                    public void run() {
                        TrayIconMessageNotifier.this.run();
                    }
                }, tempTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                return;
            }
            Object[] arr = this.queue.poll();
            if (arr == null) {
                return;
            }
            String summary = (String)arr[0];
            String text = (String)arr[1];
            this.trayIcon.displayMessage(summary, text, TrayIcon.MessageType.INFO);
            this.lastNotified = System.currentTimeMillis();
            if (this.queue.size() > 0) {
                this.configuration.addJob((byte)4, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotify(String summary, String text, File imageFile) {
        LinkedList<Object[]> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(new Object[]{summary, text});
            if (this.queue.size() == 1) {
                this.configuration.addJob((byte)4, this);
            }
        }
    }
}

