/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import jp.syuriken.snsw.twclient.ClientConfiguration;
import twitter4j.TwitterException;

public abstract class TwitterRunnable
implements Runnable {
    private int life = 10;
    private boolean intoQueue;
    protected ClientConfiguration configuration;

    public TwitterRunnable() {
        this(true);
    }

    public TwitterRunnable(boolean intoQueue) {
        this.intoQueue = intoQueue;
        this.configuration = ClientConfiguration.getInstance();
    }

    protected abstract void access() throws TwitterException;

    @Deprecated
    protected ClientConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void onException(TwitterException ex) {
        this.configuration.getFrameApi().handleException(ex);
    }

    @Override
    public void run() {
        --this.life;
        try {
            this.access();
        }
        catch (TwitterException ex) {
            int statusCode = ex.getStatusCode();
            if (502 <= statusCode && statusCode <= 504 && this.life >= 0) {
                if (this.intoQueue) {
                    this.configuration.addJob(this);
                } else {
                    this.run();
                }
            }
            this.onException(ex);
        }
    }
}

