/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.jni;

import java.lang.reflect.InvocationTargetException;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGnome {
    private static final Logger logger = LoggerFactory.getLogger(JavaGnome.class);
    private static JavaGnome INSTANCE;
    private final ClassLoader extraClassLoader = ClientConfiguration.getInstance().getExtraClassLoader();
    private final Class<?> versionClass;

    public static synchronized JavaGnome getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaGnome();
        }
        return INSTANCE;
    }

    public JavaGnome() {
        Class<?> versionClass1;
        try {
            versionClass1 = Class.forName("org.freedesktop.bindings.Version", true, this.extraClassLoader);
        }
        catch (ClassNotFoundException e) {
            versionClass1 = null;
        }
        this.versionClass = versionClass1;
    }

    public String getApiVersion() {
        if (this.versionClass == null) {
            return null;
        }
        try {
            return (String)this.versionClass.getMethod("getAPI", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.warn("#getApiVersion", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warn("#getApiVersion", e.getCause());
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public String getVersion() {
        if (this.versionClass == null) {
            return null;
        }
        try {
            return (String)this.versionClass.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.warn("#getVersion", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warn("#getVersion", e.getCause());
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean isDisabled() {
        return Boolean.getBoolean("elnetw.java-gnome.disable");
    }

    public boolean isFound() {
        return this.versionClass != null;
    }
}

