/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.net;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientMessageListener;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import jp.syuriken.snsw.twclient.net.DataFetcher;
import jp.syuriken.snsw.twclient.net.TimelineFetcher;
import jp.syuriken.snsw.twclient.net.TwitterDataFetchScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public class DirectMessageFetcher
extends TwitterRunnable
implements DataFetcher {
    private static final Logger logger = LoggerFactory.getLogger(TimelineFetcher.class);
    private final ClientConfiguration configuration;
    private final int intervalOfDirectMessage;
    private final ClientProperties configProperties;
    private final ClientMessageListener listeners;
    private final TwitterDataFetchScheduler twitterDataFetchScheduler;
    private final String accountId;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile Twitter twitter;

    public DirectMessageFetcher(TwitterDataFetchScheduler twitterDataFetchScheduler, String accountId) {
        this.twitterDataFetchScheduler = twitterDataFetchScheduler;
        this.accountId = accountId;
        this.listeners = twitterDataFetchScheduler.getListeners(accountId, "direct_messages");
        this.configuration = ClientConfiguration.getInstance();
        this.configProperties = this.configuration.getConfigProperties();
        this.intervalOfDirectMessage = this.configProperties.getInteger("twitter.dm.interval");
    }

    @Override
    protected synchronized void access() throws TwitterException {
        ResponseList directMessages = this.twitter.getDirectMessages(new Paging().count(this.configProperties.getInteger("twitter.dm.count")));
        for (DirectMessage dm : directMessages) {
            this.listeners.onDirectMessage(dm);
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public synchronized void disconnect() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    protected void onException(TwitterException ex) {
        this.listeners.onException((Exception)ex);
    }

    @Override
    public synchronized void realConnect() {
        if (this.scheduledFuture == null) {
            this.twitter = new TwitterFactory(this.twitterDataFetchScheduler.getTwitterConfiguration(this.accountId)).getInstance();
            this.scheduledFuture = this.configuration.getTimer().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    DirectMessageFetcher.this.configuration.addJob((byte)4, DirectMessageFetcher.this);
                }
            }, 0L, this.intervalOfDirectMessage, TimeUnit.SECONDS);
        }
    }
}

