/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.net;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientMessageListener;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import jp.syuriken.snsw.twclient.net.DataFetcher;
import jp.syuriken.snsw.twclient.net.TwitterDataFetchScheduler;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public class TimelineFetcher
extends TwitterRunnable
implements DataFetcher {
    private final ClientConfiguration configuration;
    private final int intervalOfTimeline;
    private final ClientProperties configProperties;
    private final ClientMessageListener listeners;
    private final TwitterDataFetchScheduler twitterDataFetchScheduler;
    private final String accountId;
    private volatile Twitter twitter;
    private volatile ScheduledFuture<?> scheduledFuture;

    public TimelineFetcher(TwitterDataFetchScheduler twitterDataFetchScheduler, String accountId) {
        this.twitterDataFetchScheduler = twitterDataFetchScheduler;
        this.accountId = accountId;
        this.listeners = twitterDataFetchScheduler.getListeners(accountId, "statuses/timeline");
        this.configuration = ClientConfiguration.getInstance();
        this.configProperties = this.configuration.getConfigProperties();
        this.intervalOfTimeline = this.configProperties.getInteger("twitter.timeline.interval");
    }

    @Override
    protected synchronized void access() throws TwitterException {
        ResponseList timeline = this.twitter.getHomeTimeline(new Paging().count(this.configProperties.getInteger("twitter.timeline.count")));
        for (Status status : timeline) {
            this.listeners.onStatus(status);
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public synchronized void disconnect() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    protected void onException(TwitterException ex) {
        this.listeners.onException((Exception)ex);
    }

    @Override
    public synchronized void realConnect() {
        if (this.scheduledFuture == null) {
            this.twitter = new TwitterFactory(this.twitterDataFetchScheduler.getTwitterConfiguration(this.accountId)).getInstance();
            this.scheduledFuture = this.configuration.getTimer().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TimelineFetcher.this.configuration.addJob((byte)4, TimelineFetcher.this);
                }
            }, 0L, this.intervalOfTimeline, TimeUnit.SECONDS);
        }
    }
}

