/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.net;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientMessageListener;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import jp.syuriken.snsw.twclient.net.DataFetcher;
import jp.syuriken.snsw.twclient.net.DataFetcherFactory;
import jp.syuriken.snsw.twclient.net.VirtualMultipleMessageDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;

public class TwitterDataFetchScheduler {
    private static final Logger logger = LoggerFactory.getLogger(TwitterDataFetchScheduler.class);
    static final Iterator<ClientMessageListener> NULL_ITERATOR = Collections.emptyIterator();
    static final Iterable<ClientMessageListener> NULL_LISTENERS = new NullIterable();
    public static final String READER_ACCOUNT_ID = "$reader";
    public static final String WRITER_ACCOUNT_ID = "$writer";
    final ClientConfiguration configuration;
    protected HashMap<String, String[]> virtualPathMap = new HashMap();
    protected HashMap<String, DataFetcherFactory> fetcherMap = new HashMap();
    protected LinkedHashMap<String, DataFetcher> pathMap = new LinkedHashMap();
    protected HashMap<String, CopyOnWriteArrayList<ClientMessageListener>> pathListenerMap = new HashMap();
    protected HashMap<String, CopyOnWriteArrayList<DataFetcher>> userListenerMap = new HashMap();
    Twitter twitterForRead;
    ClientProperties configProperties;
    TwitterAPIConfiguration apiConfiguration;
    private volatile boolean isInitialized;

    private static String getAppended(StringBuilder builder, String appendedString) {
        int oldLength = builder.length();
        String ret = builder.append(appendedString).toString();
        builder.setLength(oldLength);
        return ret;
    }

    public TwitterDataFetchScheduler() {
        this.configuration = ClientConfiguration.getInstance();
        this.configProperties = this.configuration.getConfigProperties();
        this.init();
    }

    public synchronized DataFetcherFactory addFetcherFactory(String notifierName, DataFetcherFactory factory) {
        return this.fetcherMap.put(notifierName, factory);
    }

    public synchronized String[] addVirtualNotifier(String virtualPath, String[] notifiers) {
        return this.virtualPathMap.put(virtualPath, notifiers);
    }

    public synchronized void cleanUp() {
        Collection<DataFetcher> entries = this.pathMap.values();
        for (DataFetcher entry : entries) {
            entry.disconnect();
        }
    }

    public synchronized boolean establish(String accountId, String notifierName, ClientMessageListener listener) {
        String path = this.getPath(accountId, notifierName);
        CopyOnWriteArrayList<ClientMessageListener> messageListeners = this.pathListenerMap.get(path);
        if (messageListeners == null) {
            messageListeners = new CopyOnWriteArrayList();
            this.pathListenerMap.put(path, messageListeners);
        }
        messageListeners.add(listener);
        String[] virtualPaths = this.virtualPathMap.get(notifierName);
        if (virtualPaths != null) {
            for (String virtualPath : virtualPaths) {
                this.establish(accountId, virtualPath, listener);
            }
        } else {
            DataFetcher dataFetcher = this.pathMap.get(path);
            if (dataFetcher == null) {
                DataFetcherFactory factory = this.fetcherMap.get(notifierName);
                if (factory == null) {
                    if (!notifierName.endsWith("all")) {
                        logger.warn("DataFetcher `{}' is not found.", (Object)notifierName);
                    }
                    return false;
                }
                dataFetcher = factory.getInstance(this, accountId, notifierName);
                this.pathMap.put(path, dataFetcher);
                CopyOnWriteArrayList<DataFetcher> userListeners = this.userListenerMap.get(accountId);
                if (userListeners == null) {
                    userListeners = new CopyOnWriteArrayList();
                    this.userListenerMap.put(accountId, userListeners);
                }
                userListeners.add(dataFetcher);
                dataFetcher.connect();
                if (this.isInitialized) {
                    dataFetcher.realConnect();
                }
            }
        }
        return true;
    }

    public TwitterAPIConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    Iterable<ClientMessageListener> getInternalListeners(String path) {
        CopyOnWriteArrayList<ClientMessageListener> listeners = this.pathListenerMap.get(path);
        return listeners == null ? NULL_LISTENERS : listeners;
    }

    public ClientMessageListener getListeners(String accountId, String ... notifierName) {
        return this.getListeners(accountId, true, notifierName);
    }

    public ClientMessageListener getListeners(String accountId, boolean recursive, String ... notifierName) {
        return new VirtualMultipleMessageDispatcher(this, recursive, accountId, notifierName);
    }

    public String getPath(String accountId, String notifierName) {
        return accountId + ":" + notifierName;
    }

    public String[] getRecursivePaths(String accountId, String notifierName) {
        TreeSet<String> paths = new TreeSet<String>();
        this.getRecursivePaths(paths, accountId, notifierName);
        return paths.toArray(new String[paths.size()]);
    }

    public void getRecursivePaths(Collection<String> paths, String accountId, String notifierName) {
        String[] notifierDirs = notifierName.split("/");
        StringBuilder builder = new StringBuilder(accountId).append(':');
        paths.add(TwitterDataFetchScheduler.getAppended(builder, "all"));
        int max = notifierDirs.length - 1;
        for (int i = 0; i < max; ++i) {
            if (i != 0) {
                builder.append('/');
            }
            builder.append(notifierDirs[i]);
            paths.add(TwitterDataFetchScheduler.getAppended(builder, "/all"));
        }
        paths.add(this.getPath(accountId, notifierName));
    }

    public Configuration getTwitterConfiguration(String accountId) {
        if (accountId.equals(READER_ACCOUNT_ID)) {
            return this.configuration.getTwitterConfiguration(this.configuration.getAccountIdForRead());
        }
        if (accountId.equals(WRITER_ACCOUNT_ID)) {
            return this.configuration.getTwitterConfiguration(this.configuration.getAccountIdForWrite());
        }
        return this.configuration.getTwitterConfiguration(accountId);
    }

    protected void init() {
        this.twitterForRead = this.configuration.getTwitterForRead();
        this.scheduleGettingTwitterApiConfiguration();
    }

    public void onChangeAccount(boolean forWrite) {
        if (forWrite) {
            this.relogin(WRITER_ACCOUNT_ID);
        } else {
            this.relogin(READER_ACCOUNT_ID);
        }
    }

    public synchronized void onInitialized() {
        this.isInitialized = true;
        for (DataFetcher fetcher : this.pathMap.values()) {
            fetcher.realConnect();
        }
    }

    private synchronized void relogin(String accountId) {
        CopyOnWriteArrayList<DataFetcher> clientMessageListeners = this.userListenerMap.get(accountId);
        if (clientMessageListeners == null) {
            return;
        }
        for (DataFetcher fetcher : clientMessageListeners) {
            fetcher.disconnect();
            fetcher.connect();
            if (!this.isInitialized) continue;
            fetcher.realConnect();
        }
    }

    private void scheduleGettingTwitterApiConfiguration() {
        this.configuration.addJob(new ApiConfigurationFetcher());
    }

    private final class ApiConfigurationFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private ApiConfigurationFetcher() {
        }

        @Override
        protected void access() throws TwitterException {
            TwitterDataFetchScheduler.this.apiConfiguration = TwitterDataFetchScheduler.this.twitterForRead.getAPIConfiguration();
        }
    }

    private static class NullIterable
    implements Iterable<ClientMessageListener> {
        private NullIterable() {
        }

        @Override
        public Iterator<ClientMessageListener> iterator() {
            return NULL_ITERATOR;
        }
    }
}

