static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************************/
/* <clfunc.c>                                          */
/*      func                                           */
/*******************************************************/
#include "colmn.h"

extern CLCOMMON  CLcommon;
extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];
extern condList  CLcList;	/* 񃊃Xg */
extern CLNCB     CLSTCB;	/* ^O̍\͂s߂̗̈ */
extern tdtIterate_ctl gtIter_ctl[];

static uchar gucCodeType = '\0';

/*******************************************************/
/* cl_func_process                                     */
/* function; Exec Function.                            */
/*******************************************************/
int cl_func_process(proc)
ProcCT *proc;
{
	ScrPrCT *pScCT;
	int rc,iSel;
	char *pSel;
	ONTBL   *pOntbl;

	rc = 0;
/* Check specified function has been registered & execute. */
	if (!strcmp(proc->ProcNM,D_EPNM_INPUT)) {
		if (proc->INPCB.curlen >= proc->INPCB.maxlen) {
			pScCT = cl_search_src_ct();
#ifdef OLD_COAL
			if (pScCT->OnSelect >= 0) {
				pOntbl = pScCT->ONCOND[pScCT->OnSelect];
				if (*pOntbl->PrName[2]) {
					if ((iSel=pOntbl->PrSel[2]) == D_PRSEL_IP) {
						if (rc=cl_execute_proc(pOntbl->PrName[2])) return rc;
					}
					else {
						/* iSel=%d hoȊÓAsł܂B */
						ERROROUT1(FORMAT(391),iSel);
						return rc = ECL_EX_INPUT;
					}
				}
				*(pOntbl->PrName[2]) = '\0';
			}
			else
				cmn_set_stat(RET_PR,&proc->ptype,L_ON);
#else
			if (pScCT->OnSelect >= 0) {
				pOntbl = pScCT->ONCOND[pScCT->OnSelect];
				if (*pOntbl->PrName[2] &&
				    cmn_chk_stat(GR3_PR,&pScCT->ptype) != L_OFF) {
					cmn_set_stat(GR3_PR,&pScCT->ptype,L_OFF);
					if (rc=cl_input_exec_proc(pOntbl->PrSel[2],pOntbl->PrName[2])) return rc;
				}
				else
					cmn_set_stat(RET_PR,&proc->ptype,L_ON);
			}
#endif
		}
		else {
			rc = input();
/*
printf("input return = %d\n",rc);
*/
		}
		if (rc==0 && cmn_chk_stat( RET_PR , &proc->ptype )){
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd)
				return(rc);
			else
				return(ECL_SYSTEM_ERROR);
		}
	}
	else if (!strcmp(proc->ProcNM,D_EPNM_INPUTXML)) {
		rc = input_xml(0);
		if (rc==0 && cmn_chk_stat(RET_PR,&proc->ptype)) {
		/*	akxt_set_code_type(gucCodeType);	*/
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd) return(rc);
			else return(ECL_SYSTEM_ERROR);
		}
	}
	else if (!strcmp(proc->ProcNM,D_EPNM_SELMAIN)) {
		if (cmn_chk_stat(SEL_ED,&pCLprocTable->SearchSt) != L_OFF) {
			/* Erase ProcCt & restart previous process */
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd) {
			/*	rc = cl_execute_script();	*/
				return(rc);
			}
			else
				return(ECL_SYSTEM_ERROR);
		}
		else
			rc = cl_sel_main();
		if (cmn_chk_stat(SEL_ED,&pCLprocTable->SearchSt) != L_OFF ) {
			/* Erase ProcCt & restart previous process */
			cmn_set_stat(SEL_ED,&pCLprocTable->SearchSt,L_OFF);
			if (cl_er_lk_proc_ct()) return(ECL_SYSTEM_ERROR);
			return(rc);
		}
	}
	else
		rc = ECL_SYSTEM_ERROR;
	if (rc) cl_er_lk_proc_ct();
	return(rc);
}

/****************************************/
/*										*/
/****************************************/
int cl_fflush()
{
	ProcCT *proc;
	ScrPrCT *scrct;
	tdtREDIRECT *red;
	FILE *fp;

	if (proc = cl_search_proc_ct())
		red = proc->redirect;
	else if (scrct = cl_search_src_ct())
		red = scrct->redirect;
	else
		return -1;
	if (!(fp = red->stdio[1])) fp = stdout;
	fflush(fp);
	if (!(fp = red->stdio[2])) fp = stderr;
	fflush(fp);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_system(p1)
char *p1;
{
	char *pWork,*p,work[256],*pW;
	FILE *fp;
	tdtInfoParm tInfoParm,*ppParm[2];
	int ret,i,reset,len,lw,iParm[5],opt;
	ParList pa_dat;

	opt = cl_get_option(7,0);
	if (CLcommon.Flags[0] && CLcommon.Flags[1]) {
		if (opt & 0x100) {
/*
printf("cl_system:system: p1=[%s]\n",p1);
*/
			ret = system(p1);
			if (ret == -1) {
				pGlobTable->err_no = errno;
				pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,errno);
				pGlobTable->error = ret;
				ERROROUT3("cl_ex_shell: [%s] errno=%d %s",p1,errno,strerror(errno));
			}
			else ret = ret>>8 & 0xff;
		}
		else {
			ERROROUT2(FORMAT(640),"cl_system","shell");	/* %s: ̊ł́A%s ͎sł܂B*/
					/* %s: sIvV70x0100IɂĎsĉB
					   sACoalɂ͕Â܂܏I܂B*/
			ERROROUT1(FORMAT(641),"cl_system");
		}
	}
	else {
		len = strlen(p1);
	/*
		len = akxtstrim2(0,p1,len,&pa_dat,NULL);
		p1 = pa_dat.par;
	*/
/*
printf("cl_system: len=%d p1=[%s]\n",len,p1);
*/
		if (cl_get_option(25,0) & 0x80) {
			if (!inmemstr(p1,len,CLcommon.pSTDERR2STDOUT[0])) {
				p1 = stradd5(p1," ",CLcommon.pSTDERR2STDOUT[1],NULL,NULL);
/*
printf("cl_system:stradd5: p1=[%s]\n",p1);
*/
				len = strlen(p1);
			}
		}
		ppParm[0] = &tInfoParm;
		cl_set_parm_char(&tInfoParm,p1,len);
		pWork = work;
		if ((ret=func_file(&pWork,"POPEN",1,ppParm,D_FUC_POPEN,iParm)) < 0) return ret;
		if (ret = pGlobTable->error) return ret;
		memcpy(&fp,pWork,sizeof(FILE *));
/*
printf("cl_system: fp=%08x\n",fp);
*/
		for (;;) {
			cl_set_parm_long(&tInfoParm,fp);
			if ((ret=func_file(&pW,"FGETLINE",1,ppParm,D_FUC_FGETLINE,iParm)) < 0) break;
			if (ret = pGlobTable->error) {
				if (ret == ECL_END_OF_FILE) ret = 0;
				break;
			}
			p = pW;
			len = iParm[1];
/*
printf("cl_system: len=%d p=[%s]\n",len,p);
*/
			cl_set_parm_char(&tInfoParm,p,len);
			if ((ret=func_file(&pWork,"PUTLINE",1,ppParm,D_FUC_PUTLINE,iParm)) < 0) break;
			if (ret = pGlobTable->error) break;
		}
		cl_set_parm_long(&tInfoParm,fp);
		ret = func_file(&pWork,"PCLOSE",1,ppParm,D_FUC_PCLOSE,iParm);
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_shell(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,len;
	long lVal;
	char w1[32],*p1;

	pGlobTable->err_no = 0;
	ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) return len;
/*
printf("cl_ex_shell: len=%d p1=[%s]\n",len,p1);
*/
	if (len > 0) {
#if 1	/* 2022.8.30 */
		if ((ret=cl_fflush()) < 0) return ret;
#else
		fflush(stdout);
#endif
#if 1	/* 2022.9.1 */
		ret = cl_system(p1);
#else
		ret = system(p1);
		if (ret == -1) {
			pGlobTable->err_no = errno;
			pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,errno);
			pGlobTable->error = ret;
			ERROROUT3("cl_ex_shell: [%s] errno=%d %s",p1,errno,strerror(errno));
		}
		else ret = ret>>8 & 0xff;
#endif
	}
	else {
		ERROROUT(FORMAT(392));		/* cl_ex_shell: 󕶂łB */
	}
	lVal = ret;
	memcpy(pWork,&lVal,sizeof(long));
	if (ret && (cl_get_option(7,0) & 0x80)) ret = ECL_SCRIPT_ERROR;
	else ret = 0;

	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_no_free(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,opt;
	long lVal;

	if (nparm > 0) {
		if (ret=cl_get_parm_bin(ppParm[0],&opt,"cl_ex_no_free:")) return -1;
	}
	else opt = 0;
	ret = Nofree(opt);
	lVal = ret;
	memcpy(pWork,&lVal,sizeof(long));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_eval(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,flag,opt;
	char w1[32],*p1;

	pGlobTable->error = 0;
	opt = flag = 0;
	if (nparm >= 2) {
		if (ret=cl_get_parm_bin(ppParm[1],&flag,"eval flag:")) return -1;
		if (flag & 0x01) opt = D_GX_OPT_NOEROUT_NDEF;
	}
	p1 = w1;
	if ((ret = parm_to_char(ppParm[0],&p1,NULL)) >= 0) {
		if ((ret=cl_gx_expsn_obj_opt(p1,ret,NULL,NULL,pInfoParmW,opt))<0) {
							/* cl_ex_eval: Ă܂Bret=%d */
			if (!(flag & 0x01)) ERROROUT2(FORMAT(48),"cl_ex_eval",ret);
		}
		else if (ret==100) {
			ERROROUT1(FORMAT(185),"cl_ex_eval");	/* cl_ex_eval: ܂B */
		}
	}
	if (flag & 0x02) {
		if (pGlobTable->error = ret) {
			pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,ret);
			ret = cl_null_data(pInfoParmW);
		}
	}
/*
DEBUGOUT_InfoParm(150,"cl_ex_eval: ret=%d",pInfoParmW,ret,0);
*/
	return ret;
}
#ifdef D_FOR_AKB	/* _head_check */
/****************************************/
/*										*/
/****************************************/
static int _head_check(pCh,pData,lLen)
tdtChannel *pCh;
char *pData;
long lLen;
{
	ERROROUT2("Channel head_check: channel=%d len=%d",pCh->index,lLen);
/*
	aka_channel_command(pCh,1,101);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _exception(iCh,iEvent)
int iCh,iEvent;
{
	ERROROUT3("Channel exception: channel=%d event=%d %s",
	iCh,iEvent,aka_channel_event_msg(iEvent,0));
	return -1;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_ex_channel(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,i,iVal[2],iRc,iOpt;
	long lVal;

	pGlobTable->err_no = 0;
#ifdef D_FOR_AKB
	char cmd;
	char w0[32],*p0;
	char w1[32],*p1;
	char w2[32],*p2;
	tdtChannelOpen tChannel;

	p0 = w0;
	p1 = w1;
	p2 = w2;
	iVal[0] = iVal[1] = iRc = 0;

	if ((ret = parm_to_char(ppParm[0],&p0,NULL)) < 0) {
		return ret;
	}
	cmd = toupper(*p0);
	if (cmd == 'O') {
		if (nparm < 3) {
			ERROROUT2("cl_ex_channel:%s:parameter(n=%d) is few!!",p0,nparm);
			ret = -1;
			goto Err;
		}
		if ((ret = parm_to_char(ppParm[1],&p1,NULL)) < 0) {
			goto Err;
		}
		if ((ret = parm_to_char(ppParm[2],&p2,NULL)) < 0) {
			goto Err;
		}
		for (i=3;i<=nparm-1;i++) {
			if (ret=cl_get_parm_bin(ppParm[i],&iVal[i-3],"HeadLen/Options:")) {
				if (ret > 0) ret = -1;
				goto Err;
			}
		}
		if (!iVal[0]) {
			iVal[1] |= AKA_CHSO_USE_AKB_HEAD;
		}

		memset(&tChannel,0,sizeof(tdtChannelOpen));
		tChannel.host_name = p1;
		tChannel.service  = p2;
		tChannel.head_len   = iVal[0];
		tChannel.opt      = iVal[1];
		tChannel.head_check  = _head_check;
		tChannel.exception  = _exception;
		if ((iRc = aka_channel_open(&tChannel)) <= 0) {
			pGlobTable->err_no = errno;
			ERROROUT1("cl_ex_channel: aka_channel_open ret=%d",iRc);
			if (!iRc) iRc = -1;
			pGlobTable->error = iRc;
		}
		ret = 0;
	}
	else {
		if (ret=cl_get_parm_bin(ppParm[1],&iVal[0],"Channel No:")) {
			if (ret > 0) ret = -1;
			goto Err;
		}
		if (nparm >= 3) {
			if (ret=cl_get_parm_bin(ppParm[2],&iVal[1],"Option:")) {
				if (ret > 0) ret = -1;
				goto Err;
			}
		}
		if (cmd =='S') {
			ret = aka_channel_shut(iVal[0],iVal[1]);
		}
		else if (cmd =='R') {
			ret = aka_channel_resume(iVal[0],iVal[1]);
		}
		else if (cmd =='C') {
			ret = aka_channel_close(iVal[0]);
		}
		else {
			ERROROUT1("cl_ex_channel: Invalid command=[%s]",p1);
			ret = -1;
		}
		pGlobTable->err_no = errno;
	}
Err:
#else
	ret = iRc = 0;
#endif
	lVal = iRc;
	memcpy(pWork,&lVal,sizeof(long));
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_null_chk_null_parm(pInfoParm)
tdtInfoParm *pInfoParm;
{
	int ret;

	ret = 0;
DEBUGOUT_InfoParm(194,"cl_is_null:",pInfoParm,0,0);
	if (cl_is_null_parm(pInfoParm)) {
		ret = 1;
	}
	else if (cl_is_null_data(pInfoParm)) ret = 1;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_nval(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm;
	int  ret;

	if (nparm >= 3) return ECL_TOO_PARAMETER;

	pInfoParm = ppParm[0];
DEBUGOUT_InfoParm(194,"cl_ex_nval: nparm=%d",pInfoParm,nparm,0);
	ret = cl_is_null_chk_null_parm(pInfoParm);
	if (ret >= 0) {
		if (ret > 0) pInfoParm = ppParm[1];
#if 1	/* 2021.10.27 */
		cl_gx_copy_info_opt(pInfoParmW,pInfoParm,1);
		ret = 0;
#else
		ret = cl_gx_rep_info_set(pInfoParmW,pInfoParm,D_GX_OPT_ALC_TMP);
#endif
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_nsval(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm;
	int  ret;

	if (nparm >= 3) return ECL_TOO_PARAMETER;

	pInfoParm = ppParm[0];
DEBUGOUT_InfoParm(194,"cl_ex_nsval: nparm=%d",pInfoParm,nparm,0);
	ret = cl_is_null_chk_null_parm(pInfoParm);
	if (ret >= 0) {
		if (!ret) ret = cl_is_spaces(pInfoParm);
		if (ret >= 0) {
			if (ret > 0) pInfoParm = ppParm[1];
#if 1	/* 2021.10.27 */
			cl_gx_copy_info_opt(pInfoParmW,pInfoParm,1);
			ret = 0;
#else
			ret = cl_gx_rep_info_set(pInfoParmW,pInfoParm,D_GX_OPT_ALC_TMP);
#endif
		}
	}
	return ret;
}

#if 1	/*2021.8.4 */
/****************************************/
/*										*/
/****************************************/
static int _ndef_kind(ret,pInfoParmW)
int ret;
tdtInfoParm *pInfoParmW;
{
	int rc;

	rc = 0;
	if (ret) {
		if (ret == ECL_NDEFVAR_ERROR) rc = 1;
		else if (ret == ECL_NO_DATA_ERROR) rc = 2;
	}
	else {
		if (cl_is_null_parm(pInfoParmW)) rc = 3;
		else if (cl_is_undef_parm(pInfoParmW)) rc = 1;
	}
	return rc;
}
#endif

/****************************************/
/*										*/
/****************************************/
int cl_ex_ndef(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,rc,opt,nf,opt1;
	char *p1;

	if (nparm >= 4) return ECL_TOO_PARAMETER;

	ret = opt1 = opt = 0;
	p1 = NULL;
	if ((ret = parm_to_char(ppParm[0],&p1,NULL)) >= 0) {
		if (nparm >= 3) {
			if ((rc=cl_get_parm_bin(ppParm[2],&opt,"opt:")) < 0) return rc;
/*
printf("cl_ex_nde: opt=%d\n",opt);
*/
			opt1 = opt & 0x01;
		}
		ret = cl_gx_expsn_obj_opt(p1,ret,NULL,NULL,pInfoParmW,D_GX_OPT_NOEROUT_NDEF);
/*
DEBUGOUT_InfoParm(0,"cl_ex_ndef: ret=%d",pInfoParmW,ret,0);
*/
#if 1	/*2021.8.4 */
		rc = _ndef_kind(ret,pInfoParmW);
		if (rc > 0) {
#else
		if (ret==ECL_NDEFVAR_ERROR || ret==ECL_NO_DATA_ERROR ||
		    (!ret && (cl_is_undef_parm(pInfoParmW)||cl_is_null_parm(pInfoParmW)))) {
#endif
			ret = 0;
			if (opt1) {
#if 1	/*2021.8.4 */
				ret = cl_set_parm_bin(pInfoParmW,rc);
#else
				ret = cl_set_parm_bin(pInfoParmW,1);
#endif
			}
			else {
				if (nparm > 1) {
					if (cl_is_null_parm(ppParm[1])) nf = 1;
					else nf = 0;
				}
				else nf = 1;
				if (nf) ret = cl_null_data(pInfoParmW);
				else
#if 1	/* 2021.10.27 */
					cl_gx_copy_info_opt(pInfoParmW,ppParm[1],1);
#else
					ret = cl_gx_rep_info_set(pInfoParmW,ppParm[1],D_REP_IGN_OUT_DATA|D_GX_OPT_ALC_TMP);
#endif
			}
		}
		else if (ret==100) {
		}
		else if (opt1) {
			ret = cl_set_parm_bin(pInfoParmW,0);
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_ndef(pInfoParm)
tdtInfoParm *pInfoParm;
{
	tdtInfoParm InfoParmW,*pInfoParmW;
	int  ret,rc;
	char *p1;

	ret = 0;
	pInfoParmW = &InfoParmW;
	p1 = NULL;
	if ((ret = parm_to_char(pInfoParm,&p1,NULL)) >= 0) {
		ret = cl_gx_expsn_obj_opt(p1,ret,NULL,NULL,pInfoParmW,D_GX_OPT_NOEROUT_NDEF);
#if 1	/*2021.8.4 */
		rc = _ndef_kind(ret,pInfoParmW);
		if (rc > 0) {
			ret = rc;
#else
		if (ret==ECL_NDEFVAR_ERROR || ret==ECL_NO_DATA_ERROR ||
		    (!ret && (cl_is_undef_parm(pInfoParmW)||cl_is_null_parm(pInfoParmW)))) {
			ret = 1;
#endif
		}
		else if (ret==100) {
			cl_parm_set0(pInfoParm);
			ret = -1;
		}
		else {
			cl_gx_rep_info_set_ign(pInfoParm,pInfoParmW,D_GX_OPT_ALC_TMP);
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_spaces(pInfoParm)
tdtInfoParm *pInfoParm;
{
	int  ret,atr,len;
	char *p1;

	ret = 0;
	atr = pInfoParm->pi_attr;
	if (atr == 1) {
		p1 = NULL;
		if ((len = parm_to_char(pInfoParm,&p1,NULL)) > 0) {
/*
printf("cl_is_spaces: len=%d p1=[%s]\n",len,p1);
*/
			if (akxnskipin(p1,len," \t\r\n") >= len) ret = 1;
		}
		else ret = len;
	}
/*
printf("cl_is_spaces: ret=%d\n",ret);
*/
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_shut_ctl(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	char val[2];
	long ret;

	ret = aka_shut_control(AKA_SHUT_GET,val);
	memcpy(pWork,&ret,sizeof(long));
	return 0;
}

/************************************/
/*									*/
/************************************/
static int _push_exit(leaf,proc)
Leaf   *leaf;
ProcCT *proc;
{
	static parmList Retprmlist,*wprmp[2];
	static char	*retprm="TRY_EXIT";
	static Leaf	Retleaf;
	Leaf	*retleaf;
	parmList *retprmlist;

	retleaf = &Retleaf;
	retprmlist = &Retprmlist;
	memset(retleaf,0,sizeof(Leaf));
	retleaf->cmd.cid    = C_LET;
	retleaf->cmd.sub_cid= CS_TRY_EXIT;
	retleaf->cmd.prmnum = 1;
	retleaf->cmd.prmp   = wprmp;
	retleaf->cmd.prmp[0]= retprmlist;
	retprmlist->prmlen  = strlen(retprm);
	retprmlist->prp     = retprm;
	retprmlist->opt     = D_GX_OPT_NO_USE_OBJ;
	cl_ret_leaf_push(proc,retleaf);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_exit(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int rc,val;
	long lVal;
	ProcCT  *proc;
	tdtInfoParm *pInfoParmW;

	if (nparm > 0) {
		if (rc = cl_get_parm_bin(ppParm[0],&val,"Exit: ")) return rc;
		pGlobTable->error = val;
	}
	else val = 0;
/*
printf("cl_ex_exit: val=%08x\n",val);
*/
	if (proc = cl_search_proc_ct()) {
		if (cmn_chk_stat(UFN_PR,&proc->ptype)) {
			if (pInfoParmW=proc->Retval) {
				cl_set_parm_bin(pInfoParmW,val);
DEBUGOUT_InfoParm(110,"cl_ex_exit: proc=%s",pInfoParmW,proc->ProcNM,0);
			}
		}
	}
	lVal = val;
	memcpy(pWork,&lVal,sizeof(long));
	if (pGlobTable->try_level) cmn_set_stat(TRY_EXIT,&pCLprocTable->ScrSt,L_ON);
	else cmn_set_stat(SCR_ED,&pCLprocTable->ScrSt,L_ON);
	if (proc && proc->ucExcept > 0) {
		rc = cl_back_with_finally(NULL,proc,_push_exit);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_exit_finally()
{
	int rc;
	ProcCT  *proc;

	if (pGlobTable->try_level) cmn_set_stat(TRY_EXIT,&pCLprocTable->ScrSt,L_ON);
	else cmn_set_stat(SCR_ED,&pCLprocTable->ScrSt,L_ON);
	if (proc = cl_search_proc_ct()) {
		if (proc->ucExcept > 0) {
			rc = cl_back_with_finally(NULL,proc,_push_exit);
		}
	}
	else rc = -1;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_conv_parm(pInfoParmW,pOperator,nparm,ppParm,dummy,opt)
tdtInfoParm *pInfoParmW;
char *pOperator;
tdtInfoParm *ppParm[];
int  dummy,opt,nparm;
{
	char w1[32],*p1,*p,op,c;
	parmList qprmList;
	int  i,len,ret,*pSize,*index,val;
	ScrPrCT *scrct;
	ProcCT  *proc;
	tdtInfoParm *pInfoParm,tInfoParm,***pTBL_pas;
	tdtArrayIndex tIndex;
	uchar ucLOCAL=0;
	ParList par_pSize;

DEBUGOUTL3(110,"cl_func_conv_parm:Enter pOperator=[%s] nparm=%d opt=%08x",pOperator,nparm,opt);

/*	opt &= (D_GX_OPT_STORE | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);	*/
	opt &= (D_GX_OPT_STORE | D_GX_OPT_SET_SCOPE);
	scrct = cl_search_src_ct();
	c = *pOperator;
	if (nparm <= 0) {
		/* Create MappedArray Name */
		memset(&tIndex,0,sizeof(tdtArrayIndex));
		tIndex.uAttr[0] = DEF_ZOK_VARI;
		tIndex.size = sizeof(tdtInfoParm *);
		index = tIndex.index;
		index[0] = 1;
		index[1] = 1;
		index[2] = 0;
		for (i=0;i<4;i++) index[i+3] = 1;
		if      (c == '$') pSize = (int *)scrct->Vary->pTBL_dolu[0];
		else if (c == '#') pSize = (int *)scrct->Vary->pTBL_igeta[0];
		else if (c == '%') {
			if (opt & D_GX_OPT_SET_LOCAL) {
				if (!(proc=cl_search_proc_ct())) return -1;
				if (!(pTBL_pas=proc->pTBL_pasento)) return -1;
				ucLOCAL = D_AUX1_LOCAL_VAR;
			}
			else pTBL_pas =scrct->Vary->pTBL_pasento;
			pSize = (int *)pTBL_pas[0];
		}
		index[2] = pSize[7];
		if (c == '$') {
			index[4] = pSize[2] - (index[3] - 1);
		}
		else {
			index[4] = index[2];
		}
		index[1] = index[4];
/*
printf("cl_func_conv_parm: index=%d %d %d %d %d %d %d\n",
index[0],index[1],index[2],index[3],index[4],index[5],index[6]);
*/
		memset(&tInfoParm,0,sizeof(tdtInfoParm));
		tInfoParm.pi_id   = 'A';
		tInfoParm.pi_scale = 0;
		tInfoParm.pi_attr = DEF_ZOK_BULK;
		tInfoParm.pi_dlen  = sizeof(tdtArrayIndex);
		if (!(tInfoParm.pi_data = cl_tmp_const_malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		tInfoParm.pi_aux[1] = ucLOCAL;
		memcpy(tInfoParm.pi_data,&tIndex,sizeof(tdtArrayIndex));
		if (!(p=cl_tmp_const_malloc(sizeof(tdtInfoParm)+4))) {
			ERROROUT("Array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		pInfoParm = (tdtInfoParm *)p;
		p += sizeof(tdtInfoParm);
		sprintf(p,"%c()",c);
		tInfoParm.pi_pos = (long)p;
		*pInfoParm = tInfoParm;
		ret = 0;
DEBUGOUT_InfoParm(110,"cl_func_conv_parm: name=%s",pInfoParm,p,0);
	}
	else {
		p1 = w1;
		if ((ret=parm_to_char(ppParm[0],&p1,NULL)) < 0) return ret;	/* nparm-1 */
/*
printf("cl_func_conv_parm: ope=[%s] p1=[%s]\n",pOperator,p1);
*/
		len = strlen(p1);
		if (p = cl_tmp_const_malloc(len+strlen(pOperator)+1)) {
			strcpy(p,pOperator);
			strcat(p,p1);
			qprmList.prmlen  = strlen(p);
			qprmList.prp     = p;
			if (opt & D_GX_OPT_STORE) op = 's';
			else op = 'r';
#if 1	/* 2021.7.24 */
			ret = cl_gx_get_info_parm_opt_psize(scrct,op,&qprmList,&pInfoParm,opt,&par_pSize);
#else
			ret = cl_gx_get_info_parm_opt(scrct,op,&qprmList,&pInfoParm,opt);
#endif
			if (ret == ECL_DEFINED_ARRAY) {
				if (!(p=(char *)pInfoParm->pi_pos)) p = "";
				/* cl_func_conv_parm: z[%s]́Aϐɕϊł܂B */
				ERROROUT1(FORMAT(581),p);
			}
		}
		else ret = -1;
	}
	if (!ret) {
		if (opt & D_GX_OPT_STORE) {
			cl_set_parm_long(pInfoParmW,(long)pInfoParm);
			pInfoParmW->pi_id = 'S';
#if 1	/* 2021.7.24 */
			pInfoParmW->pi_aux[1] = pInfoParm->pi_aux[1];
			if (c=='$' && nparm>0) {
				pInfoParmW->pi_paux = par_pSize.par;
				pInfoParmW->pi_hlen = par_pSize.parlen;	/* ParmNoĂ */
			}
#endif
		}
		else memcpy(pInfoParmW,pInfoParm,sizeof(tdtInfoParm));
DEBUGOUT_InfoParm(110,"cl_func_conv_parm: ret=%d",pInfoParmW,ret,0);
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_f(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int i,ret,parm[5],iDEF;
	char *p,*pp;
	tdtInfoParm *pInfoParm;
	Leaf *wkleaf,*nodeleaf;

	pInfoParm = ppParm[0];
	ret = -1;
	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_CHAR) {
		p = pInfoParm->pi_data;
		if (*p == '{') {
			i = IS;	/* ֐ƂƂɂ */
			*pInfoParmW = *pInfoParm;
			pInfoParmW->pi_pos = 1;
		}
		else {
			iDEF = cl_get_option(8,0) & 0x01;
			wkleaf = NULL;
			if (!iDEF) {
				wkleaf = cl_search_func_leaf_and_inner(cl_search_src_ct(),cl_search_proc_ct(),p,nodeleaf);
			}
			if (!wkleaf) {
				if (cl_get_func_info(p,parm)) {
					i = parm[1];
/*
printf("cl_func_f: parm[1]=%d parm[4]=%d\n",parm[1],parm[4]);
*/
					*pInfoParmW = *pInfoParm;
					if (!(pp=cl_tmp_const_malloc(11+pInfoParm->pi_dlen+1))) return -1;
				/*	cmn_i_to_a(parm[4],pp);	2021.5.9 */
					sprintf(pp,"%d %s",parm[4],p);
					pInfoParmW->pi_data = pp;
					pInfoParmW->pi_dlen = strlen(pp);
					pInfoParmW->pi_pos = 0;
					pInfoParmW->pi_scale &= ~D_DATA_MALLOC;
				}
				else i = 0;
			}
			if (!i && iDEF && !wkleaf) {
				wkleaf = cl_search_func_leaf_and_inner(cl_search_src_ct(),cl_search_proc_ct(),p,nodeleaf);
			}
			if (wkleaf) {
				i = 1;	/* ֐ƂƂɂ */
				*pInfoParmW = *pInfoParm;
				pInfoParmW->pi_pos = (long)wkleaf;
				pInfoParmW->pi_paux = (char *)nodeleaf;
				pInfoParmW->pi_alen = D_AULN_SET_POS_LEAF;
			}
		}
		if (i) {
			ret = 0;
			pInfoParmW->pi_id = D_DATA_ID_FUNCTION;
DEBUGOUT_InfoParm(161,"cl_func_f:tInfoParmW: ",pInfoParmW,0,0);
		}
			/* cl_func_f: [%s]֐ł͂܂B */
		else ERROROUT1(FORMAT(393),p);
	}
	else ERROROUT(FORMAT(394));		/* cl_func_f: słB */
	return ret;
}

/********************************************/
/*											*/
/* F     opt : IvV				*/
/*					= 0 : ݒςݐ		*/
/*					<>0 : ݒςݍőIndex */
/********************************************/
int cl_func_count_sub(pInfoParm,opt)
tdtInfoParm *pInfoParm;
int opt;	/* 0:used, 1:max */
{
	tdtArrayIndex *pIndex,tIndex;
	tdtInfoParm **pvParm,*pDummy,tInfoParm,tInfoParm1,tInfoParm2,tInfoParm3,*pInfo,*pInfo2,*ppParmInfo[3];
	int ret,n,i,opt1,atr1,m1,m2,nparm;
	XHASHB *xhp;
	char c,*name,optc,*p1,*p2;
	int  *index,iParm[4],rc,interval,iINTVAL,len,iVal[2];
	long lVal1,lVal2;
	ScrPrCT *pScCT;
#if 0
	if (cl_check_data_id(pInfoParm,~(0x02 | 0x08|0x1000)) < 0) return ECL_SCRIPT_ERROR;
#endif
	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
		if (nparm=pInfoParm[1].pi_pos) {
			ret = pInfoParm[1].pi_hlen;
#if 1	/* 2021.10.19 */
			if (ret >= 0) ret = nparm;
#else
			lVal1 = nparm;
			memcpy(pWork,&lVal1,sizeof(long));
#endif
			return ret;
		}
	}
#if 0	/* 2021.6.13 *//* 2021.10.19 1->0*/
	if (nparm >= 2) {
		if ((rc=cl_get_parm_long(ppParm[1],&lVal1,"opt:")) < 0) return rc;
		opt = lVal1 & 0x01;
	}
#endif
	if ((c=pInfoParm->pi_id)=='R' || c=='A') {
		if (pInfoParm->pi_dlen == sizeof(tdtArrayIndex)) {
			pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
			if (c=='R') {
				if (xhp = pIndex->xhp) {
					if (opt) optc = 'm';
					else optc = 'u';
					ret = akxs_xhash2(xhp,optc,NULL,NULL);
				}
				else {
					index = pIndex->index;
					n = index[2];
/*
printf("cl_func_count_sub: index=%08x n=%d\n",index,n);
*/
					if (opt) ret = n;
					else if (pIndex->uAttr[0] == DEF_ZOK_VARI) {
						if (pvParm=pIndex->pVarIndex) {
							ret = 0;
							for (i=0;i<n;i++) {
								if (!cl_is_null_parm(pvParm[i])) ret++;
							}
						}
						else ret = -1;
					}
					else ret = index[2];	/* 2021.1.2 1-->2 */
				}
			}
			else {	/* MAPPEDARRAY ̂Ƃ̏ */
				if (!(pScCT = (ScrPrCT *)pInfoParm->pi_len)) {
					if (!(pScCT = cl_search_src_ct())) {
						ERROROUT1(FORMAT(27),"cl_func_count_sub");	/* VXeG[ */
						return ECL_SYSTEM_ERROR;
					}
				}
				if (rc=cl_get_array_info(pInfoParm,&tIndex,NULL,iParm)) return rc;	/* 2021.1.2 */
				pIndex = &tIndex;
				opt1 = 0;
				if (pInfoParm->pi_aux[1] & D_AUX1_LOCAL_VAR) opt1 |= D_GX_OPT_SET_LOCAL;
				name = (char *)pInfoParm->pi_pos;
				index = pIndex->index;
				n = iParm[3] - iParm[2] + 1;	/* 2021.1.3 */
/*
printf("cl_func_count_sub: index=%08x n=%d\n",index,n);
*/
				ret = n;
				if (name[0] == '#') {
				}
				else {	/* $ */
					if (!opt) {
						ret = 0;
						for (i=0;i<n;i++) {
							if (!cl_gx_get_all_var_ent(pScCT,'R',name,&pDummy,i+index[3],"",opt1))
								ret++;
						}
					}
				}
			}
		}
		else ret = -1;
	}
	else if (c == ' ') {
		if ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) && (pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
#if 1
			ppParmInfo[0] = &tInfoParm1;
			ppParmInfo[1] = &tInfoParm2;
			ppParmInfo[2] = &tInfoParm3;
			if ((ret=cl_get_range_info(pInfoParm,ppParmInfo,iVal,1)) < 0) return ret;
			ret = iVal[0];
#else
			cl_gx_copy_info(&tInfoParm1,pInfoParm);
			tInfoParm1.pi_aux[0] = tInfoParm1.pi_alen = 0;
			cl_gx_copy_info(&tInfoParm2,pInfoParm);
			tInfoParm2.pi_aux[0] = tInfoParm2.pi_alen = 0;
			atr1 = pInfoParm->pi_attr;
			len  = pInfoParm->pi_dlen;
			iINTVAL = pInfoParm->pi_alen & D_AULN_RANGE_INTVAL;
			if (atr1==DEF_ZOK_BINA && !iINTVAL)
				tInfoParm2.pi_pos = tInfoParm2.pi_hlen;
			else tInfoParm2.pi_data += len;
/*
DEBUGOUT_InfoParm(0,"cl_func_count_sub:tInfoParm1: ",&tInfoParm1,0,0);
DEBUGOUT_InfoParm(0,"cl_func_count_sub:tInfoParm2: ",&tInfoParm2,0,0);
*/
			if (atr1 == DEF_ZOK_CHAR) {
/*
printf("cl_func_count_sub: s2=[%s] s1=[%s]\n",tInfoParm2.pi_data,tInfoParm1.pi_data);
*/
				m1 = akxqkanjilen(p1=tInfoParm1.pi_data);
				m2 = akxqkanjilen(p2=tInfoParm2.pi_data);
				ret = akxcmb2ul(p2,m2) - akxcmb2ul(p1,m1);
				if (!ret) ret = 1;
				else if (iINTVAL && (interval=pInfoParm->pi_hlen)) ret = ret/interval;
				ret++;
				if (ret < 1) ret = 1;
			}
			else if (atr1 == DEF_ZOK_BINA) {
				memcpy(&lVal1,tInfoParm1.pi_data,len);
				memcpy(&lVal2,tInfoParm2.pi_data,len);
				ret = lVal2 - lVal1;
				if (!ret) ret = 1;
				else if (iINTVAL && (interval=pInfoParm->pi_hlen)) ret = ret/interval;
				ret++;
				if (ret < 1) ret = 1;
			}
			else {
				if ((ret=cl_gx_bexp(&tInfoParm,&tInfoParm2,"-",&tInfoParm1,0,0)) < 0) return ret;
				if (ret=cl_get_parm_bin(&tInfoParm,&n,"v2-v1: ")) return ret;
				if (!n) n = 1;
				else if (iINTVAL) {
					cl_gx_copy_info(&tInfoParm3,pInfoParm);
					tInfoParm3.pi_aux[0] = tInfoParm3.pi_alen = 0;
					tInfoParm3.pi_data = pInfo2->pi_data + len;
					if ((ret=cl_gx_bexp(&tInfoParm2,&tInfoParm,"/",&tInfoParm3,0,0)) < 0) return ret;
					pInfo  = &tInfoParm2;
					pInfo2 = &tInfoParm;
				}
				else {
					pInfo  = &tInfoParm;
					pInfo2 = &tInfoParm2;
				}
				cl_set_parm_bin(&tInfoParm1,1);
				if ((ret=cl_gx_bexp(pInfo2,pInfo,"+",&tInfoParm1,0,0)) < 0) return ret;
				if (ret=cl_get_parm_bin(pInfo2,&n,"count: ")) return ret;
				ret = n;
			}
			if (ret < 0) ret = 0;
#endif
		}
		else if (pInfoParm->pi_dlen) ret = 1;
		else ret = 0;
	}
	else if (c==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
		ret = akxs_rb_used(pInfoParm->pi_data);
/*
printf("cl_func_count_sub: ret=%d\n",ret);
*/
	}
	else {
#if 1
		ret = 1;
#else
		ERROROUT(FORMAT(395));		/* f[^^słB */
		ret = ECL_SCRIPT_ERROR;
#endif
	}
/*
printf("cl_func_count_sub: ret=%d\n",ret);
*/
/* 2021.10.19
	if (ret >= 0) {
		lVal1 = ret;
		memcpy(pWork,&lVal1,sizeof(long));
		ret = 0;
	}
*/
	return ret;
}

/* 2021.10.19 */
int cl_func_count(pWork,nparm,ppParm,dummy)
char *pWork;
int  nparm;
tdtInfoParm **ppParm;
int dummy;	/* 0:used, 1:max */
{
	char *pnama[]={"OPT"};
	int i,ret,opt,iOPT;
	long lVal,lVal1;
	char *name;
	tdtInfoParm *pInfoParm,*pInfoParmC,*pParmW[1];

	ret = opt = iOPT = 0;
#if 1	/* 2022.4.14 */
	pParmW[0] = NULL;
	if ((ret=cl_get_pname_info(nparm,ppParm,pParmW,pnama,1)) > 0) {
		if ((ret=cl_get_parm_long(pParmW[0],&lVal1,"opt:")) < 0) return ret;
		opt = lVal1 & 0x01;
		iOPT = 1;
		ret = 0;
	}
	else if (ret) return ret;
#else
	for (i=0;i<nparm;i++) {
		pInfoParm = ppParm[i];
		if (pInfoParm->pi_id == D_DATA_ID_PNAME) {
			name = (char *)pInfoParm->pi_paux;
			if (!stricmp("OPT",name)) {
				pInfoParmC = (tdtInfoParm *)pInfoParm->pi_pos;
				if (pInfoParmC->pi_id == 'S') pInfoParmC = (tdtInfoParm *)pInfoParmC->pi_pos;
				if ((ret=cl_get_parm_long(pInfoParmC,&lVal1,"opt:")) < 0) return ret;
				opt = lVal1 & 0x01;
				iOPT = 1;
			}
			else {
						/* cl_func_count: Ot̖O[%s]Ă܂B*/
				ERROROUT1(FORMAT(418),name);
				return ECL_SCRIPT_ERROR;
			}
			break;
		}
	}
#endif
	if (nparm>=2 && !iOPT) {
		pInfoParm = ppParm[nparm-1];
		if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
			opt = cl_get_data_int(pInfoParm) & 0x01;
			nparm--;
		}
	}

	lVal = 0;
	for (i=0;i<nparm;i++) {
		pInfoParm = ppParm[i];
		if (pInfoParm->pi_id != D_DATA_ID_PNAME) {
			if ((ret=cl_func_count_sub(pInfoParm,opt)) < 0) break;
			lVal += ret;
		}
	}
	if (ret >= 0) {
		memcpy(pWork,&lVal,sizeof(long));
		ret = 0;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_env(ppWork,pOperator,nparm,ppParm,ope,opt)
char **ppWork;
tdtInfoParm *ppParm[];
int nparm,ope,opt;
char *pOperator;
{
	static char *cpPath=NULL;
	int ret,rc,len,overwrite;
	char *pWork,*name,*value,*p,*flg,*parm;
	char w1[32],w2[32];
	SSPL_S sspl;
/*
printf("cl_func_env: pOperator=%s nparm=%d ope=%d\n",pOperator,nparm,ope);
*/
	pGlobTable->err_no = 0;
	ret = 0;
	pWork = *ppWork;
	name = w1;
	if ((len = parm_to_char(ppParm[0],&name,NULL)) >= 0) {
		switch (ope) {
			case D_FUC_PUTENV:
				if ((rc=akxnskipto(name,len,"=")) < len) {
					if (parm=cl_const_malloc(len+1)) {
						sspl.sp = 0;
						sspl.wd = parm;
						sspl.wdmax = len + 1;
						if ((rc=akxtgetwnspl(name,rc,&sspl,0x02)) > 0) {
							value = name;
							name = sspl.wd;
						}
					}
					else ret = ECL_MALLOC_ERROR;
				}
				else {
					ERROROUT1("cl_func_env: not found '=' in [%s].",name);
					ret = ECL_SCRIPT_ERROR;
				}
				if (ret < 0) goto Err;
			case D_FUC_SETENV:
			case D_FUC_UNSETENV:
				if ((rc=akxs_xhash2(pCLprocTable->pha_env,'r',name,NULL)) < 0) ret = rc;
				else if (!rc) {
					if (p = getenv(name)) flg = "S:";
					else flg = "U:";
					p = stradd(flg,p);
					if ((rc=akxs_xhash2(pCLprocTable->pha_env,'s',name,p)) < 0) ret = rc;
/*
printf("cl_func_env: rc=%d name=[%s] p=[%s]\n",rc,name,p);
*/
				}
				if (ope == D_FUC_SETENV) {
					if (nparm >= 3) {
						if (rc=cl_get_parm_bin(ppParm[2],&overwrite,"cl_func_env.overwrite:")) {
							ret = ECL_SCRIPT_ERROR;
							goto Err;
						}
/*
printf("cl_func_env: overwrite=%d\n",overwrite);
*/
					}
					else overwrite = 1;
					value = w2;
					if ((len = parm_to_char(ppParm[1],&value,NULL)) >= 0) {
						rc = setenv(name,value,overwrite);
					}
					else ret = len;
				}
				else if (ope == D_FUC_UNSETENV) {
					rc = unsetenv(name);
				}
				else {	/*  == D_FUC_PUTENV */
					memcpy(parm,value,len+1);
					rc = putenv(parm);
				}
				break;
			case D_FUC_GETENV:
				*ppWork = getenv(name);
				break;
			default:
				ERROROUT1("cl_func_env: function=[%s] not defined!!",pOperator);
				rc = ret = ECL_SCRIPT_ERROR;
		}
		pGlobTable->err_no = errno;
	}
 Err:
	if (ope != D_FUC_GETENV) memcpy(pWork,&rc,sizeof(int));
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_env_reset(pha)
XHASHB *pha;
{
	int i,max,rc;
	char *name,*value;

	if (!pha) return 0;
	max = akxs_xhash2(pha,'m',NULL,NULL);
/*
printf("cl_env_reset: max = %d\n",max);
*/
	for (i=1;i<=max;i++) {
		pha->xha_xhix = i;
		if (akxs_xhash2(pha,'p',&name,&value)>0) {
			if (*value == 'S') rc = setenv(name,value+2,1);
			else rc = unsetenv(name);
/*
printf("cl_env_reset: i=%d name=[%s] value=[%s]\n",i,name,value);
*/
			pGlobTable->err_no = errno;
		}
	}
	akxs_xhash_free(pha);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_get_time(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  i,ret;
	struct timeval tval;
	char buf[64];

	pGlobTable->err_no = 0;
	if (nparm>0 && ppParm[0]->pi_dlen>0) {
		if ((ret=cl_get_parm_bin(ppParm[0],&i,"option:")) <0) return ret;
	}
	else i = 0;
	cl_set_parm_mpa(pInfoParmW,m_get_i(0));
	aka_get_msec(&tval);
	pGlobTable->err_no = errno;
	if (!i) akxe_timer_sub(&tval,&tval,&pCLprocTable->tScrTimeVal[0]);
	sprintf(buf,"%d.%03d",tval.tv_sec,tval.tv_usec/1000);
	m_set_a((MPA *)pInfoParmW->pi_data,buf);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_round(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	tdtInfoParm *pInfoParm;
	int  ret;
	int  rc,atr1,iAttr[3],scale,option,i,pre1,sca1;
	long Value1,lVal,w,lVal1,Val1z[NMPA_LONG],*Val1;
	double dValue1,dVal,dw;
	MPA *mpa1;

	pInfoParm = ppParm[0];
	if (cl_is_null_parm(pInfoParm)) {
		ERROROUT1(FORMAT(341),"cl_ex_round");	/* NULLp[^͎wł܂B */
		return -1;
	}
	Val1 = cl_get_tmpMPA(Val1z);
	if ((rc=cl_get_parm_mpa(pInfoParm,Val1,"val:",iAttr)) < 0) return rc;
	else if (rc > 0) return ECL_SCRIPT_ERROR;

	atr1 = pInfoParm->pi_attr;
	pre1 = pInfoParm->pi_hlen;
	sca1 = pInfoParm->pi_pos;
/*
printf("cl_ex_round: atr1=%d pre1=%d sca1=%d\n",atr1,pre1,sca1);
*/
	scale = option = 0;
	if (nparm >= 2) {
		pInfoParm = ppParm[1];
		if ((rc=cl_get_parm_bin(pInfoParm,&scale,"scale:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
	}
	/* option=0:ľܓ/1:؎̂/2:؏グ  */
	if (nparm >= 3) {
		pInfoParm = ppParm[2];
		if ((rc=cl_get_parm_bin(pInfoParm,&option,"option:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		option &= 0x13;
	}
	else option = cl_get_option(12,0) & 0x03;
/*
printf("cl_ex_round: iAttr[0]=%d option=%08x\n",iAttr[0],option);
*/
	mpa1 = (MPA *)Val1;
	switch (iAttr[0]) {
	case DEF_ZOK_BINA:
		Value1 = Val1[0];
		i = scale;
		lVal1 = Value1;
		w = 1;
		while (lVal1 && i<-1) {
			w *= 10;
			lVal1 /= 10;
			i++;
		}
		lVal = lVal1;
		if (lVal && i<0) {
			w *= 10;
			lVal /= 10;
		}
		if (lVal) {
			if (Value1-lVal*w) {
				if (!option) Value1 = ((lVal1+5)/10)*w;
				else if (option & 0x02) Value1 = (lVal+1)*w;
				else Value1 = lVal*w;
			}
		}
		else Value1 = 0;
		cl_set_parm_long(pInfoParmW,Value1);
		break;
	case DEF_ZOK_FLOA:
		memcpy(&dValue1,Val1,sizeof(double));
		m_d2mpa(dValue1,mpa1);
	case DEF_ZOK_DECI:
		if (option & 0x10) {
			option = (option & 0x03)<<12 | 0x0100;
			if ((rc=m_precision(mpa1,X_ABS(scale),option)) < 0) return rc;
		}
		else {
			if ((rc=cl_mpa_scale_opt(mpa1,m_get_nmpa10(),scale,option)) < 0) return rc;
		}

		if (atr1 == DEF_ZOK_CHAR) {
			if (cl_get_option(17,0) & 0x01) atr1 = DEF_ZOK_FLOA;
			else atr1 = DEF_ZOK_DECI;
		}
/*
printf("cl_ex_round:Attr=%d ParmLen=%d PosData=%d\n",atr1,pre1,sca1);
m_print("cl_ex_round",mpa1,0);
*/
		if (atr1==DEF_ZOK_DECI && pre1) {
			cl_set_parm_mpa(pInfoParmW,mpa1);
			if ((rc=cl_mpa_scale(mpa1,pre1,sca1))<0) return rc;
			memcpy(pInfoParmW->pi_data,mpa1,sizeofMPA());
		}
		else {
			m_normalize(mpa1);
			if (atr1 == DEF_ZOK_FLOA) {
				m_mpa2d(mpa1,&dValue1);
				cl_set_parm_double(pInfoParmW,dValue1);
			}
			else cl_set_parm_mpa(pInfoParmW,mpa1);
		}
		break;
	default:
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_mem_used(pAns,nparm,ppParm)
char *pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int rc,i,maxargs,ix,*index,lena[5],m;
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex,*pIndex;

	pIndex = &tIndex;
	if (rc=cl_get_ITBL_maxargs_ref(nparm,ppParm,&pIndex,&pTBL,1,5,&maxargs,NULL)) return rc;
	m = cl_mem_used(5,lena);
	index = pIndex->index;
	ix = index[3];
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent_opt(pIndex,pTBL,ix,'s');
		if (pInfoParm) {
			cl_set_parm_bin(&rInfoParm,lena[i]);
			if (rc=cl_gx_rep_info_set_ign(pInfoParm,&rInfoParm,1|D_GX_OPT_ALC_TMP)) return rc;
		}
		else return -1;
	}
	memcpy(pAns,&m,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_code_type(opt,code_type)
int opt;
uchar code_type;
{
	if (opt) gucCodeType = code_type;
	return gucCodeType;
}

/****************************************/
/*										*/
/****************************************/
static int _getval_char(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	static char *_fn_="_getval_char";
	tdtInfoParm *pInfoParm;
	char w1[32],*name,id;
	int rc,num;

	name = w1;
	if (parm_to_char(ppParm[0],&name,NULL) <= 0) {
		ERROROUT1(FORMAT(591),_fn_);	/* %s: 擾NULLłB */
		return ECL_SCRIPT_ERROR;
	}
	if (!stricmp(name,"OPTION")) {
		if (nparm <= 1) goto Err;
		if ((rc=cl_get_parm_bin(ppParm[1],&num,"option number:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		if (num<=0 || num>MAX_OPTIONS) {
			ERROROUT2(FORMAT(593),_fn_,num);	/* %s: IvVԍ(%d)͈͊OłB */
			return ECL_SCRIPT_ERROR;
		}
		cl_set_parm_long(pInfoParmW,pGlobTable->options[num-1]);
	}
	else {
		ERROROUT2(FORMAT(592),_fn_,name);	/* %s: w擾[%s]͖T|[głB */
		return ECL_SCRIPT_ERROR;
	}
	return 0;
 Err:
	ERROROUT1(FORMAT(42),_fn_);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
}

/****************************************/
/*										*/
/****************************************/
int _getval_array(pInfoParmW,pInfoParm,ix,pInfo1)
tdtInfoParm *pInfoParmW;
tdtInfoParm *pInfoParm;
int ix;
tdtInfoParm *pInfo1;
{
	char id;
	int rc,nm,ix0,iParm[4];
	tdtArrayIndex tIndex;
	tdtInfoParm ***pTBL,*ppParm[3],*pInfo;
	XHASHB *xhp;
/*
	if ((rc=cl_get_array_info(pInfoParm,&tIndex,&pTBL,iParm)) < 0) return rc;
	if (tIndex.xhp) {
		ppParm[0] = pInfoParm;
		ppParm[2] = pInfo1;
		return cl_gx_array_bexp(pInfoParmW,3,ppParm,0);
	}
*/
	if (rc = _get_array_info_used(1,&pInfoParm,&tIndex,&pTBL,iParm,1)) {
		if (rc == 2000) {
			ppParm[0] = pInfoParm;
			ppParm[2] = pInfo1;
			return cl_gx_array_bexp(pInfoParmW,3,ppParm,0);
		}
		else return rc;
	}
	if ((id=pInfoParm->pi_id) == 'R') {
		rc = cl_get_parm_bin(pInfo1,&ix,"_getval_array:BIN");
		if (rc) return ECL_SCRIPT_ERROR;
	}
/*
printf("_getval_array: iParm[0]..[3] =%d %d %d %d\n",iParm[0],iParm[1],iParm[2],iParm[3]);
*/
	nm  = iParm[1] - 1;
	ix0 = iParm[2] + ix;
	if (ix<0 || ix>nm) {
		rc = ECL_SCRIPT_ERROR;
		ERROROUT3(FORMAT(320),"_getval_array",FORMAT(150),ix);	/* %s: %s̃CfbNX(%d)͔͈͊OłB*/
	}
	else {
		pInfo = cl_get_array_and_var_ent_opt(&tIndex,pTBL,ix0,'r');
		rc = cl_gx_rep_info_set_ign(pInfoParmW,pInfo,1);
	/*
		if (cl_is_undef_parm(pInfoParmW)) cl_null_data(pInfoParmW);
	*/
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _chk_attr(pInfo1)
tdtInfoParm *pInfo1;
{
	int len,atr;
	char *dat;

	if (pInfo1->pi_id == ' ') {
		if ((atr=pInfo1->pi_attr) == DEF_ZOK_CHAR) {
			if (cl_chk_mybe_num(pInfo1->pi_data,pInfo1->pi_dlen)) atr = 2;
			else atr = 1;
		}
		else if (atr>=2 && atr<=4) atr = 2;
	}
	else atr = 0;

	return atr;
}

/****************************************/
/*										*/
/****************************************/
int _getval_struct(pInfoParmW,pInfoParm,ix,pInfo1,opt)
tdtInfoParm *pInfoParmW;
tdtInfoParm *pInfoParm;
int ix,opt;
tdtInfoParm *pInfo1;
{
	static char *_fn_="_getval_struct";
	int rc,len,atr;
	char *dat,c;
	tdtInfoParm *pInfo;
	parmList  **parmName;
	tdtDefType *pDeftype;

	atr = _chk_attr(pInfo1);
	if (atr == 1) {
		pInfo = pInfoParm;
		rc = _ex_get_member(&pInfo,0,pInfo1->pi_data,pInfo1->pi_dlen);
		if (rc) {
			ERROROUT2(FORMAT(76),_fn_,FORMAT(465));	/* o */ /* %s: %s܂B*/
			rc = ECL_SCRIPT_ERROR;
		}
		else rc = cl_gx_rep_info_set_ign(pInfoParmW,pInfo,1);
	}
	else if (atr == 2) {
		rc = cl_get_parm_bin(pInfo1,&ix,strtmp2(_fn_,":BIN"));
		if (rc) rc = ECL_SCRIPT_ERROR;
		else {
			pDeftype = (tdtDefType *)pInfoParm->pi_data;
			if (ix<=0 || ix>pDeftype->ntype) {
				ERROROUT2(FORMAT(534),_fn_,ix);		/* %s: ʒuw(%d)słB*/
				rc = ECL_SCRIPT_ERROR;
			}
			else {
				ix--;
				if ((opt & 0x02) && !(opt & 0x04)) {
					parmName = pDeftype->vname;
					cl_set_parm_char(pInfoParmW,parmName[ix]->prp,parmName[ix]->prmlen);
				}
				else rc = cl_gx_rep_info_set_ign(pInfoParmW,pDeftype->pType[ix],1);
			}
		}
	}
	else {
		ERROROUT(FORMAT(395));	/* f[^^słB*/
		rc = ECL_SCRIPT_ERROR;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _getval_range(pInfoParmW,pInfoParm,ix,pInfo1,id)
tdtInfoParm *pInfoParmW;
tdtInfoParm *pInfoParm;
int ix;
tdtInfoParm *pInfo1;
char id;
{
	static char *_fn_="_getval_range";
	int rc,iVal[2],iERR,atr,nrange;
	char w1[32],*name,c;
	tdtInfoParm *ppParm[3],tInfo1,tInfo2,tInfo3;

	ppParm[0] = &tInfo1;
	ppParm[1] = &tInfo2;
	ppParm[2] = &tInfo3;
	if ((nrange=cl_get_range_info(pInfoParm,ppParm,iVal,0)) < 0) return nrange;
	rc = iERR = 0;
	if (id == 'c') {
		ix = 0;
		atr = _chk_attr(pInfo1);
		if (atr == 1) {
			c = toupper(*(name=pInfo1->pi_data));
			if (c == 'R') ix = 1;
			else if (c == 'I') ix = 2;
			else {
				iERR = 2;
				rc = -1;
			}
		}
		else if (atr == 2) {
			rc = cl_get_parm_bin(pInfo1,&ix,"_getval_range:BIN");
			if (rc) {
				ix = -1;
				iERR = 0;
			}
			else if (!(ix==1 || ix==2)) {
				iERR = 1;
				rc = -1;
			}
		}
	}
	else if (ix<=0 || ix>nrange) {
		iERR = 1;
		rc = -1;
	}
	if (!rc) {
		rc = cl_gx_rep_info_set_ign(pInfoParmW,ppParm[ix-1],1);
	}
	else {
		rc = ECL_SCRIPT_ERROR;
		if  (iERR == 1)
			ERROROUT2(FORMAT(534),_fn_,ix);		/* %s: ʒuw(%d)słB*/
		else if (iERR == 2)
			ERROROUT2(FORMAT(592),_fn_,name);	/* %s: w擾[%s]͖T|[głB */
		else if (iERR == 3)
			ERROROUT1(FORMAT(591),_fn_);		/* %s: 擾NULLłB */
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_getval(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	static char *_fn_="cl_func_getval";
	tdtInfoParm *pInfoParm,*pInfo1,*pInfo,tInfo,tInfoN[5],*ppParmN[5];
	int rc,ix,opt,len,atr,iParm[4],i;
	char id,*dat,c,buf[60];

	pInfoParm = ppParm[0];
	pInfo1 = ppParm[1];
	if ((rc=cl_check_data_id2(pInfoParm,0x02|0x08|0x10|0x1000|0x2000,0x02)) < 0) return rc;

	if ((id=pInfoParm->pi_id) == ' ') {
		if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) id = 'r';
		if (pInfoParm->pi_alen & D_AULN_COMPLEX_DATA) id = 'c';
	}
	ix = 0;
	if (instrchar("ALNr",id) > 0) {
		rc = cl_get_parm_bin(pInfo1,&ix,"cl_func_getval:ix:BIN");
		if (rc) {
			ix = -1;
#if 0
			ERROROUT3(FORMAT(47),_fn_,2,rc);	/* %s:  %d p[^Ă܂(rc=%d)B*/
#endif
			return ECL_SCRIPT_ERROR;
		}
	}
	opt = 0;
	if (nparm >= 3) {
		rc = cl_get_parm_bin(ppParm[2],&opt,"cl_func_getval:opt:BIN");
		if (rc) {
			return ECL_SCRIPT_ERROR;
		}
	}
	if (id=='A' || id=='R') {
		rc = _getval_array(pInfoParmW,pInfoParm,ix,pInfo1);
	}
	else if (id=='L' || id=='N') {
	/*
		pInfo = &tInfo;
		cl_set_parm_long(pInfo,ix-1);
		ppParm[1] = pInfo;
	*/
		rc = cl_ope_list(pInfoParmW,NULL,nparm,ppParm,D_FUC_LIST_REF,0);
	/*	ppParm[1] = pInfo1;	*/
	}
	else if (id == 'T') {
		rc = _getval_struct(pInfoParmW,pInfoParm,ix,pInfo1,opt);
	}
	else if (id=='r' || id=='c') {
		rc = _getval_range(pInfoParmW,pInfoParm,ix,pInfo1,id);
	}
	else if (id == ' ') {
		rc = _getval_char(pInfoParmW,nparm,ppParm);
	}
	else rc = -1;
	if (!rc && !(opt & 0x01)) {
		if (cl_is_undef_parm(pInfoParmW)) cl_null_data(pInfoParmW);
	}
	if (!rc && (opt & 0x04)) {
		len = cl_print_attr(buf,sizeof(buf),pInfoParmW,iParm);
		ppParmN[0] = &tInfoN[0];
		cl_set_parm_char(ppParmN[0],buf,len);
		for (i=1;i<=4;i++) {
			ppParmN[i] = &tInfoN[i];
			cl_set_parm_long(ppParmN[i],iParm[i-1]);
		}
		rc = cl_set_list(pInfoParmW,5,ppParmN);
		pInfoParmW->pi_id = D_DATA_ID_NARABI;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_decode(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	tdtInfoParm *pInfo;
	int  ret,Ans,n,i;
	char **ppAns,*pAns;

	gtIter_ctl[0].itc_circ_ref = NULL;
	gtIter_ctl[1].itc_circ_ref = NULL;
	pAns = (char *)&Ans;
	ppAns = &pAns;
	pInfo = ppParm[0];
	n = (nparm-1)/2*2 + 1;
	for (i=1;i<n;i+=2) {
		if ((ret=cl_cmpt_comp(ppAns,"==",pInfo,ppParm[i],0,NULL))<0) return ret;
		if (Ans) {
#if 1	/* 2021.10.27 */
			cl_gx_copy_info_opt(pInfoParmW,ppParm[i+1],1);
#else
			if ((ret=cl_gx_rep_info_set(pInfoParmW,ppParm[i+1],1|D_GX_OPT_ALC_TMP))<0) return ret;
#endif
			break;
		}
	}
	if (i >= n) {
		if (i < nparm) {
#if 1	/* 2021.10.27 */
			cl_gx_copy_info_opt(pInfoParmW,ppParm[i],1);
#else
			if ((ret=cl_gx_rep_info_set(pInfoParmW,ppParm[i],1|D_GX_OPT_ALC_TMP))<0) return ret;
#endif
		}
		else {
			cl_null_data(pInfoParmW);
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_iif(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	tdtInfoParm *pInfoParm;
	int  ret;

DEBUGOUT_InfoParm(194,"cl_ex_iif: nparm=%d",pInfoParm,nparm,0);

	if (nparm >= 4) return ECL_TOO_PARAMETER;

	ret = 0;
	if (cl_is_true(ppParm[0]))
		pInfoParm = ppParm[1];
	else
		pInfoParm = ppParm[2];
#if 1	/* 2021.10.27 */
	cl_gx_copy_info_opt(pInfoParmW,pInfoParm,1);
#else
	ret = cl_gx_rep_info_set(pInfoParmW,pInfoParm,D_GX_OPT_ALC_TMP);
#endif
	return ret;
}

#if 1	/* 2022.1.6 */
/****************************************/
/*										*/
/****************************************/
static int _ecmd_chk(p)
char *p;
{
	static char *cmds[]={"/BEXP/READ/OUTPUT/"
	,"/LET/PRINT/LPRINT/ECHO/SAY/DUMP/PRINTF/LPRINTF/LOGPARM/"
	,"/DIM/REDEFINE/REDEF/UNDEFINE/UNDEF/"
	,"/THROW/RAISE/BREAK/CONTINUE/",NULL};
	int len,i,pos,rc;
	char w1[35];

	len = strlen(p);
	*w1 = '/';
	len = memncpy(w1+1,p,len,sizeof(w1)-3);
	strcpy(w1+1+len,"/");
/*
printf("_ecmd_chk: w1=[%s]\n",w1);
*/
	for (i=0;i<4;i++) {
		if (pos=inistr(cmds[i],w1)) break;
	}
	rc = 0;
	if (!pos) {
		ERROROUT2(FORMAT(318),"_ecmd_chk",p);	/* %s: %s͎gpł܂B*/
		rc = ECL_SCRIPT_ERROR;
	}
	else if (pos < 0) rc = -1;
	return rc;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_ex_ecmd(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	static MCAT CLcList_mcat={'M','C',512,0,0,0,NULL,0};
	tdtInfoParm InfoParm;
	SSPL_S ssp;
	Leaf *leafTop,*leaf,*leafa[2];
	ScrPrCT *scrptct;
	ProcCT *proc;
	int  ret,flag,opt,i,pos,len,opt_in,dtype,k;
	char w1[32],*p1,*p;
	cmdInfo *cmd;

	pGlobTable->error = 0;
	opt = flag = 0;
	if (nparm >= 2) {
		if (ret=cl_get_parm_bin(ppParm[1],&flag,"ecmd flag:")) return -1;
	}
	p1 = w1;
	if ((ret = parm_to_char(ppParm[0],&p1,NULL)) >= 0) {
		if (!ret) {
#if 1
			return 0;
#else
			ERROROUT1(FORMAT(188),"cl_ex_ecmd");	/* %s: R}h܂B */
			return ECL_SCRIPT_ERROR;
#endif
		}
		else {
			len = ret;
			memset(&ssp,0,sizeof(SSPL_S));
			ssp.wd = w1 + 1;
			ssp.wdmax = sizeof(w1)-1;
			ret = akxtgwnsl(p1,len,&ssp,NULL,1);
#if 1	/* 2022.1.6 */
			if ((ret=_ecmd_chk(ssp.wd)) < 0) return ret;
#else
			*w1 = '/';
			strcpy(w1+ret+1,"/"); 
/*
printf("cl_ex_ecmd: w1=[%s]\n",w1);
*/
			for (i=0;i<4;i++) {
				if (pos=inistr(cmds[i],w1)) break;
			}
			if (!pos) {
				*(w1+ret+1) = '\0';
				ERROROUT2(FORMAT(318),"cl_ex_ecmd",w1+1);	/* %s: %s͎gpł܂B*/
				return ECL_SCRIPT_ERROR;
			}
			else if (pos < 0) return -1;
#endif
			if (!(CLcList.ConstCt = cl_const_ct_new())) {
				ERROROUT("Malloc ConstCt");
				return -1;
			}
			CLcList.ConstCt->cct_top = NULL;
			CLcList.ConstCt->cct_cur = NULL;

			CLcList.mcat = &CLcList_mcat;
			ssp.sp = 0;
			InfoParm.pi_paux = (char *)&ssp;
			InfoParm.pi_dlen = len;
			InfoParm.pi_data = p1;
			InfoParm.pi_scale = 0;
			CLcList.fp = (FILE *)&InfoParm;
			CLcList.line = 0;
			CLcList.fullname = CLcList.fname = "MEM:";
			CLcList.option |= D_SCRPT_MEMORY | D_CLST_OPT_COMMAND;
#if 1	/* 2021.5.23 */
			dtype = akxt_get_code_type();
			if (opt_in = (cl_get_option(21,0)>>16) & 0x0f) dtype = opt_in;
			CLcList.option |= D_CLST_OPT_USE_DTYPE | (dtype<<16);
#endif
			CLSTCB.TopStack = NULL;
			if (!(scrptct = cl_search_src_ct())) return -1;
			scrptct->pFlag |= D_SCRPT_INTERACTIVE;
			if (!(proc=cl_search_proc_ct())) return -1;
			ret = cl_lex();
			if (!ret) {
				if (leafTop = search_top_leaf()) {
/*
col_leaf_print(leafTop);
*/
					cmd = &leafTop->cmd;
/*
printf("cl_ex_ecmd: cmnd=%08x scno=%d\n",cmd->cid,cmd->sub_cid);
*/
#if 1	/* 2022.1.6 */
					if (cmd->cid == C_NODE_DEFINE) {
						leafa[0] = leafTop->leftleaf;
						leafa[1] = leafTop->rightleaf;
					}
					else {
						leafa[0] = leafTop;
						leafa[1] = NULL;
					}
					i = 0;
					for (k=0;k<2;k++) {
						leaf = leafa[k];
						while (leaf) {
							if (i > 0) {
								p = cl_gets_cmd_name(leaf->cmd.cid);
								if ((ret=_ecmd_chk(p)) < 0) return ret;
							}
							ret = cl_node_process_opt(leaf,proc,1);
							leaf = leaf->rightleaf;
							i = 1;
						}
					}
#else
					if (cmd->cid == C_NODE_DEFINE) leaf = leafTop->leftleaf;
					else leaf = leafTop;
					ret = cl_node_process_opt(leaf,proc,1);
#endif
					cl_leaf_clear(leafTop);
				}
				else {
					ret = -1;
					flag = 0;
				}
			}
			else flag = 0;
			scrptct->pFlag &= ~D_SCRPT_INTERACTIVE;
			if (CLcList.ConstCt) {
				const_ct_clear(CLcList.ConstCt);
				CLcList.ConstCt = NULL;
			}
			CLSTCB.TopStack = NULL;
		}
	}
	if (flag & 0x02) {
		if (pGlobTable->error = ret) {
			pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,ret);
		}
		ret = 0;
	}
/*
printf("cl_ex_ecmd:Exit: ret=%d\n",ret);
*/
	memcpy(pWork,&ret,sizeof(int));
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_range(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	static char *_fn_="cl_func_range";
	tdtInfoParm *pInfoParm,tInfoParm3,*pInfoParm1,*pInfoParm2,*pInfoParm3,*ppInfo[3],tInfo[3];
	int  ret,i,rc,atr1,iAttr[3],len,alen,iVal[2],iU1,iU2,iCOMPLEX;
	long lVal1,lVal2,lVal3,Val1z[NMPA_LONG],*Val1;
	char *p,*p1,*p2,w1[12];
	double dVal1,dVal2,dVal3;
	MPA *ma1,*ma2,*ma3;
/*
printf("cl_func_range:Enter nparm=%d alen=%08x\n",nparm,ppParm[0]->pi_alen);
*/
	for (i=0;i<2;i++) {
		pInfoParm2 = ppParm[i];
		if (cl_is_null_parm(pInfoParm2)) {
			ERROROUT1(FORMAT(341),_fn_);	/* NULLp[^͎wł܂B */
			return ECL_SCRIPT_ERROR;
		}
	}

	pInfoParm1 = ppParm[0];
	pInfoParm3 = NULL;
	if (!(pInfoParm1->pi_alen & D_AULN_RANGE_DATA) || nparm>=3) {
		if ((ret=cl_gx_range_set(pInfoParmW,2,ppParm,0)) < 0) return ret;
		if (nparm >= 3) pInfoParm3 = ppParm[2];
	}
	else {
		*pInfoParmW = *ppParm[0];
		pInfoParm3 = ppParm[1];
		if ((pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA) || (pInfoParm3->pi_alen & D_AULN_COMPLEX_DATA)) {
			ERROROUT2(FORMAT(636),_fn_,FORMAT(635));	/* f *//*%s: %s͎gpł܂B*/
			return ECL_SCRIPT_ERROR;
		}
	}
	/* l */
	Val1 = cl_get_tmpMPA(Val1z);
	lVal3 = 1;
	if (pInfoParm3) {
		if (cl_is_null_parm(pInfoParm3)) {
			nparm = 2;
			pInfoParm3 = NULL;
		}
		else if (pInfoParm1->pi_attr!=DEF_ZOK_DATE || pInfoParm3->pi_attr!=DEF_ZOK_CHAR) {
#if 1
			if ((rc=cl_get_parm_mpa(pInfoParm3,Val1,"val:",iAttr)) < 0) return rc;
			atr1 = iAttr[0];
			if (atr1>=DEF_ZOK_BINA && atr1<=DEF_ZOK_DECI) {
				if (iAttr[D_IATTR_ULI] & AKX_NUM_I) {
					ERROROUT1(FORMAT(634),_fn_);	/* %s: ̈ʒuĂ܂B*/
					return ECL_SCRIPT_ERROR;
				}
			}
			i = 0;
			if (atr1 == DEF_ZOK_DECI) {
				ma1 = (MPA *)Val1;
				m_mpa2l(ma1,&lVal3);
				if (ma1->zero) i = 1;
			}
			else if (atr1 == DEF_ZOK_BINA) {
				if (!(lVal3=Val1[0])) i = 1;
			}
			else {
				memcpy(&dVal1,Val1,sizeof(double));
				if (dVal1 == 0.0) i = 1;
				lVal3 = dVal1;
			}
			if (!lVal3) lVal3 = 1;
			if (i) {
#else
			if ((rc=cl_get_parm_bin(pInfoParm3,Val1,"val")) < 0) return rc;
			if (!(lVal3 = Val1[0])) {
#endif
				pInfoParm3 = NULL;
				lVal3 = 1;
			}
		}
	}

	if (!pInfoParm3) return 0;

	for (i=0;i<3;i++) ppInfo[i] = &tInfo[i];
	if ((ret=cl_get_range_info(pInfoParmW,ppInfo,iVal,0)) < 0) return ret;
	pInfoParm1 = ppInfo[0];
	pInfoParm2 = ppInfo[1];
	iU1 = pInfoParm1->pi_scale & D_DATA_UNSIGNED;
	iU2 = pInfoParm2->pi_scale & D_DATA_UNSIGNED;
	if (pInfoParm2->pi_scale & D_DATA_IMAGE) iCOMPLEX = D_AULN_COMPLEX_DATA;
	else iCOMPLEX = 0;
	atr1 = pInfoParm1->pi_attr;
	len  = pInfoParm1->pi_dlen;
	if (atr1 == DEF_ZOK_CHAR)
		pInfoParmW->pi_hlen = lVal3;
	else if (atr1 == DEF_ZOK_DATE) {
		if (pInfoParm3->pi_attr == DEF_ZOK_CHAR) {
			if (!(lVal1 = cl_get_term_index(pInfoParm3))) lVal1 = 3;
			p = pInfoParm3->pi_data + 1;
			if (lVal1 == 5) {
				if (toupper(*p) == 'I') p++;
			}
			if (!(lVal3 = atoi(p))) lVal3 =1;
		}
		else lVal1 = 1;
		pInfoParmW->pi_pos  = lVal1;
		pInfoParmW->pi_hlen = lVal3;
/*
printf("cl_func_range: term=%d lVal3=%d\n",lVal1,lVal3);
*/
	}
	else {
		alen = 0;
		switch (atr1) {
		case DEF_ZOK_FLOA:
		case DEF_ZOK_DECI:
			alen = len;
		case DEF_ZOK_BINA:
			alen += len + len;
			if (!(p=cl_tmp_const_malloc(alen))) return ECL_MALLOC_ERROR;
			memcpy(p,pInfoParm1->pi_data,len);
			memcpy(p+len,pInfoParm2->pi_data,len);
			if (atr1 == DEF_ZOK_BINA) {
				pInfoParmW->pi_hlen = lVal3;
/*
printf("cl_func_range: lVal2=%d\n",*(int *)pInfoParm2->pi_data);
*/
			}
			else {
				if (atr1 == DEF_ZOK_FLOA) {
					if ((rc=cl_get_parm_double(pInfoParm3,Val1,"val")) < 0) return rc;
				}
				else {
					if ((rc=cl_get_parm_dec(pInfoParm3,Val1,"val")) < 0) return rc;
				}
				memcpy(p+len+len,Val1,len);
			}
			pInfoParmW->pi_data = p;
			break;
		default:
			return ECL_SCRIPT_ERROR;
		}
	}
	pInfoParmW->pi_scale &= ~D_DATA_LPOSDATA;
	pInfoParmW->pi_alen |= D_AULN_RANGE_INTVAL | iCOMPLEX;
	if (pInfoParmW->pi_attr == DEF_ZOK_BINA) pInfoParmW->pi_scale |= iU1 | iU2;

DEBUGOUT_InfoParm(194,"cl_func_range:Exit",pInfoParmW,0,0);

	return 0;
}

/************************************************/
/*  : IN  :	pInfoParm :						*/
/*				ppParm	  :	͈͒lԋpp		*/
/*							ppParm[0]:Jnl	*/
/*							ppParm[1]:Il	*/
/*							ppParm[2]:Ԋul	*/
/*				iVal	  : JԂԋpp	*/
/*				opt		  : IvV			*/
/*							0 : ppParm			*/
/*							1 : JԂ		*/
/*		  OUT : ppParm							*/
/*				iVal[0] : JԂ				*/
/*				iVal[1] : interval (CHAR,BINA)	*/
/* ԋp : = 0 : ͈͒lłȂ					*/
/*		  = 2 : ͈͒l̂						*/
/*		  = 3 : C^[o܂				*/
/*		  < 0 : G[							*/
/************************************************/
int cl_get_range_info(pInfoParm,ppParm,iVal,opt)
tdtInfoParm *pInfoParm,*ppParm[];
int iVal[],opt;
{
	tdtInfoParm *pInfoParm1,*pInfoParm2,*pInfoParm3;
	tdtInfoParm tInfoParm,tInfoParm1,tInfoParm2,*pInfo,*pInfo2;
	tdtInfoParm *ppInfo[3],tInfo;
	int ret,n,atr1,m1,m2,nrange,interval,iINTVAL,len,term,iU,iCOMPLEX;
	long lVal1,lVal2;
	char *p1,*p2;
/*
printf("cl_get_range_info:Enter alen=%08x\n",pInfoParm->pi_alen);
*/
DEBUGOUT_InfoParm(194,"cl_get_range_info:pInfoParm: ",pInfoParm,0,0);

	nrange = ret = 0;
	iVal[0] = iVal[1] = 0;
	if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
		iU = pInfoParm->pi_scale & D_DATA_UNSIGNED;
		iCOMPLEX = pInfoParm->pi_alen & D_AULN_COMPLEX_DATA;
		nrange = 2;
		pInfoParm1 = ppParm[0];
		pInfoParm2 = ppParm[1];
		pInfoParm3 = ppParm[2];
		cl_gx_copy_info(pInfoParm1,pInfoParm);
		pInfoParm1->pi_scale &= ~D_DATA_MALLOC;		/* 2021.7.13 add */
		pInfoParm1->pi_aux[0] = pInfoParm1->pi_alen = 0;
		cl_gx_copy_info(pInfoParm2,pInfoParm);
		pInfoParm2->pi_scale &= ~D_DATA_MALLOC;		/* 2021.7.13 add */
		pInfoParm2->pi_aux[0] = pInfoParm2->pi_alen = 0;
		atr1 = pInfoParm->pi_attr;
		len  = pInfoParm->pi_dlen;
		iINTVAL = pInfoParm->pi_alen & D_AULN_RANGE_INTVAL;
		if (atr1==DEF_ZOK_BINA && !iINTVAL)
			pInfoParm2->pi_pos = pInfoParm2->pi_hlen;
		else pInfoParm2->pi_data += len;

DEBUGOUT_InfoParm(194,"cl_get_range_info:tInfoParm1: ",pInfoParm1,0,0);
		if (pInfoParm->pi_alen & D_AULN_COMPLEX_DATA)
			pInfoParm2->pi_scale |= D_DATA_IMAGE;
DEBUGOUT_InfoParm(194,"cl_get_range_info:tInfoParm2: ",pInfoParm2,0,0);

		interval = 1;
		term = 3;		/* tԂ̃ftHǵA'D' */
		if (iINTVAL) {
			cl_gx_copy_info(pInfoParm3,pInfoParm);
			pInfoParm3->pi_aux[0] = pInfoParm3->pi_alen = 0;
			if (atr1==DEF_ZOK_CHAR || atr1==DEF_ZOK_BINA || atr1==DEF_ZOK_DATE) {
				interval = pInfoParm->pi_hlen;
				cl_set_parm_bin(pInfoParm3,interval);
				if (atr1 == DEF_ZOK_DATE) {
					pInfoParm3->pi_hlen = term = pInfoParm->pi_pos;
				}
/*
printf("cl_get_range_info: term=%d interval=%d\n",term,interval);
*/
			}
			else pInfoParm3->pi_data = pInfoParm2->pi_data + len;
			nrange++;
		}
		iVal[1] = interval;
		if (opt & 0x01) {
			if (atr1==DEF_ZOK_CHAR || atr1==DEF_ZOK_BINA) {
/*
printf("cl_get_range_info: s2=[%s] s1=[%s]\n",pInfoParm2->pi_data,pInfoParm1->pi_data);
*/
				if (atr1 == DEF_ZOK_CHAR) {
					m1 = akxqkanjilen(p1=pInfoParm1->pi_data);
					m2 = akxqkanjilen(p2=pInfoParm2->pi_data);
					ret = akxcmb2ul(p2,m2) - akxcmb2ul(p1,m1);
				}
				else {
					memcpy(&lVal1,pInfoParm1->pi_data,len);
					memcpy(&lVal2,pInfoParm2->pi_data,len);
					ret = lVal2 - lVal1;
				}
			/*	if (!ret) ret = 1;
				else */if (iINTVAL && interval) ret = ret/interval;
				ret++;
				if (ret < 1) ret = 1;
			}
			else {
				if (atr1 == DEF_ZOK_DATE) {
					ppInfo[0] = &tInfo;
					cl_set_parm_long(ppInfo[0],term);
					ppInfo[1] = pInfoParm2;
					ppInfo[2] = pInfoParm1;
					if ((ret=cl_func_date_diff(&tInfoParm,3,ppInfo)) < 0) return ret;
				}
				else {
					if ((ret=cl_gx_bexp(&tInfoParm,pInfoParm2,"-",pInfoParm1,0,0)) < 0) return ret;
				}
DEBUGOUT_InfoParm(194,"cl_get_range_info: ret=%d tInfoParm: ",&tInfoParm,ret,0);
				if (ret=cl_get_parm_bin(&tInfoParm,&n,"v2-v1: ")) return ret;
/*
printf("cl_get_range_info:1 n=%d\n",n);
*/
				if (!n) n = 1;
				else {
					if (iINTVAL && (atr1!=DEF_ZOK_DATE || interval!=1)) {
						if ((ret=cl_gx_bexp(&tInfoParm2,&tInfoParm,"/",pInfoParm3,0,0)) < 0) return ret;
						if (ret=cl_get_parm_bin(&tInfoParm2,&n,"count: ")) return ret;
					}
					n++;	/* I[Z */
				}
				ret = n;
/*
printf("cl_get_range_info:2 n=%d\n",ret);
*/
			}
			if (ret < 1) ret = 1;
			iVal[0] = ret;	/* JԂɂ́APȏオ */
		}
		if (ppParm[0]->pi_attr == DEF_ZOK_BINA) {
			ppParm[0]->pi_scale |= iU;
			ppParm[1]->pi_scale |= iU;
			ppParm[2]->pi_scale |= iU;
		}
		if (iCOMPLEX) ppParm[1]->pi_scale |= D_DATA_IMAGE;
	}
	return nrange;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_dec_max_pre(pWork,nparm,ppParm)
long *pWork;
int  nparm;
tdtInfoParm *ppParm[];
{
	int m,ret;
	long lVal;

	ret = 0;
	if (nparm > 0) {
		if (cl_get_parm_bin(ppParm[0],&m,"dec_max_pre:")) return ECL_SCRIPT_ERROR;
		if (!(cl_get_option(2,0) & 0x10)) {
			if (m > MAX_DEC_PRE1) m = MAX_DEC_PRE1;
		}
		else if (m > MAX_DEC_PRECISION) m = MAX_DEC_PRECISION;
		lVal = m_set_nmpa10(m);
		if (lVal > NMPA10) {
			ret=cl_array_adjust_dec_val();
		}
	}
	else lVal = m_get_nmpa10();
	*pWork = lVal;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_array_adjust_dec_val()
{
	static char *_name_="cl_array_adjust_dec_val";
	XHASHB *pha_vnames[D_MAX_SCOPE];
	tdtInfoParm ***pTBL_vnames[D_MAX_SCOPE],***pTBL,*pInfoParm;
	int rc,m,i,k,kk,ix,sizeMPA,n,j,len,siz;
	char *var,*p,*p0,*pv;
	XHASHB *pha_vname;
	tdtArrayIndex *pIndex;
	ScrPrCT *scrct;
	ProcCT  *proc;
	MPA *ma;

	if (!(scrct = cl_search_src_ct())) return ECL_SYSTEM_ERROR;
	proc = cl_search_proc_ct();

	kk = 1;
	if (proc) {
		pha_vnames[0] = proc->pha_vnam;
		pTBL_vnames[0] = proc->pTBL_vnam;
		kk = 0;
	}
	pha_vnames[1] = scrct->Vary->pha_vnam;
	pha_vnames[2] = pCLprocTable->pha_vnam;
	pha_vnames[3] = pGLprocTable->pha_vnam;

	pTBL_vnames[1] = scrct->Vary->pTBL_vnam;
	pTBL_vnames[2] = pCLprocTable->pTBL_vnam;
	pTBL_vnames[3] = pGLprocTable->pTBL_vnam;

	for (k=kk;k<D_MAX_SCOPE;k++) {
		pTBL = pTBL_vnames[k];
		pha_vname = pha_vnames[k];
		m = akxs_xhash2(pha_vname,'M',NULL,NULL);
		for (i=1;i<=m;i++) {
			pha_vname->xha_xhix = i;
			if ((ix=akxs_xhash2(pha_vname,'K',NULL,NULL)) < 0) return ix;
			else if (ix > 0) {
				pInfoParm = cl_get_var_ent(pTBL,ix);
				if (pInfoParm->pi_id=='R' && pInfoParm->pi_aux[0]==DEF_ZOK_DECI) {
					pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
					sizeMPA = sizeofMPA();
					siz = pIndex->size;
/*
printf("%s: siz=%d sizeMPA=%d name=[%s]\n",_name_,siz,sizeMPA,nval(pInfoParm->pi_pos));
*/
					if (siz < sizeMPA) {
						var = (char *)pIndex->pVarIndex;
						n = pIndex->index[1];
/*
printf("%s: n=%d\n",_name_,n);
*/
						len = sizeMPA*n;
						if (pInfoParm->pi_scale & D_DATA_INDEX_FREE)
							p0 = Malloc(len);
						else
							p0 = cl_tmp_const_malloc(len);
						if (!p0) return ECL_MALLOC_ERROR;
						memset(p0,0,len);
						p = p0;
						pv = var;
						ma = (MPA *)pv;
/*
printf("%s: alen=%d\n",_name_,ma->alen);
*/
						for (j=0;j<n;j++) {
							memcpy(p,pv,siz);
							ma = (MPA *)p;
							ma->alen = sizeMPA;
							p += sizeMPA;
							pv += siz;
						}
						pIndex->pVarIndex = (tdtInfoParm **)p0;
						if (pInfoParm->pi_scale & D_DATA_INDEX_FREE) Free(var);
						pIndex->size = sizeMPA;
					}
				}
			}
		}
	}
	return 0;
}

/********1*********2*********3*********4*********5*********6*/
/*  : nparm		: pParm[]̗vf						*/
/*		  pParm[]	: p[^z						*/
/*		  pParmW[]	: pnama[]ɑΉInfoParmԂz	*/
/*						NULLNAĂ邱			*/
/*		  pnama[]	: p[^̔z					*/
/*		  max_stra	: pnama[]̗vf						*/
/*					  < 0 : pnama[]NULLI[				*/
/************************************************************/
int cl_get_pname_info(nparm,pParm,pParmW,pnama,max_stra)
tdtInfoParm *pParm[],*pParmW[];
char nparm,*pnama[];
int max_stra;
{
	tdtInfoParm *pInfoParm,*pInfoParmC;
	char *name;
	int ret,i,n;

	ret = n = 0;
	for (i=0;i<nparm;i++) {
		pInfoParm = pParm[i];
		if (pInfoParm->pi_id == D_DATA_ID_PNAME) {
			name = (char *)pInfoParm->pi_paux;
			if ((ret=akxs_seqr_str(pnama,max_stra,name,1)) > 0) {
				ret--;
				pInfoParmC = (tdtInfoParm *)pInfoParm->pi_pos;
				if (pInfoParmC->pi_id == 'S') pInfoParmC = (tdtInfoParm *)pInfoParmC->pi_pos;
				if (pParmW[ret]) {
							/* %s: O[%s]̖Ot܂B*/
					ERROROUT2(FORMAT(419),"cl_get_pname_info",name);
					n = ECL_SCRIPT_ERROR;
					break;
				}
				else {
					n++;
					pParmW[ret] = pInfoParmC;
				}
			}
			else if (!ret) {
						/* %s: Ot̖O[%s]Ă܂B*/
				ERROROUT2(FORMAT(418),"cl_get_pname_info",name);
				n = ECL_SCRIPT_ERROR;
				break;
			}
		}
	}
	return n;
}
