static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akxsRb.c									*/
/*												*/
/*		coded by A.Kobayashi 2010.5.20			*/
/*												*/
/************************************************/
#include "akxcommon.h"

/* 01 */
tdtRbCtl *akxs_rb_new2(lBS,lRM,m_alloc,pConstCt)
int lBS,lRM;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	tdtRbCtl *pCt;
	tdtRbChain *p1,*p2;
	int ret;

	pCt = (tdtRbCtl *)akxm_malloc_constct(m_alloc,pConstCt,sizeof(tdtRbCtl));
	if (!pCt) return NULL;
	memset(pCt,0,sizeof(tdtRbCtl));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	ret = akxm_malloc_constct_pp(m_alloc,pConstCt,sizeof(tdtRbChain),(char **)&p1);
	if (!p1) {
		if (!ret) Free(pCt);
		return NULL;
	}
	pCt->rb_cur = pCt->rb_waddr = pCt->rb_raddr = p1;
	p1->rbc_buf = NULL;
	ret = akxm_malloc_constct_pp(m_alloc,pConstCt,sizeof(tdtRbChain),(char **)&p2);
	if (!p2) {
		if (!ret) {
			Free(pCt);
			Free(p1);
		}
		return NULL;
	}
	pCt->rb_wpriv = p2;
	p2->rbc_buf = NULL;
	p1->rbc_next = p2;
	p2->rbc_next = p1;
	pCt->rb_num = 2;
	pCt->rb_malloc = m_alloc;
	pCt->rb_constct = pConstCt;
/*
printf("akxs_rb_new2: p1=%08x p2=%08x\n",p1,p2);
*/
	return pCt;
}

/* 02 */
tdtRbCtl *akxs_rb_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_rb_new2(lBS,lRM,NULL,NULL);
}

/* 04 */
char *akxs_rb_get(pCt)
tdtRbCtl *pCt;
{
	char *p;

	p = NULL;
	if (pCt) {
		if (pCt->rb_used > 0) p = pCt->rb_raddr->rbc_buf;
	}
	return p;
}

/* 05 */
char *akxs_rb_get_n(pCt)
tdtRbCtl *pCt;
{
	char *p;
	tdtRbChain *pr;

	p = NULL;
	if (pCt) {
		if (pCt->rb_used > 0) {
			if (pr = pCt->rb_raddr) {
				if (p=pr->rbc_buf) {
					pr->rbc_buf = NULL;
					pCt->rb_raddr = pr->rbc_next;
					pCt->rb_used--;
				}
/*
printf("akxs_rb_get_n: pr=%08x p=%08x\n",pr,p);
*/
				pCt->rb_cur = pCt->rb_raddr;
				pCt->rb_pos = 0;
			}
		}
	}
	return p;
}

/* 06 */
char *akxs_rb_set_n(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn, *pp;
/*
printf("akxs_rb_set_n: pCt=%08x addr=%08x\n",pCt,addr);
*/
	if (!pCt || !addr) return NULL;

	if (!(pw = pCt->rb_waddr)) return NULL;
	if (pw->rbc_buf) {
		pn = (tdtRbChain *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRbChain));
		if (!pn) return NULL;
		pp = pCt->rb_wpriv;
		pCt->rb_waddr = pp->rbc_next = pn;
		pn->rbc_next = pw;
		pw = pCt->rb_waddr;
		pCt->rb_num++;
	}
/*
printf("akxs_rb_set_n: pw=%08x pw->rbc_next=%08x\n",pw,pw->rbc_next);
printf("akxs_rb_set_n: pCt->rb_raddr=%08x pCt->rb_wpriv=%08x\n",pCt->rb_raddr,pCt->rb_wpriv);
*/
	pw->rbc_buf = addr;
	pCt->rb_waddr = pw->rbc_next;
	pCt->rb_wpriv = pw;
	pCt->rb_used++;
	return addr;
}

/* 07 */
int akxs_rb_free(pCt)
tdtRbCtl *pCt;
{
	tdtRbChain *pw, *pn, *pp;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	if (pp = pCt->rb_wpriv) {
		pw = pp->rbc_next;
		pp->rbc_next = NULL;
		while (pw) {
			pn = pw->rbc_next;
			if (!m_alloc) Free(pw);
			pw = pn;
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

/* 08 */
int akxs_rb_buf_free(pCt)
tdtRbCtl *pCt;
{
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;

	m_alloc = pCt->rb_malloc;
	while (p=akxs_rb_get_n(pCt)) {
		if (!m_alloc) Free(p);
	}
	return 0;
}

/* 09 */
int akxs_rb_all_free(pCt)
tdtRbCtl *pCt;
{
	int  iRc;

	if (!(iRc = akxs_rb_buf_free(pCt))) iRc = akxs_rb_free(pCt);

	return iRc;
}

/* 10 */
char *akxs_rb_set_t(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn, *pp;

	if (!pCt || !addr) return NULL;
	if (!akxs_rb_get(pCt)) return akxs_rb_set_n(pCt,addr);

	pw = pCt->rb_waddr;
	while ((pp=pw->rbc_next) != pCt->rb_raddr) {
		pw = pp;
	}

	if (pw->rbc_buf) {
		pn = (tdtRbChain *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRbChain));
		if (!pn) return NULL;
		pw->rbc_next = pn;
		pn->rbc_next = pp;
		pw = pn;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	if (pCt->rb_raddr == pCt->rb_waddr) {
		pCt->rb_waddr = pw;
	}
/*
printf("akxs_rb_set_t: pw=%08x addr=%08x\n",pw,addr);
*/
	pCt->rb_raddr = pw;
	pCt->rb_used++;
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return addr;
}

/* 11 */
char *akxs_rb_read(pCt, cmd)
tdtRbCtl *pCt;
int	 cmd;
{
	tdtRbChain *pr;
	char *p=NULL;

	if (pCt) {
		if (!cmd) {
			pr = pCt->rb_raddr;
			pCt->rb_pos = 0;
		}
		else {
			if (pCt->rb_pos >= pCt->rb_used) return NULL;
			if (pCt->rb_pos) {
				pr = pCt->rb_cur;
				pCt->rb_cur = pr->rbc_next;
			}
			else pCt->rb_cur = pCt->rb_raddr;
			pr = pCt->rb_cur;
			pCt->rb_pos++;
		}
		p = pr->rbc_buf;
	}
	return p;
}

/* 12 */
int akxs_rb_exchg(pCt1, pCt2, opt)
tdtRbCtl *pCt1,*pCt2;
int opt;
{
	tdtRbCtl tCtW;

	if (!pCt1 || !pCt2) return -1;
	tCtW  = *pCt1;
	*pCt1 = *pCt2;
	*pCt2 = tCtW;
	return 0;
}

/* 13 */
int akxs_rb_used(pCt)
tdtRbCtl *pCt;
{
	if (!pCt) return -1;
	return pCt->rb_used;
}

/* 14 */
char *akxs_rb_srch(pCt, addr, compar)
tdtRbCtl *pCt;
char *addr;
int (*compar)();
{
	int f;
	tdtRbChain *pr;
	char *p;

	if (!pCt || !addr) return NULL;
	if (!compar) compar = strcmp;
	pr = pCt->rb_raddr;
	while (p=pr->rbc_buf) {
		if (!compar(addr,p)) return p;
		pr = pr->rbc_next;
		if (pr == pCt->rb_waddr) break;
	}
	return NULL;
}

/************************************************/
/*												*/
/*		List									*/
/*	21											*/
/************************************************/
tdtRbCtl *akxs_list_new2(lBS,lRM,m_alloc,pConstCt)
int lBS,lRM;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	tdtRbCtl *pCt;

	pCt = (tdtRbCtl *)akxm_malloc_constct(m_alloc,pConstCt,sizeof(tdtRbCtl));
	if (!pCt) return NULL;
	memset(pCt,0,sizeof(tdtRbCtl));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	pCt->rb_malloc = m_alloc;
	return pCt;
}

/* 22 */
tdtRbCtl *akxs_list_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_list_new2(lBS,lRM,NULL,NULL);
}

/* 23 */
int akxs_list_free(pCt,free_func)
tdtRbCtl *pCt;
int (*free_func)();
{
	tdtRbChain *pw, *pn, *pp;
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	while (akxs_list_get(pCt,&p) > 0) {
		if (p) {
			if (free_func) free_func(p);
			else if (!m_alloc) Free(p);
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

/* 24 */
int akxs_list_get(pCt,pp)
tdtRbCtl *pCt;
char **pp;
{
	tdtRbChain *pr;

	if (!pCt) return -1;
	
	if (pr = pCt->rb_raddr) {
		*pp = pr->rbc_buf;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
		if (pr == pCt->rb_waddr) pCt->rb_waddr = NULL;
		Free(pr);
		return 1;
	}
	else return 0;
}

/* 25 */
int akxs_list_set(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn;

	if (!pCt) return -1;

	pn = (tdtRbChain *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRbChain));
	if (!pn) return 0;
	pn->rbc_buf = addr;
	pn->rbc_next = NULL;
	if (pw = pCt->rb_waddr) pw->rbc_next = pn;
	else pCt->rb_raddr = pn;
	pCt->rb_waddr = pn;
	pCt->rb_used++;
	return 1;
}

/* 26 */
int akxs_list_srch(pCt, addr, compar, opt)
tdtRbCtl *pCt;
char *addr;
int (*compar)();
int opt;
{
	int f;
	tdtRbChain *pr,*pre;
	char *p;

	if (!pCt) return -1;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
		if (compar) f = !compar(addr,pr->rbc_buf);
		else f = (addr == pr->rbc_buf);
		if (f) {
			if (opt) {
				if (pre) pre->rbc_next = pr->rbc_next;
				else pCt->rb_raddr = pr->rbc_next;
				if (!pr->rbc_next) pCt->rb_waddr = pre;
				pCt->rb_used--;
			}
			pCt->rb_cur = pr;
			return 1;
		}
		pre = pr;
		pr = pr->rbc_next;
	}
	return 0;
}

/* 27 */
int akxs_list_read(pCt, cmd, pp)
tdtRbCtl *pCt;
int     cmd;
char   **pp;
{
	tdtRbChain *pr;

	if (!pCt) return -1;

	if (!cmd) {
		pCt->rb_cur = NULL;
	}
	else {
		if (cmd > 0) {
			if (pr = pCt->rb_cur) pr = pr->rbc_next;
			else pr = pCt->rb_raddr;
		}
		else {
			if (!(pr = pCt->rb_cur)) pr = pCt->rb_raddr;
		}
		if (pr) {
			pCt->rb_cur = pr;
			*pp = pr->rbc_buf;
			return 1;
		}
	}
	return 0;
}

/************************************************/
/*												*/
/*		Stack									*/
/*												*/
/************************************************/
/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂								31	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				max_stack	: X^bN							*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*								stack->wdmax = max_stack			*/
/*								stack->sp = 0						*/
/*								((char **)stack->wd)[] = NULL		*/
/*	ԋp : = 0 													*/
/*		   =-2 max_stack <= 0										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_init(SSPL_S *stack,int max_stack)
{
	int ret;

	ret = 0;
	if (max_stack <= 0) ret -= 2;
	if (ret == 0) {
		stack->wdmax = max_stack;
		stack->sp = 0;
		mem_set_addr((char **)stack->wd,NULL,max_stack);
	}
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂쐬A						32	*/
/*	 : IN : max_stack	: X^bN							*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*								stack->wdmax = max_stack			*/
/*								stack->sp = 0						*/
/*								((char **)stack->wd)[] = NULL		*/
/*	ԋp : != NULL 												*/
/*		   =  NULL G[											*/
/*	쐬 : 2020/01/27 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
SSPL_S *akxs_stack_new(int max_stack)
{
	SSPL_S *stack;
	int ret;

	stack = NULL;
	if (max_stack > 0) {
		if (stack = (SSPL_S *)Malloc(sizeof(SSPL_S))) {
			if (stack->wd = Malloc(sizeof(char *)*max_stack)) {
				akxs_stack_init(stack,max_stack);
			}
			else {
				Free(stack);
				stack = NULL;
			}
		}
	}
	return stack;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂J								33	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*	ԋp : = 0 													*/
/*		   =-1 stack = NULL											*/
/*	쐬 : 2020/01/27 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_free(SSPL_S *stack)
{
	int ret;

	ret = 0;
	if (stack) {
		Free(stack->wd);
		Free(stack);
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ X^bNɐς											34	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bNɐςޒl						*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  ((char **)stack->wd)[stack->sp] = val */
/*							  stack->sp++							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-4 : X^bNI[o									*/
/*	쐬 :2014/12/01 AkitoKobayashi									*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_push(SSPL_S *stack,char *val)
{
	int ret;
	char **p;

	ret = 0;
	if (stack) {
		if (stack->sp >= stack->wdmax)
			ret = -4;
		else {
			p = (char **)(stack->wd);
			p[stack->sp] = val;
			stack->sp++;
		}
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN̂A܂́AX^bNo		35	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*				isPeek		: PeektO							*/
/*								= 0 : X^bNo			*/
/*								!=0 : X^bN̂				*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  X^bNoƤ				*/
/*								stack->sp--							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
static int _PopPeekStack(SSPL_S *stack,char **val,int isPeek)
{
	int ret;
	char **p;

	ret = 0;
	if (stack && val) {
		if (stack->sp <= 0)
			ret = -8;
		else {
			p = (char **)(stack->wd);
			*val = p[stack->sp - 1];
			if (isPeek == 0) stack->sp--;
		}
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bNo									36	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*		   OUT: val			: ol							*/
/*				stack		: X^bN\̂̃o				*/
/*								stack->sp--							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_pop(SSPL_S *stack,char **val)
{

	return _PopPeekStack(stack, val, 0);

}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN̂										37	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*		   OUT: val			: ̂l							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_peek(SSPL_S *stack,char **val)
{

	return _PopPeekStack(stack, val, 1);

}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ :X^bNT[`AȂΓo^					38	*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bNɓo^l					*/
/*				Optional 	: opt 0x01=1 : o^					*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  o^Ƃ́A						*/
/*							  ((char **)stack->wd)[stack->sp] = val */
/*							  stack->sp++							*/
/*	ԋp :	> 0 : o^ʒu + 1										*/
/*			=-4 : X^bNI[o									*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2018/03/15 Aki to Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_srch(SSPL_S *stack,char *val,int opt)
{
	int ret,i;
	char **p;

	ret = 0;
	if (stack && val) {
		p = (char **)(stack->wd);
		for (i = 0; i< stack->sp - 1; i++) {
			if (p[i] == val) {
				ret = i + 1;
				break;
			}
		}
		if (opt & 0x01) ret = akxs_stack_push(stack, val);
	}
	else ret = -1;
	return ret;
}

/****************************************/
/*	41									*/
/*	`FbN͂Ȃ				*/
/****************************************/
MCAT2 *akxs_layer_new(imax,m_alloc,pConstCt)
int imax;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	/* 2022.10.30 */
	return akxs_mseq_new(sizeof(long),-imax,m_alloc,pConstCt);
}

/****************************************/
/*	42									*/
/****************************************/
int akxs_layer_i(mcat)
MCAT2 *mcat;
{
	/* 2022.10.30 */
	return akxs_mseq_i(mcat);
}

/****************************************/
/*	43									*/
/*	ilay  : R[hԍ(0擪)		*/
/*			<0 : ɒǉ			*/
/****************************************/
int akxs_layer_set(mcat,ilay,lVal)
MCAT2 *mcat;
int ilay;
long lVal;
{
	/* 2022.10.30 */
	return akxs_mseq_set(mcat,ilay+1,&lVal);
}

/****************************************/
/*	44									*/
/****************************************/
int akxs_layer_r(mcat,lVal)
MCAT2 *mcat;
long lVal;
{
	/* 2022.10.30 */
	return akxs_mseq_r(mcat,&lVal);
}

/****************************************/
/*	45									*/
/****************************************/
int akxs_layer_s(mcat,lVal)
MCAT2 *mcat;
long lVal;
{
	int ii;

	if (!(ii=akxs_layer_r(mcat,lVal))) {
		ii = akxs_layer_set(mcat,-1,lVal);
	}
	return ii;
}

/*	51	*/
/********1*********2*********3*********4*********5*********6*********/
/* @\ : Œ蒷R[hǗ\̂𐶐					*/
/*  : IN  : mlen		: R[h(L[{f[^)(oCg)	*/
/*				imax		: ő僌R[h						*/
/*							  imax<=0̂Ƃ́A`FbNȂ	*/
/*							  imax=0̂Ƃ́Aimax=256Ƃ		*/
/*							  imax<0̂Ƃ́Aimax=-imaxƂ		*/
/*							  ́Amax(imax/10,10)R[h	*/
/*							  ubNŊg					*/
/*				dlen 		: f[^(oCg)					*/
/*				m_alloc		: mۊ֐(=NULL:mallocg)	*/
/*				pConstCt	: ConstCtւ̃|C^(=NULL:ConstCtgp)*/
/*		  OUT : Ȃ												*/
/* ԋp :	<>MULL : Ǘ\̂ւ̃|C^					*/
/*			= NULL : G[											*/
/* 쐬 : 2023/05/20 Aki to Kobayashi								*/
/* XV :															*/
/********************************************************************/
MCAT2 *akxs_mseq2_new(mlen,imax,dlen,m_alloc,pConstCt)
int mlen,imax,dlen;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	MCAT2 *p;

	if (dlen < 0) dlen = 0;
	else if (mlen<=0 || dlen>mlen) return NULL;

	if (!(p=(MCAT2 *)akxm_malloc_constct(m_alloc,pConstCt,sizeof(MCAT2)))) {
		errno = -185215101;
		return NULL;
	}
	memset(p,0,sizeof(MCAT2));
	if (imax < 0) imax = -imax;
	else p->mc_maxcnt = imax;
	if (!imax) imax = 256;
	p->mc_id[0] = 'M';
	p->mc_id[1] = 'S';
	p->mc_extlen = X_MAX(imax/10,10);
	p->mc_malloc = m_alloc;
	p->mc_constct = pConstCt;
	p->mc_mlen = mlen;
	p->mc_resv = dlen;
/*
printf("akxs_mseq2_new: extlen=%d p->mc_maxcnt=%d\n",p->mc_extlen,p->mc_maxcnt);
*/
	return p;
}

/****************************************/
/*	51-1								*/
/****************************************/
MCAT2 *akxs_mseq_new(mlen,imax,m_alloc,pConstCt)
int mlen,imax;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	return akxs_mseq2_new(mlen,imax,0,m_alloc,pConstCt);
}

/****************************************/
/*	52									*/
/****************************************/
int akxs_mseq_i(mcat)
MCAT2 *mcat;
{
	int ret;

	ret = 0;
	if (mcat) mcat->mc_ipos = 0;
	else ret = -1;
	return ret;
}

/*	53	*/
/********1*********2*********3*********4*********5*********6*********/
/* @\ : ɃR[hZbg							*/
/*  : IN  : mcat	: Œ蒷R[hǗ\̂ւ̃|C^*/
/*				ilay	: ݒʒu									*/
/*						  <= 0 : ɒǉ						*/
/*						  >  0 : R[hʒu(1擪)				*/
/*								 Zbgςݍő僌R[hԍz */
/*								 Ƃ́Ailay܂ރubN܂	*/
/*								 g							*/
/*				mem 	: Zbg郌R[h						*/
/*		  OUT : mcat	:											*/
/*					mcat->mc_extlen : ̊gR[h			*/
/*					mcat->mc_bufp   : ւ̃|C^			*/
/*					mcat->mc_ipos   : R[hʒu(1擪)		*/
/* ԋp : > 0 : ZbgR[hԍ(1擪)						*/
/*		  < 0 : G[												*/
/* 쐬 : 2023/05/20 Aki to Kobayashi								*/
/* XV :															*/
/********************************************************************/
int akxs_mseq_set(mcat,ilay,mem)
MCAT2 *mcat;
int ilay;
char *mem;
{
	int ii,extlen,alen,mlen,pos,imax,alclen;
	char *p,*pp;

	if (!mcat || !mem) return -1;
/*
printf("akxs_mseq_set:Enter ilay=%d mcat->mc_ipos=%d\n",ilay,mcat->mc_ipos);
*/
	mlen = mcat->mc_mlen;
	imax = mcat->mc_maxcnt;
	if (ilay <= 0) ilay = mcat->mc_ipos;
	else if (imax && ilay>imax) return -2;
	else ilay--;
	pos = ilay*mlen;
	if (ilay >= (alen=mcat->mc_alclen)) {
		if (!(extlen=mcat->mc_extlen)) extlen = 10;
		alclen = (ilay/extlen + 1)*extlen;
		if (imax && alclen>imax) alclen = imax;
/*
printf("akxs_mseq_set: ilay=%d imax=%d extlen=%d alclen=%d\n",ilay,imax,extlen,alclen);
*/
		mcat-> mc_alclen = alclen;
		if (!(p = akxm_malloc_constct(mcat->mc_malloc,mcat->mc_constct,alclen*mlen))) return -1;
		if (pp=mcat->mc_bufp) {
			if (alen) memcpy(p,pp,alen*mlen);
			if (!mcat->mc_malloc) Free(pp);
		}
		mcat->mc_bufp = p;
		mcat->mc_extlen = extlen + extlen;
	}
	memcpy(mcat->mc_bufp+pos,mem,mlen);
	ii = ilay + 1;
	if (ii > mcat->mc_ipos) {
/*
printf("akxs_mseq_set: ii=%d\n",ii);
*/
		mcat->mc_ipos = ii;
	}
	return ii;
}

/*	54	*/
/********1*********2*********3*********4*********5***/
/* ԋp : > 0 : R[hԍ(1擪)		*/
/*		  = 0 : Ȃ					*/
/*		  < 0 : G[								*/
/****************************************************/
int akxs_mseq_r(mcat,mem)
MCAT2 *mcat;
char *mem;
{
	int i,ii,imax,ipos,mlen,dlen,pos;
	char *p;

	if (!mcat || !mem) return -1;

	mlen = mcat->mc_mlen;
	dlen = mcat->mc_resv;
	pos = mlen - dlen;
	ii = 0;
	ipos = mcat->mc_ipos;
	imax = ipos;
	p = mcat->mc_bufp;
	for (i=0;i<imax;i++) {
		if (!memcmp(p,mem,mlen-dlen)) {
			ii = i + 1;
			break;
		}
		p += mlen;
	}
	if (dlen > 0) {
		if (ii > 0) memcpy(mem+pos,p+pos,dlen);
		else memset(mem+pos,0,dlen);
	}
	return ii;
}

/****************************************/
/*	55									*/
/****************************************/
int akxs_mseq_s(mcat,mem)
MCAT2 *mcat;
char *mem;
{
	int ii;

	if (!mcat || !mem) return -1;

	if (!(ii=akxs_mseq_r(mcat,mem))) {
		ii = akxs_mseq_set(mcat,-1,mem);
	}
	return ii;
}

/*	56	*/
/********1*********2*********3*********4*********5*******/
/*  : IN  : ilay	: 擾ʒu						*/
/*						  <= 0 : ̃R[h			*/
/*						  >  0 : R[hʒu(1擪)	*/
/********************************************************/
int akxs_mseq_get(mcat,ilay,mem)
MCAT2 *mcat;
int ilay;
char *mem;
{
	int ret,mlen;

	if (!mcat || !mem) return -1;

	if (ilay <= 0) ilay = mcat->mc_ipos;
	ilay--;
/*	if (ilay >= mcat->mc_alclen)	*/
	if (ilay<0 || ilay>=mcat->mc_ipos)
		ret = -1;
	else {
		mlen = mcat->mc_mlen;
		memcpy(mem,mcat->mc_bufp+ilay*mlen,mlen);
		ret = 0;
	}
	return ret;
}
