/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Assignment;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.MarkupOutputFormat;
import freemarker.core.NonNamespaceException;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateElements;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BlockAssignment
extends TemplateElement {
    private final String varName;
    private final Expression namespaceExp;
    private final int scope;
    private final MarkupOutputFormat<?> markupOutputFormat;

    BlockAssignment(TemplateElements children, String varName, int scope, Expression namespaceExp, MarkupOutputFormat<?> markupOutputFormat) {
        this.setChildren(children);
        this.varName = varName;
        this.namespaceExp = namespaceExp;
        this.scope = scope;
        this.markupOutputFormat = markupOutputFormat;
    }

    @Override
    TemplateElement[] accept(Environment env) throws TemplateException, IOException {
        TemplateElement[] children = this.getChildBuffer();
        if (children != null) {
            env.visitAndTransform(children, new CaptureOutput(env), null);
        } else {
            TemplateModel value = this.capturedStringToModel("");
            if (this.namespaceExp != null) {
                Environment.Namespace ns = (Environment.Namespace)this.namespaceExp.eval(env);
                ns.put(this.varName, value);
            } else if (this.scope == 1) {
                env.setVariable(this.varName, value);
            } else if (this.scope == 3) {
                env.setGlobalVariable(this.varName, value);
            } else if (this.scope == 2) {
                env.setLocalVariable(this.varName, value);
            }
        }
        return null;
    }

    private TemplateModel capturedStringToModel(String s) throws TemplateModelException {
        return this.markupOutputFormat == null ? new SimpleScalar(s) : this.markupOutputFormat.fromMarkup(s);
    }

    @Override
    protected String dump(boolean canonical) {
        StringBuilder sb = new StringBuilder();
        if (canonical) {
            sb.append("<");
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(this.varName);
        if (this.namespaceExp != null) {
            sb.append(" in ");
            sb.append(this.namespaceExp.getCanonicalForm());
        }
        if (canonical) {
            sb.append('>');
            sb.append(this.getChildrenCanonicalForm());
            sb.append("</");
            sb.append(this.getNodeTypeSymbol());
            sb.append('>');
        } else {
            sb.append(" = .nested_output");
        }
        return sb.toString();
    }

    @Override
    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    @Override
    int getParameterCount() {
        return 3;
    }

    @Override
    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.varName;
            }
            case 1: {
                return this.scope;
            }
            case 2: {
                return this.namespaceExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.ASSIGNMENT_TARGET;
            }
            case 1: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 2: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    boolean isNestedBlockRepeater() {
        return false;
    }

    private class CaptureOutput
    implements TemplateTransformModel {
        private final Environment env;
        private final Environment.Namespace fnsModel;

        CaptureOutput(Environment env) throws TemplateException {
            this.env = env;
            TemplateModel nsModel = null;
            if (BlockAssignment.this.namespaceExp != null && !((nsModel = BlockAssignment.this.namespaceExp.eval(env)) instanceof Environment.Namespace)) {
                throw new NonNamespaceException(BlockAssignment.this.namespaceExp, nsModel, env);
            }
            this.fnsModel = (Environment.Namespace)nsModel;
        }

        public Writer getWriter(Writer out, Map args) {
            return new StringWriter(){

                public void close() throws IOException {
                    TemplateModel result;
                    try {
                        result = BlockAssignment.this.capturedStringToModel(this.toString());
                    }
                    catch (TemplateModelException e) {
                        throw new IOException("Failed to create FTL value from captured string: " + e);
                    }
                    switch (BlockAssignment.this.scope) {
                        case 1: {
                            if (CaptureOutput.this.fnsModel != null) {
                                CaptureOutput.this.fnsModel.put(BlockAssignment.this.varName, result);
                                break;
                            }
                            CaptureOutput.this.env.setVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 2: {
                            CaptureOutput.this.env.setLocalVariable(BlockAssignment.this.varName, result);
                            break;
                        }
                        case 3: {
                            CaptureOutput.this.env.setGlobalVariable(BlockAssignment.this.varName, result);
                        }
                    }
                }
            };
        }
    }
}

