/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateSerializer
extends JsonSerializer<Date> {
    public void serialize(Date date, JsonGenerator json, SerializerProvider provider) throws IOException, JsonProcessingException {
        long epochMilli = date.getTime();
        Instant instant = Instant.ofEpochMilli(epochMilli);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        String s = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(zonedDateTime);
        json.writeString(s);
    }
}

