/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import net.osdn.util.jersey.ApplicationProblem;
import net.osdn.util.jersey.JacksonConfig;

public abstract class Resource {
    private static final String SOURCE_PATH = "/WEB-INF/src";
    private static final Pattern COMMENT = Pattern.compile("/\\*{1,}(.*?)\\*{1,}/", 32);
    private static final ObjectMapper mapper = new JacksonConfig().getContext(null);
    @Context
    private ContainerRequestContext requestContext;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    protected ServletContext context;
    private PrintWriter logWriter;
    private String[] source;
    private Map<Integer, String> comments = new HashMap<Integer, String>();

    public static String toJsonString(Object value) throws IOException {
        return mapper.writeValueAsString(value);
    }

    public static <T> T fromJsonString(Class<T> cls, String json) throws IOException {
        if (json == null || json.equals("null")) {
            return null;
        }
        return (T)mapper.readValue(json, cls);
    }

    public ContainerRequestContext getRequestContext() {
        return this.requestContext;
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public synchronized PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            try {
                Class<?> logWriterClass = Class.forName("net.osdn.util.jersey.log.LogWriter");
                Constructor<?> constructor = logWriterClass.getConstructor(Integer.TYPE);
                this.logWriter = (PrintWriter)constructor.newInstance(this.getRequestContext().hashCode());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new PrintWriter(new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
        }
        return this.logWriter;
    }

    public void print(boolean b) {
        System.out.print(b);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(char c) {
        System.out.print(c);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(int i) {
        System.out.print(i);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(long l) {
        System.out.print(l);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(float f) {
        System.out.print(f);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(double d) {
        System.out.print(d);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.print(d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(char[] s) {
        if (s != null) {
            System.out.print(s);
        } else {
            System.out.print("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (s != null) {
                    w.print(s);
                } else {
                    w.print("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(String s) {
        if (s != null) {
            System.out.print(s);
        } else {
            System.out.print("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (s != null) {
                    w.print(s);
                } else {
                    w.print("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void print(Object obj) {
        if (obj != null) {
            System.out.print(obj);
        } else {
            System.out.print("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (obj != null) {
                    w.print(obj);
                } else {
                    w.print("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println() {
        System.out.println();
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(boolean b) {
        System.out.println(b);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(char c) {
        System.out.println(c);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(int i) {
        System.out.println(i);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(long l) {
        System.out.println(l);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(float f) {
        System.out.println(f);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(double d) {
        System.out.println(d);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.println(d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(char[] s) {
        if (s != null) {
            System.out.println(s);
        } else {
            System.out.println("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (s != null) {
                    w.println(s);
                } else {
                    w.println("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(String s) {
        if (s != null) {
            System.out.println(s);
        } else {
            System.out.println("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (s != null) {
                    w.println(s);
                } else {
                    w.println("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(Object obj) {
        if (obj != null) {
            System.out.println(obj);
        } else {
            System.out.println("null");
        }
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                if (obj != null) {
                    w.println(obj);
                } else {
                    w.println("null");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void printf(String format, Object ... args) {
        System.out.printf(format, args);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.printf(format, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void printf(Locale l, String format, Object ... args) {
        System.out.printf(l, format, args);
        PrintWriter w = this.getLogWriter();
        if (w != null) {
            try {
                w.printf(l, format, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected String[] getSource() throws MissingResourceException, IOException {
        if (this.source == null) {
            String line;
            String path;
            InputStream in;
            String name = this.getClass().getName();
            int i = name.indexOf(36);
            if (i > 0) {
                name = name.substring(0, i);
            }
            if ((in = this.context.getResourceAsStream(path = "/WEB-INF/src/" + name.replace(".", "/") + ".java")) == null) {
                throw new MissingResourceException(path, name, null);
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            this.source = lines.toArray(new String[0]);
        }
        return this.source;
    }

    protected String below() throws MissingResourceException {
        String[] source;
        int lineNumber = -1;
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length <= 2) {
            return null;
        }
        lineNumber = trace[2].getLineNumber();
        String comment = this.comments.get(lineNumber);
        if (comment != null) {
            return comment;
        }
        StringBuilder sb = new StringBuilder();
        try {
            source = this.getSource();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = lineNumber; i < source.length; ++i) {
            sb.append(source[i].trim());
            sb.append("\n");
        }
        Matcher m = COMMENT.matcher(sb);
        if (m.find()) {
            comment = m.group(1);
            comment = comment.substring(comment.indexOf(10) + 1, comment.lastIndexOf(10));
        } else {
            comment = "";
        }
        this.comments.put(lineNumber, comment);
        return comment;
    }

    protected class Problem
    extends ApplicationProblem {
        private static final long serialVersionUID = 1L;
        private int code;

        public Problem(String title) {
            this(0, title, null);
        }

        public Problem(String title, String detail) {
            this(0, title, detail);
        }

        public Problem(int code, String title, String detail) {
            this.setCode(code);
            this.setTitle(title != null ? title : "");
            this.setDetail(detail != null ? detail : "");
            this.setInstance(Resource.this.getHttpServletRequest().getRequestURI());
        }

        @JsonProperty(value="code")
        public int getCode() {
            return this.code;
        }

        @JsonProperty(value="code")
        public Problem setCode(int code) {
            this.code = code;
            return this;
        }
    }
}

