#######################################
#プロジェクトの修正・削除
#######################################

import sys, configparser, os, time

from PyQt5.QtWidgets import (QVBoxLayout, QLineEdit,QGridLayout,
 QApplication, QLabel, QMenu, QWidget, QHBoxLayout,QDialog,
 QAction, QTextEdit,QPushButton, qApp, QMessageBox, QInputDialog,
 QMainWindow, QFrame, QFileDialog, QCheckBox, QProgressBar,
 QListWidget, QCompleter, QComboBox)
from PyQt5.QtGui import (QIcon, QFont, QColor, QPixmap, QDrag, QPainter,
 QBrush, QPen,QStandardItem,QStandardItemModel)
from PyQt5.QtCore import (QCoreApplication, Qt, QObject, pyqtSignal,
 QMimeData, )
from mysql_delete_project import delete_project

class delete_project_SubWindow(QWidget):

    def __init__(self, projects):
        super().__init__()
        self.projects=projects

        self.open_project()
        self.selected_project=""

    def open_project(self):
        self.w=QDialog()
        label = QLabel()
        label.setText('修正・削除するプロジェクトの選択')

        self.items=QListWidget()
        #item.addItem(projects)
        for n in self.projects:
            self.items.addItem(n)
        self.items.itemClicked.connect(self.get_project_name)

        #correct=QPushButton("修正")
        #correct.clicked.connect(lambda: self.correct_Clicked(self.selected_project))
        #correct.clicked.connect(self.w.close)

        delete=QPushButton("削除")
        delete.clicked.connect(lambda: self.delete_Clicked(self.selected_project))

        cancel=QPushButton("戻る")
        #cancel.clicked.connect(lambda: self.return_main(self.projects))
        cancel.clicked.connect(self.w.close)


        hbox=QHBoxLayout()
        hbox.addStretch(1)
        #hbox.addWidget(correct)
        hbox.addWidget(delete)

        hbox2=QHBoxLayout()
        hbox2.addStretch(2)
        hbox2.addWidget(cancel)

        layout = QVBoxLayout()
        layout.addWidget(label)
        layout.addWidget(self.items)
        layout.addLayout(hbox)
        layout.addStretch(1)
        layout.addLayout(hbox2)
        self.w.setLayout(layout)
        self.w.setWindowTitle('登録済みプロジェクトの削除')
        self.w.setGeometry(650, 300, 300, 320)

    def delete_Clicked(self, item):
        #print(item)
        if item != "":
            ##############################################
            #リストから削除
            ##############################################
            self.projects.remove(item)
            self.items.takeItem(self.project_row)

            ##############################################
            #main,iniファイルを修正
            ##############################################
            itemA=str(self.projects)
            itemA=itemA.replace("'","").replace("[","").replace("]","").replace(" ","")

            time.sleep(0.1)

            g = open("select_project_temp.txt","w")
            g.write(itemA)
            g.close()

            ##############################################
            #データベースからプロジェクトを削除
            ##############################################
            delete_project(item)

            ##############################################
            #プロジェクトのiniファイルを削除
            ##############################################
            remove_file_name=item + ".ini"
            os.remove(remove_file_name)

            time.sleep(0.1)

            ##############################################
            #binファイルとvecファイルの削除
            ##############################################
            path=os.getcwd()
            path=path + "/fastText/" + self.selected_project
            path_bin= path + ".bin"
            path_vec= path + ".vec"
            if os.path.exists(path_bin):
                os.remove(path_bin)

            if os.path.exists(path_vec):
                os.remove(path_vec)

            ##############################################
            #削除対象変数を初期化
            ##############################################
            self.selected_project=""

        else:
            #print("削除するプロジェクトを選択してください")
            message=QMessageBox.information(self,"お知らせ", "削除するプロジェクトを選択してください", QMessageBox.Ok)

    def get_project_name(self, item):
        self.project_name=item.text()
        self.project_row=self.items.currentRow()
        self.selected_project=self.project_name


    def correct_Clicked(self,item):
        if item != "":
            print(item,"を修正します")
        else:
            print("修正するプロジェクトを選択してください")
        #global selected_project
        #selected_project=self.aselected_project

        #g = open("select_project_temp.txt","w")
        #g.write(self.selected_project)
        #g.close()

    def show(self):
        self.w.exec_()

if __name__=="__main__":
    app=QApplication(sys.argv)
    pro=["aa","bb","cc"]
    ex=delete_project_SubWindow(pro).open_project()
    delete_project_SubWindow(pro).show()
    sys.exit(app.exec_())
