import os, sys
from chardet.universaldetector import UniversalDetector
import codecs

def main_code(url):
    code=check_character_code(url)
    #print(code)
    if code != "utf-8":
        encoding(url, code)
    else:
        write_to_temp(url)
        pass

def check_character_code(url):
    detector = UniversalDetector()

    try:
        with open(url, mode='rb') as f:
            while True:
                binary = f.readline()
                if binary == b'':
                    # ファイルを最後まで読みきった
                    break

                detector.feed(binary)
                if detector.done:
                    # 十分な確度でエンコーディングが推定できた
                    break
    finally:
        detector.close()

    encoding_info = detector.result
    en_info = encoding_info.get("encoding")
    #print(type(en_info))
    return en_info

def encoding(url, code):

    #print(code)
    f=codecs.open(url,"r",code, errors="ignore")
    y=f.read()
    f.close()
    s=y.encode("utf-8", errors="ignore")
    t=s.decode("utf-8")

    g=codecs.open("encode_temp.txt","w", "utf-8")
    g.write("")
    g.close()

    g=codecs.open("encode_temp.txt","a", "utf-8")
    for n in t:
        n=n.replace("\r",'')    #追加ポイント
        g.write(n)

    g.close()

def write_to_temp(url):
    g = codecs.open("encode_temp.txt","w", "utf-8")
    g.write("")
    g.close()

    f=codecs.open(url,"r", "utf-8")
    texts=f.read()

    g = codecs.open("encode_temp.txt","a", "utf-8")
    for n in texts:
        n=n.replace("\r",'')    #追加ポイント
        n=n.replace("'",'').replace('"','').replace("'","")
        g.write(n)

    g.close()



if __name__=="__main__":
    #code = check_character_code()
    url="/home/jabba/testcoder/texts/kaiyu.txt"
    #contents=text.readlines()
    #text.close()
    #encoding(contents)
    main_code(url)
