import sys
import configparser
import os


class write_pro_ini():
    def __init__(self,project_name):
######################################################################
#初期化メソット内の（self.ini_check(project_name)でプロジェクトファイルが存在するかどうかを確認
#存在しなければ（self.ini_check(project_name)でプロジェクトファイルを作成し、保存先をリターン
#存在すれば保存先をリターン
#プロジェクトファイルを読み込み、変数にセット
######################################################################

        self.filepath = self.ini_check(project_name)


        config = configparser.ConfigParser()
        config.read(self.filepath)
        self.project_name=config['project']["project_name"]
        self.text_column_no=config['project']["text_column_no"]
        self.category_column_no=config['project']["category_column_no"]
        self.label_column_no=config['project']["label_column_no"]
        self.files=config['project']["files"]
        self.sample=config['project']["sample"]
        self.count_texts_all=config['project']["count_texts_all"]
        self.count_texts_analysis=config['project']["count_texts_analysis"]
        self.original_data_type=config['project']["original_data_type"]
        self.model_path=config['project']["model_path"]
        self.csv_path=config['project']["csv_path"]
        self.train_test=config['project']["train_test"]
        self.nums_of_category=config['project']["nums_of_category"]
        self.nums_of_label=config['project']["nums_of_label"]
        self.tyo_on=config['project']["tyo_on"]
        self.han=config['project']["han"]
        self.zen=config['project']["zen"]
        self.zen_han=config['project']["zen_han"]
        self.basis_word=config['project']["basis_word"]
        self.discrimination=config['project']["discrimination"]
        self.dimensions=config['project']["dimensions"]

######################################################################
#write_pro_iniを実行した時、可変長引数としてカテゴリー数等を取得
#可変長引数内に記述がある変数のみデータを変更しiniファイルに書き込むためにwrite.ini関数に送る
######################################################################
    def main(self,**kwarg):
        if "text_column_no" in kwarg:
            self.text_column_no=kwarg["text_column_no"]

        if "category_column_no" in kwarg:
            self.category_column_no=kwarg["category_column_no"]

        if "label_column_no" in kwarg:
            self.label_column_no=kwarg["label_column_no"]

        if "files" in kwarg:
            self.files=kwarg["files"]

        if "sample" in kwarg:
            self.sample=kwarg["sample"]

        if "count_texts_all" in kwarg:
            self.count_texts_all=kwarg["count_texts_all"]

        if "count_texts_analysis" in kwarg:
            self.count_texts_analysis=kwarg["count_texts_analysis"]

        if "original_data_type" in kwarg:
            self.original_data_type=kwarg["original_data_type"]

        if "model_path" in kwarg:
            self.model_path=kwarg["model_path"]

        if "csv_path" in kwarg:
            self.csv_path=kwarg["csv_path"]

        if "train_test" in kwarg:
            self.train_test=kwarg["train_test"]

        if "nums_of_category" in kwarg:
            self.nums_of_category=kwarg["nums_of_category"]

        if "nums_of_label" in kwarg:
            self.nums_of_label=kwarg["nums_of_label"]

        if "tyo_on" in kwarg:
            self.tyo_on=kwarg["tyo_on"]

        if "han" in kwarg:
            self.han=kwarg["han"]

        if "zen" in kwarg:
            self.zen=kwarg["zen"]

        if "zen_han" in kwarg:
            self.zen_han=kwarg["zen_han"]

        if "basis_word" in kwarg:
            self.basis_word=kwarg["basis_word"]

        if "discrimination" in kwarg:
            self.discrimination=kwarg["discrimination"]

        if "dimensions" in kwarg:
            self.dimensions=kwarg["dimensions"]

        self.write_ini(
        self.filepath, self.project_name,
        text_column_no=self.text_column_no,
        category_column_no=self.category_column_no,
        label_column_no=self.label_column_no,
        files=self.files,
        sample=self.sample,
        count_texts_all=self.count_texts_all,
        count_texts_analysis=self.count_texts_analysis,
        original_data_type=self.original_data_type,
        model_path=self.model_path,
        csv_path=self.csv_path,
        train_test=self.train_test,
        nums_of_category=self.nums_of_category,
        nums_of_label=self.nums_of_label,
        tyo_on=self.tyo_on,
        han=self.han,
        zen=self.zen,
        zen_han=self.zen_han,
        basis_word=self.basis_word,
        discrimination=self.discrimination,
        dimensions=self.dimensions
        )
######################################################################
#可変長引数内に修正事項があればそれを変数にセット
#なければ空の文字列を変数にセット
######################################################################

    def write_ini(self,file_check, project_name,**kwarg):
        config = configparser.ConfigParser()

        pro_na=project_name
        tex_na=kwarg.get("text_column_no", "")  #テキストデータの入力されたカラム番号
        cate_na=kwarg.get("category_column_no", "") #カテゴリーデータの入力されたカラム番号
        labe_na=kwarg.get("label_column_no", "") #ラベルデータの入力されたカラム番号
        files_=kwarg.get("files", "")   #ファイルパス、カテゴリー名、ラベル名からなるタプルのリスト
        sample_=kwarg.get("sample", "") #0:サンプリングしない, 1:サンプリングする
        count_texts_all_=kwarg.get("count_texts_all","")
        count_texts_analysis_=kwarg.get("count_texts_analysis","")  #サンプリングした結果の分析対象数
        original_data_type_=kwarg.get("original_data_type","") #1:モデルあり,　2:テキストデータ,　3:CSV
        model_path_=kwarg.get("model_path","")  #binファイルの保存先
        csv_path_=kwarg.get("csv_path","")  #csvファイルの保存先
        train_test_=kwarg.get("train_test","")  #分類器の適合率を計算した結果
        nums_of_category_=kwarg.get("nums_of_category","")
        nums_of_label_=kwarg.get("nums_of_label","")
        tyo_on_=kwarg.get("tyo_on","")
        han_=kwarg.get("han","")
        zen_=kwarg.get("zen","")
        zen_han_=kwarg.get("zen_han","")
        basis_word_=kwarg.get("basis_word","")
        discrimination_=kwarg.get("discrimination","")  #再分類済み
        dimensions_=kwarg.get("dimensions","")  #次元数

        #print(pro_na, cate_na, labe_na, files_, sample_, count_texts_all_, count_texts_analysis_, original_data_type_, model_path_)

        with open(file_check, "w") as f:
            config.add_section("project")
            config.set("project","project_name", pro_na)
            config.set("project","text_column_no", tex_na)
            config.set("project","category_column_no", cate_na)
            config.set("project","label_column_no", labe_na)
            config.set("project","files", files_)
            config.set("project","sample", sample_)
            config.set("project","count_texts_all", count_texts_all_)
            config.set("project","count_texts_analysis", count_texts_analysis_)
            config.set("project","original_data_type", original_data_type_)
            config.set("project","model_path",model_path_)
            config.set("project","csv_path",csv_path_)
            config.set("project","train_test",train_test_)
            config.set("project","nums_of_category",nums_of_category_)
            config.set("project","nums_of_label",nums_of_label_)
            config.set("project","tyo_on",tyo_on_)
            config.set("project","han",han_)
            config.set("project","zen",zen_)
            config.set("project","zen_han",zen_han_)
            config.set("project","basis_word",basis_word_)
            config.set("project","discrimination",discrimination_)
            config.set("project","dimensions",dimensions_)

            config.write(f)
            f.close


    def ini_check(self,project_name):
        current_directory=os.getcwd()
        file_check=current_directory + ("/") + project_name + (".ini")

        if os.path.exists(file_check):
            return file_check
        else:
            self.write_ini(file_check, project_name)
            return file_check


if __name__=="__main__":
    project_name = "ok"
    han="!#$&()*\+/:;<=>?@¥^_`{|}~･｢｣"
    write_pro_ini(project_name).main(
    #label_column_no=label_column_no
    #original_data_type=original_type
    han=han)
