/*
    dllloader
    (C)Copyright 2000 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "msvcrt.h"


/******************************************************************************
*                                                                             *
*                                                                           *
*                                                                             *
******************************************************************************/
#define EXCEPTION_MAXIMUM_PARAMETERS 15


typedef VOID CONTEXT86,*PCONTEXT86,*LPCONTEXT86;
typedef CONTEXT86 CONTEXT,*PCONTEXT,*LPCONTEXT;
#include "pshpack1.h"
typedef struct __EXCEPTION_RECORD {
	DWORD ExceptionCode;
	DWORD ExceptionFlags;
	struct __EXCEPTION_RECORD *ExceptionRecord;
	LPVOID ExceptionAddress;
	DWORD NumberParameters;
	DWORD ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD,*PEXCEPTION_RECORD,*LPEXCEPTION_RECORD;
struct __EXCEPTION_FRAME;
typedef DWORD (*PEXCEPTION_HANDLER)(PEXCEPTION_RECORD,
			struct __EXCEPTION_FRAME*,PCONTEXT,struct __EXCEPTION_FRAME **);
typedef struct __EXCEPTION_FRAME {
	struct __EXCEPTION_FRAME *Prev;
	PEXCEPTION_HANDLER Handler;
} EXCEPTION_FRAME,*PEXCEPTION_FRAME,*LPEXCEPTION_FRAME;
typedef struct _EXCEPTION_POINTERS {
	PEXCEPTION_RECORD ExceptionRecord;
	PCONTEXT ContextRecord;
} EXCEPTION_POINTERS,*PEXCEPTION_POINTERS,*LPEXCEPTION_POINTERS;
typedef struct _SCOPETABLE {
	DWORD previousTryLevel;
	int (*lpfnFilter)(PEXCEPTION_POINTERS);
	int (*lpfnHandler)(void);
} SCOPETABLE, *PSCOPETABLE;
typedef struct _MSVCRT_EXCEPTION_FRAME {
	EXCEPTION_FRAME *prev;
	void (*handler)(PEXCEPTION_RECORD,PEXCEPTION_FRAME,
					PCONTEXT,PEXCEPTION_RECORD);
	PSCOPETABLE scopetable;
	DWORD trylevel;
	int _ebp;
	PEXCEPTION_POINTERS xpointers;
} MSVCRT_EXCEPTION_FRAME;
#include "poppack.h"


static guint8 msvcrt_EH_prolog[]={
	0x6a,0xff,0x50,0x64,0xa1,0x00,0x00,0x00,
	0x00,0x50,0x64,0x89,0x25,0x00,0x00,0x00,
	0x00,0x8b,0x44,0x24,0x0c,0x89,0x6c,0x24,
	0x0c,0x8d,0x6c,0x24,0x0c,0x50,0xc3};


static void msvcrt_CxxFrameHandler(PEXCEPTION_RECORD rec,
								EXCEPTION_FRAME* frame,PCONTEXT exc_context,
								EXCEPTION_FRAME** dispatch,CONTEXT86 *context)
{
	g_debug("__CxxFrameHandler");
}


static void *msvcrt_dllonexit(void *arg1,void *arg2,void *arg3)
{
	g_debug("__dllonexit");
	return NULL;
}


static int msvcrt_except_handler3(PEXCEPTION_RECORD rec,
			MSVCRT_EXCEPTION_FRAME* frame,PCONTEXT context,void* dispatcher)
{
	g_debug("_except_handler3");
	return 0;
}


static int msvcrt_initterm(void **arg1,void **arg2)
{
	BOOL (*initterm_func)(void);

	g_debug("initterm");
	while (arg1<arg2) {
		if ((initterm_func=(BOOL(*)(void))*arg1))
			initterm_func();
		arg1++;
	}
	return 0;
}


static void *msvcrt_onexit(void *arg1)
{
	g_debug("_onexit");
	return NULL;
}


/******************************************************************************
*                                                                             *
* 黻                                                                        *
*                                                                             *
******************************************************************************/
static int msvcrt_adjust_fdiv=0;


static unsigned int msvcrt_clearfp(void)
{
	g_debug("_clearfp");
	return 0;
}


static LONG msvcrt_ftol(void)
{
	double fl;

	g_debug("_ftol");
	__asm__ __volatile__( "fstpl" " %0;fwait" : "=m" (fl) : );
	return (LONG)fl;
}


/******************************************************************************
*                                                                             *
*                                                                       *
*                                                                             *
******************************************************************************/
static void *msvcrt_malloc(size_t size)
{
	g_debug("malloc");
	return g_malloc(size);
}


static void msvcrt_free(void *memblock)
{
	g_debug("free(%08X)",(guint32)memblock);
	g_free(memblock);
}


static void *msvcrt_new(size_t size)
{
	g_debug("new");
	return msvcrt_malloc(size);
}


static void msvcrt_delete(void *memblock)
{
	g_debug("delete");
	msvcrt_free(memblock);
}


static void *msvcrt_memmove(void *dst,const void *src,size_t n)
{
	g_debug("memmove");
	g_memmove(dst,src,n);
	return dst;
}


/******************************************************************************
*                                                                             *
* ʸ                                                                      *
*                                                                             *
******************************************************************************/
static double msvcrt_atof(const char *string)
{
	g_debug("atof");
	return atof(string);
}


static int msvcrt_isalnum(int c)
{
	g_debug("isalnum");
	return g_ascii_isalnum(c);
}


static char *msvcrt_strchr(const char *string,int c)
{
	g_debug("strchr");
	return g_strchr(string,c);
}


static int msvcrt_strcmpi(const char *string1,const char *string2)
{
	g_debug("_strcmpi");
	return g_strcasecmp(string1,string2);
}


static char *msvcrt_strrchr(const char *string,int c)
{
	g_debug("strrchr");
	return g_strrchr(string,c);
}


static int msvcrt_toupper(int c)
{
	g_debug("toupper");
	return g_ascii_toupper(c);
}

static guint16 *msvcrt_wcscpy(guint16 *string1,const guint16 *string2)
{
	gint i=0;

	g_debug("wcscpy");
	do
		string1[i]=string2[i];
	while (string2[i++]!=0);
	return string1;
}


/******************************************************************************
*                                                                             *
*                                                                         *
*                                                                             *
******************************************************************************/
static int msvcrt_rand(void)
{
	g_debug("rand");
	return rand();
}


static void msvcrt_srand(unsigned int seed)
{
	g_debug("srand");
	return srand(seed);
}


/******************************************************************************
*                                                                             *
* Ͽ                                                                        *
*                                                                             *
******************************************************************************/
static VOID WINAPI UnknownSymbol(VOID)
{
	g_message("unknown symbol in msvcrt called");
}


static SymbolInfo symbol_infos[]={
	{"__CxxFrameHandler",msvcrt_CxxFrameHandler},
	{"__dllonexit",msvcrt_dllonexit},
	{"_EH_prolog",msvcrt_EH_prolog},
	{"_except_handler3",msvcrt_except_handler3},
	{"_initterm",msvcrt_initterm},
	{"_onexit",msvcrt_onexit},

	{"_adjust_fdiv",&msvcrt_adjust_fdiv},
	{"_clearfp",msvcrt_clearfp},
	{"_ftol",msvcrt_ftol},

	{"malloc",msvcrt_malloc},
	{"free",msvcrt_free},
	{"??2@YAPAXI@Z",msvcrt_new},
	{"??3@YAXPAX@Z",msvcrt_delete},
	{"memmove",msvcrt_memmove},

	{"atof",msvcrt_atof},
	{"isalnum",msvcrt_isalnum},
	{"strchr",msvcrt_strchr},
	{"_strcmpi",msvcrt_strcmpi},
	{"strrchr",msvcrt_strrchr},
	{"toupper",msvcrt_toupper},
	{"wcscpy",msvcrt_wcscpy},

	{"rand",msvcrt_rand},
	{"srand",msvcrt_srand},

	{NULL,UnknownSymbol}
};


SymbolInfo *msvcrt_get_export_symbols(void)
{
	return symbol_infos;
}
