/*
    Video maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "jump.h"
#include <gdk/gdkkeysyms.h>
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:ジャンプダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
/* ja:エントリーでリターンが押された */
static void
jump_dialog_activate (GtkWidget *widget,
                      GtkWidget *dialog)
{
  gint value;
  JumpConfig *jmpcfg;

  jmpcfg = g_object_get_data (G_OBJECT (dialog), "user_data");
  if (misc_str_to_val (&value,
                            gtk_entry_get_text (GTK_ENTRY (widget)), 10, FALSE)
            && jmpcfg->frame != value && 0 <= value && value <= jmpcfg->max)
    gtk_dialog_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);
}


/* ja:エントリーが変更された */
static void
jump_dialog_changed (GtkWidget *widget,
                     GtkWidget *dialog)
{
  gint value;

  if (misc_str_to_val (&value,
                        gtk_entry_get_text (GTK_ENTRY (widget)), 10, FALSE))
    {
      gchar *text;
      gint t;
      GtkWidget *label;
      JumpConfig *jmpcfg;

      label = g_object_get_data (G_OBJECT (widget), "user_data");
      jmpcfg = g_object_get_data (G_OBJECT (dialog), "user_data");
      t = (glonglong)value * jmpcfg->scale * 1000 / jmpcfg->rate;
      text = g_strdup_printf ("%02d:%02d:%02d",
                                t / 60000 % 100, t / 1000 % 60, t / 10 % 100);
      gtk_label_set_text (GTK_LABEL (label), text);
      g_free (text);
      gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                jmpcfg->frame != value && 0 <= value && value <= jmpcfg->max);
    }
  else
    {
      gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                                                                        FALSE);
    }
}


/* ja:ESCが押された */
static gboolean
jump_dialog_key_press (GtkWidget   *widget,
                       GdkEventKey *event,
                       gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_dialog_response (GTK_DIALOG (widget), GTK_RESPONSE_NONE);
  return FALSE;
}


/*  ja:ジャンプダイアログ表示
    jmpcfg,ジャンプ構造体
       RET.TRUE:OK,FALSE:Cancel                                             */
gboolean
jump_dialog (JumpConfig *jmpcfg)
{
  gboolean result;
  gchar *text;
  GtkWidget *dialog, *entry, *label, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_dialog_new_with_buttons
                            (_("Jump"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            NULL);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (jump_dialog_key_press), NULL);
  g_object_set_data (G_OBJECT (dialog), "user_data", jmpcfg);
  /* ja:ラベル */
  label = gtk_label_new (NULL);
  /* ja:エントリー */
  entry = gtk_entry_new ();
  g_object_set_data (G_OBJECT (entry), "user_data", label);
  g_signal_connect (G_OBJECT (entry), "changed",
                                    G_CALLBACK (jump_dialog_changed), dialog);
  text = misc_str_from_val (jmpcfg->frame, 10, 0, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry), text);
  g_free (text);
  g_signal_connect (G_OBJECT (entry), "activate",
                                    G_CALLBACK (jump_dialog_activate), dialog);
  gtk_editable_select_region (GTK_EDITABLE (entry), 0, -1);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_dialog_set_response_sensitive (GTK_DIALOG (dialog), GTK_RESPONSE_OK,
                                                                        FALSE);
  gtk_widget_grab_focus (entry);
  gtk_widget_show_all (vbox);

  result = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK;
  if (result)
    misc_str_to_val (&jmpcfg->frame,
                            gtk_entry_get_text (GTK_ENTRY (entry)), 10, FALSE);
  gtk_widget_destroy (dialog);

  return result;
}
