#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "chunk.h"


#ifndef min
#define min(a,b) (((a)<(b))?(a):(b))
#endif


typedef struct tagRECT {
	LONG left;
	LONG top;
	LONG right;
	LONG bottom;
} RECT;
/* AVISTREAMHEADER¤ */
typedef struct tagAVISTREAMHEADER {
	FOURCC fccType;
	FOURCC fccHandler;
	DWORD dwFlags;
	WORD wPriority;
	WORD wLanguage;
	DWORD dwInitialFrames;
	DWORD dwScale;
	DWORD dwRate;
	DWORD dwStart;
	DWORD dwLength;
	DWORD dwSuggestedBufferSize;
	DWORD dwQuality;
	DWORD dwSampleSize;
	RECT cFrame;
} AVISTREAMHEADER;
/* AVIINDEXENTRY¤ */
typedef struct tagAVIINDEXENTRY {
	FOURCC ckid;
	DWORD dwFlags;
	DWORD dwChunkOffset;
	DWORD dwChunkLength;
} AVIINDEXENTRY;
/* BITMAPINFOHEADER¤ */
typedef struct tagBITMAPINFOHEADER {
	DWORD biSize;
	LONG biWidth;
	LONG biHeight;
	WORD biPlanes;
	WORD biBitCount;
	DWORD biCompression;
	DWORD biSizeImage;
	LONG biXPelsPerMeter;
	LONG biYPelsPerMeter;
	DWORD biClrUsed;
	DWORD biClrImportant;
} BITMAPINFOHEADER,*LPBITMAPINFOHEADER;


int main(int argc,char *argv[])
{
	char *test=" .-!(x?Y734&\\Q#$";/* Ťطʤ뤤ʸ */
/*	char *test="$#Q\\&437Y?x(!-. "; 뤤طʤ˰Ťʸ */
	clock_t c;				/*  */
	int i,x,y;				/* 롼ץ */
	int cx;					/* ºݤβʸ */
	int cy;					/* ºݤνĤʸ */
	int frame=0;			/* ߤΥե졼 */
	int s=0;				/* argvΥե̾,ǥåο */
	int width=79;			/* ʸ */
	int height=24;			/* Ĥʸ */
	int line;				/* 饤ΥХȿ */
	long adr;				/* ԥΰ */
	long offset;			/* moviեLIST󥯤Υեå */
	AVISTREAMHEADER ash;	/* AVISTREAMHEADER¤ */
	AVIINDEXENTRY aie;		/* AVIINDEXENTRY¤ */
	BITMAPINFOHEADER bmih;	/* BITMAPINFOHEADER¤ */
	BYTE *p;				/* ԥǡɤ߹Хåե */
	CHUNK *ck;				/* 󥯥ݥ */
	DWORD size;				/* ǥå󥯤ΥХȿ */
	FILE *fp1;				/* ǥåɤिΥեݥ */
	FILE *fp2;				/* ᡼ǡɤिΥեݥ */
	FOURCC type;			/* strh󥯤Υ󥯥 */

	for (i=1;i<argc;i++)
		if ((argv[i])[0]!='-')
			/* ץǤϤʤե̾ */
			s=i;
		else
			/* ץ */
			switch (toupper((argv[i])[1])) {
				case 'H':/* Ĥʸ */
					height=atoi(argv[i]+2);
					break;
				case 'W':/* ʸ */
					width=atoi(argv[i]+2);
			}
	if (s==0) {
		/* ˥ե̾ʤȤ */
		printf(	"Usage: %s [-h<x>] [-w<x>] <avifile>\n"
				"-h<x>: Display Height\n"
				"-w<x>: Display Width\n",argv[0]);
		return 0;
	}

	/* ե򳫤 */
	if ((fp1=fopen(argv[s],"rb"))==NULL || (fp2=fopen(argv[s],"rb"))==NULL) {
		printf("%s can not open.\n",argv[s]);
		return -1;
	}

	/* ϤΥ󥯤BITMAPINFOHEADER */

	/* եݥ󥿤󥯥ݥ󥿤 */
	if ((ck=chunkopen(fp1))==NULL) {
		printf("chunk open error.\n");
		return -1;
	}
	/* RIFF󥯤 */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* եबhdrlLIST󥯤õ */
	while (chunkform(fp1)!=make4cc('h','d','r','l'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> LIST\'hdrl\' chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* եबstrlLIST󥯤õ */
	while (chunkform(fp1)!=make4cc('s','t','r','l'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' "
													"chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' "
														"chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* strh󥯤õ(AVIStreamHeader) */
	while (chunkid(fp1)!=make4cc('s','t','r','h'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' -> strh "
													"chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* strh󥯤(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strh) */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' -> strh "
														"chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	if (fread(&ash,sizeof(AVISTREAMHEADER),1,fp1)!=1) {
		printf("AVISTREAMHEADER read error.\n");
		chunkfree(ck);
		return -1;
	}
	if (ash.fccType!=make4cc('v','i','d','s')) {
		printf("first stream is not video.\n");
		chunkfree(ck);
		return -1;
	}
	if (ash.fccHandler!=make4cc('D','I','B',' ') && ash.fccHandler!=0) {
		printf("first stream is compressed.\n");
		chunkfree(ck);
		return -1;
	}
	/* strh󥯤Ф(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
	if (chunkout(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' <- strh "
														"chunk out error.\n");
		chunkfree(ck);
		return -1;
	}
	/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
	if (chunkout(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' <- LIST\'strl\' "
														"chunk out error.\n");
		chunkfree(ck);
		return -1;
	}
	/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' "
														"chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* strf󥯤õ(BITMAPINFOHEADER) */
	while (chunkid(fp1)!=make4cc('s','t','r','f'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' -> strf "
													"chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* strf󥯤(BITMAPINFOHEADER)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strf) */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> LIST\'hdrl\' -> LIST\'strl\' -> strf "
														"chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* BITMAPINFOHEADERɤ߹ */
	if (fread(&bmih,sizeof(BITMAPINFOHEADER),1,fp1)!=1) {
		printf("BITMAPINFOHEADER can not read.\n");
		chunkfree(ck);
		return -1;
	}
	/* 󥯥ݥ󥿤 */
	if (chunkfree(ck)!=0)
		printf("chunk free error.\n");

	/* ࡼӡ󥯤ذư */

	/* եݥ󥿤󥯥ݥ󥿤 */
	if ((ck=chunkopen(fp1))==NULL) {
		printf("chunk open error.\n");
		return -1;
	}
	/* RIFF󥯤 */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* movi󥯤õ */
	while (chunkform(fp1)!=make4cc('m','o','v','i'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> LIST\'movi\' chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* եΥեåȤ */
	if ((offset=ftell(fp1))==-1) {
		printf("file pointer error.\n");
		chunkfree(ck);
		return -1;
	}
	offset+=sizeof(FOURCC)+sizeof(DWORD);/* moviΥեå */
	/* 󥯥ݥ󥿤 */
	if (chunkfree(ck)!=0)
		printf("chunk free error.\n");

	/* ǥå󥯤ذư */

	/* եݥ󥿤󥯥ݥ󥿤 */
	if ((ck=chunkopen(fp1))==NULL) {
		printf("chunk open error.\n");
		return -1;
	}
	/* RIFF󥯤 */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' chunk in error.\n");
		chunkfree(ck);
		return -1;
	}
	/* idx1󥯤õ */
	while (chunkid(fp1)!=make4cc('i','d','x','1'))
		if (chunknext(fp1,ck)!=0) {
			printf("RIFF\'AVI \' -> idx1 chunk search error.\n");
			chunkfree(ck);
			return -1;
		}
	/* idx1󥯤Υ */
	if ((size=chunksize(fp1))==(DWORD)-1) {
		printf("idx1 chunk size error.\n");
		chunkfree(ck);
		return -1;
	}
	/* idx1󥯤(RIFF'AVI ' -> idx1) */
	if (chunkin(fp1,ck)!=0) {
		printf("RIFF\'AVI \' -> idx1 chunk in error.\n");
		chunkfree(ck);
		return -1;
	}

	if (bmih.biBitCount!=24) {
		/* 24ӥåȤΥӥåȥޥåפǤʤȤ */
		printf("%s is not 24 bit color.\n",argv[s]);
		chunkfree(ck);
		return -1;
	}

	/* ԥǡɤߤݤ */
	line=((bmih.biWidth*bmih.biBitCount+31)&~31)/8;
	if ((p=malloc(line*bmih.biHeight*sizeof(BYTE)))==NULL) {
		printf("memory alloc error.\n");
		chunkfree(ck);
		return -1;
	}
	/* ե졼ɽ롼 */
	s=size/sizeof(AVIINDEXENTRY);
	/* ĲΨݻƺʸ */
	cx=min(bmih.biWidth*height*2/bmih.biHeight,width);
	cy=min(bmih.biHeight*width/bmih.biWidth/2,height);
	c=clock();
	for (i=0;i<s;i++) {
		if (fread(&aie,sizeof(AVIINDEXENTRY),1,fp1)!=1) {
			printf("AVIINDEXENTRY can not read.\n");
			break;
		}
		if (aie.ckid==make4cc('0','0','d','b')
									&& aie.dwChunkLength==line*bmih.biHeight) {
			/* 0ȥ꡼󰵽̤Υե졼ΤȤ */
			frame++;/* ߤΥե졼䤹 */
			if ((double)frame*CLOCKS_PER_SEC*ash.dwScale/ash.dwRate<=clock()-c)
				continue;/* ե졼ƤȤˤɽ򥹥å */
			/* ԥǡإ */
			if (fseek(fp2,offset+aie.dwChunkOffset
								+sizeof(DWORD)+sizeof(FOURCC),SEEK_SET)!=0) {
				printf("file seek error.\n");
				break;
			}
			/* ԥǡɤ߹ */
			if (fread(p,sizeof(BYTE),aie.dwChunkLength,fp2)
														!=aie.dwChunkLength) {
				printf("pixel data can not read.\n");
				break;
			}
			/* printf("\x1b[2J"); MS-DOSǤϤΥץɤǲ̤õ */
			for (y=cy-1;y>=0;y--) {
				for (x=0;x<cx;x++) {
					adr=bmih.biHeight*y/cy*line+bmih.biWidth*x/cx*3;
					putchar(test[(p[adr]*29L+p[adr+1]*150L+p[adr+2]*77L)
																	/4096]);
				}
				putchar('\n');
			}
			for (y=cy;y<height;y++)
				putchar('\n');
			/* ɽᤤȤˤϥ롼פ */
			while (clock()-c<
						(double)frame*CLOCKS_PER_SEC*ash.dwScale/ash.dwRate);
		}
	}
	/* 󥯥ݥ󥿤 */
	if (chunkfree(ck)!=0)
		printf("chunk free error.\n");
	free(p);
	return 0;
}
