/*
    avicore
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __AVI_EXTRA_H__
#define __AVI_EXTRA_H__


#include "avicore.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define AVI_TYPE_EXTRA            (avi_extra_get_type ())
#define AVI_EXTRA(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), AVI_TYPE_EXTRA, AviExtra))
#define AVI_EXTRA_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), AVI_TYPE_EXTRA, AviExtraClass))
#define AVI_IS_EXTRA(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AVI_TYPE_EXTRA))
#define AVI_IS_EXTRA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AVI_TYPE_EXTRA))
#define AVI_EXTRA_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), AVI_TYPE_EXTRA, AviExtraClass))


typedef struct _AviExtra      AviExtra;
typedef struct _AviExtraClass AviExtraClass;

struct _AviExtra
{
  /*< private >*/
  GtkVBox parent_instance;

  /*< public >*/
  AviEdit **avi_edit;   /* ja:AVI編集構造体 */

  /*< private >*/
  gint video, audio;    /* ja:ビデオ/オーディオストリームの数 */
  GtkWidget *frame;     /* ja:ビットマップの範囲 */
  GtkWidget *notebook;  /* ja:ストリーム */
  GtkWidget *spin0;     /* ja:ビットマップの開始位置 */
  GtkWidget *spin1;     /* ja:ビットマップの終了位置 */
  GtkWidget *radio0;    /* en:AVI */
  GtkWidget *radio1;    /* en:GtkShot Raw */
  GtkWidget *radio2;    /* ja:ビットマップ */
  GtkWidget *radio3;    /* en:WAVE */
  GtkWidget *radio4;    /* ja:シナリオオブジェクト */
};

struct _AviExtraClass
{
  GtkVBoxClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
avi_extra_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
avi_extra_new (void);


/*  ja:AVI編集ハンドルを取得する
    extra,ウィジェット
      RET,AVI編集ハンドル,NULL:設定なし                                     */
AviEdit **
avi_extra_get_handle (AviExtra *extra);


/*  ja:AVI編集ハンドルを設定する
       extra,ウィジェット
    avi_edit,AVI編集ハンドル,NULL:設定なし                                  */
void
avi_extra_set_handle (AviExtra  *extra,
                      AviEdit  **avi_edit);


/*  ja:保存用のオプションを取得する
    extra,ウィジェット
      RET,オプション,NULL:エラー                                            */
AviSave *
avi_extra_get_option (AviExtra *extra);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AVI_EXTRA_H__ */
