/*
    Video maid
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "file.h"
#include "merge.h"
#include "size.h"
#include "misc/fileio.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:連結ダイアログ関数群                                                     *
*                                                                             *
******************************************************************************/
typedef struct _MergeDialog
{
  GtkWidget *dialog;
  GtkWidget *tview_src;
  GtkWidget *tview_dst;
  GtkWidget *button_add;
  GtkWidget *button_remove;
  GtkWidget *button_all;
  GtkWidget *button_clear;
} MergeDialog;


enum
{
  TARGET_GTK_TREE_MODEL_ROW
};


/* ja:リストボックスへ挿入 */
static void
merge_dialog_row_inserted (GtkTreeModel *model,
                           GtkTreePath  *arg1,
                           GtkTreeIter  *arg2,
                           MergeDialog  *mrgdlg)
{
  gtk_widget_set_sensitive (mrgdlg->button_clear, TRUE);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (mrgdlg->dialog),
                                                        GTK_RESPONSE_OK, TRUE);
}


/* ja:リストボックスから削除 */
static void
merge_dialog_row_deleted (GtkTreeModel *model,
                          GtkTreePath  *arg1,
                          MergeDialog  *mrgdlg)
{
  if (gtk_tree_model_iter_n_children (gtk_tree_view_get_model
                            (GTK_TREE_VIEW (mrgdlg->tview_dst)), NULL) <= 0)
    {
      gtk_widget_set_sensitive (mrgdlg->button_clear, FALSE);
      gtk_dialog_set_response_sensitive (GTK_DIALOG (mrgdlg->dialog),
                                                    GTK_RESPONSE_OK, FALSE);
    }
}


/* ja:リストボックスの選択 */
static void
merge_dialog_changed_src (GtkTreeSelection *select,
                          MergeDialog      *mrgdlg)
{
#if GTK_CHECK_VERSION(2,2,0)
  gtk_widget_set_sensitive (mrgdlg->button_add,
                        gtk_tree_selection_count_selected_rows (select) > 0);
#else /* not GTK_CHECK_VERSION(2,2,0) */
  gboolean selected = FALSE;
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  model = gtk_tree_view_get_model (gtk_tree_selection_get_tree_view (select));
  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
    if (gtk_tree_selection_iter_is_selected (select, &iter))
      {
        selected = TRUE;
        break;
      }
  gtk_widget_set_sensitive (mrgdlg->button_add, selected);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
}


/* ja:リストボックスの選択 */
static void
merge_dialog_changed_dst (GtkTreeSelection *select,
                          MergeDialog      *mrgdlg)
{
#if GTK_CHECK_VERSION(2,2,0)
  gtk_widget_set_sensitive (mrgdlg->button_remove,
                        gtk_tree_selection_count_selected_rows (select) > 0);
#else /* not GTK_CHECK_VERSION(2,2,0) */
  gboolean selected = FALSE;
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  model = gtk_tree_view_get_model (gtk_tree_selection_get_tree_view (select));
  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
    if (gtk_tree_selection_iter_is_selected (select, &iter))
      {
        selected = TRUE;
        break;
      }
  gtk_widget_set_sensitive (mrgdlg->button_remove, selected);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
}


/* ja:追加 */
static void
merge_dialog_clicked_add (GtkWidget   *widget,
                          MergeDialog *mrgdlg)
{
  gint i;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreeSelection *select0, *select1;

  select0 = gtk_tree_view_get_selection (GTK_TREE_VIEW (mrgdlg->tview_src));
  select1 = gtk_tree_view_get_selection (GTK_TREE_VIEW (mrgdlg->tview_dst));
  model = gtk_tree_view_get_model (GTK_TREE_VIEW (mrgdlg->tview_src));
  store = GTK_LIST_STORE (gtk_tree_view_get_model
                                        (GTK_TREE_VIEW (mrgdlg->tview_dst)));
  gtk_tree_selection_unselect_all (select1);
  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
    if (gtk_tree_selection_iter_is_selected (select0, &iter))
      {
        gchar *name;
        VmaidWindow *vmaid;
#if GTK_CHECK_VERSION(2,8,0)
        GdkPixbuf *pixbuf;
#endif /* GTK_CHECK_VERSION(2,8,0) */

        gtk_tree_model_get (model, &iter, 0, &vmaid,
                                          1, &name,
#if GTK_CHECK_VERSION(2,8,0)
                                          2, &pixbuf,
#endif /* GTK_CHECK_VERSION(2,8,0) */
                                          -1);
        gtk_list_store_append (store, &iter);
        gtk_list_store_set (store, &iter, 0, vmaid,
                                          1, name,
#if GTK_CHECK_VERSION(2,8,0)
                                          2, pixbuf,
#endif /* GTK_CHECK_VERSION(2,8,0) */
                                          -1);
        g_free (name);
#if GTK_CHECK_VERSION(2,8,0)
        g_object_unref (pixbuf);
#endif /* GTK_CHECK_VERSION(2,8,0) */
        gtk_tree_selection_select_iter (select1, &iter);
      }
}


/* ja:削除 */
static void
merge_dialog_clicked_remove (GtkWidget   *widget,
                             MergeDialog *mrgdlg)
{
  gint i;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkTreeSelection *select;

  store = GTK_LIST_STORE (gtk_tree_view_get_model
                                        (GTK_TREE_VIEW (mrgdlg->tview_dst)));
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (mrgdlg->tview_dst));
  for (i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (store), NULL) - 1;
                                                                i >= 0; i--)
    if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i)
                        && gtk_tree_selection_iter_is_selected (select, &iter))
      gtk_list_store_remove (store, &iter);
}


/* ja:すべて選択 */
static void
merge_dialog_clicked_all (GtkWidget   *widget,
                          MergeDialog *mrgdlg)
{
  gint i;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkTreeModel *model;

  model = gtk_tree_view_get_model (GTK_TREE_VIEW (mrgdlg->tview_src));
  store = GTK_LIST_STORE (gtk_tree_view_get_model
                                        (GTK_TREE_VIEW (mrgdlg->tview_dst)));
  gtk_list_store_clear (store);
  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
    {
      gchar *name;
      VmaidWindow *vmaid;
#if GTK_CHECK_VERSION(2,8,0)
      GdkPixbuf *pixbuf;
#endif /* GTK_CHECK_VERSION(2,8,0) */

      gtk_tree_model_get (model, &iter, 0, &vmaid,
                                        1, &name,
#if GTK_CHECK_VERSION(2,8,0)
                                        2, &pixbuf,
#endif /* GTK_CHECK_VERSION(2,8,0) */
                                        -1);
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, vmaid,
                                        1, name,
#if GTK_CHECK_VERSION(2,8,0)
                                        2, pixbuf,
#endif /* GTK_CHECK_VERSION(2,8,0) */
                                        -1);
      g_free (name);
#if GTK_CHECK_VERSION(2,8,0)
      g_object_unref (pixbuf);
#endif /* GTK_CHECK_VERSION(2,8,0) */
    }
  gtk_tree_selection_select_all (gtk_tree_view_get_selection
                                        (GTK_TREE_VIEW (mrgdlg->tview_dst)));
}


/* ja:クリア */
static void
merge_dialog_clicked_clear (GtkWidget   *widget,
                            MergeDialog *mrgdlg)
{
  gtk_list_store_clear (GTK_LIST_STORE (gtk_tree_view_get_model
                                        (GTK_TREE_VIEW (mrgdlg->tview_dst))));
}


/*  ja:連結ダイアログ表示                                                   */
void
merge_dialog (void)
{
  gint i, pages;
  GtkCellRenderer *renderer;
  GtkListStore *store;
  GtkTreeSelection *select;
  GtkTreeViewColumn *column;
  GtkWidget *scroll0, *scroll1, *hbox, *vbox;
  GtkTargetEntry dnd_entries[1] = {{"GTK_TREE_MODEL_ROW",
                            GTK_TARGET_SAME_APP, TARGET_GTK_TREE_MODEL_ROW}};
  MergeDialog mrgdlg;

  /* ja:メインウインドウ */
  mrgdlg.dialog = gtk_dialog_new_with_buttons
                            (_("Merge"),
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_signal_connect (G_OBJECT (mrgdlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:ボタン */
  mrgdlg.button_add = gtk_button_new_from_stock (GTK_STOCK_ADD);
  mrgdlg.button_remove = gtk_button_new_from_stock (GTK_STOCK_REMOVE);
#if GTK_CHECK_VERSION(2,10,0)
  mrgdlg.button_all = gtk_button_new_from_stock (GTK_STOCK_SELECT_ALL);
#else /* not GTK_CHECK_VERSION(2,10,0) */
  mrgdlg.button_all = gtk_button_new_with_mnemonic (_("_All"));
#endif /* not GTK_CHECK_VERSION(2,10,0) */
  mrgdlg.button_clear = gtk_button_new_from_stock (GTK_STOCK_CLEAR);
  g_signal_connect (G_OBJECT (mrgdlg.button_add), "clicked",
                            G_CALLBACK (merge_dialog_clicked_add), &mrgdlg);
  g_signal_connect (G_OBJECT (mrgdlg.button_remove), "clicked",
                            G_CALLBACK (merge_dialog_clicked_remove), &mrgdlg);
  g_signal_connect (G_OBJECT (mrgdlg.button_all), "clicked",
                            G_CALLBACK (merge_dialog_clicked_all), &mrgdlg);
  g_signal_connect (G_OBJECT (mrgdlg.button_clear), "clicked",
                            G_CALLBACK (merge_dialog_clicked_clear), &mrgdlg);
  /* ja:リストボックス */
#if GTK_CHECK_VERSION(2,8,0)
  store = gtk_list_store_new (3, G_TYPE_POINTER,
                                 G_TYPE_STRING,
                                 GDK_TYPE_PIXBUF);
#else /* not GTK_CHECK_VERSION(2,8,0) */
  store = gtk_list_store_new (2, G_TYPE_POINTER, G_TYPE_STRING);
#endif /* not GTK_CHECK_VERSION(2,8,0) */
  pages = orz_mdi_get_n_pages (ORZ_MDI (mdi));
  for (i = 0; i < pages; i++)
    {
      GtkTreeIter iter;
#if GTK_CHECK_VERSION(2,8,0)
      GdkPixbuf *pixbuf;
#endif /* GTK_CHECK_VERSION(2,8,0) */

#if GTK_CHECK_VERSION(2,8,0)
      pixbuf = fileio_extract_icon (orz_mdi_get_file (ORZ_MDI (mdi), i),
                                    FILEIO_ICON_SIZE_SMALL);
#endif /* GTK_CHECK_VERSION(2,8,0) */
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 
                                0, orz_mdi_get_data (ORZ_MDI (mdi), i),
                                1, orz_mdi_get_display_name (ORZ_MDI (mdi), i),
#if GTK_CHECK_VERSION(2,8,0)
                                2, pixbuf,
#endif /* GTK_CHECK_VERSION(2,8,0) */
                                -1);
#if GTK_CHECK_VERSION(2,8,0)
      g_object_unref (pixbuf);
#endif /* GTK_CHECK_VERSION(2,8,0) */
    }
  mrgdlg.tview_src = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  column = gtk_tree_view_column_new ();
  gtk_tree_view_column_set_title (column, _("Merge Source"));
  gtk_tree_view_append_column (GTK_TREE_VIEW (mrgdlg.tview_src), column);
#if GTK_CHECK_VERSION(2,8,0)
  renderer = gtk_cell_renderer_pixbuf_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);
  gtk_tree_view_column_set_attributes (column, renderer, "pixbuf", 2, NULL);
#endif /* GTK_CHECK_VERSION(2,8,0) */
  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start (column, renderer, TRUE);
  gtk_tree_view_column_set_attributes (column, renderer, "text", 1, NULL);
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (mrgdlg.tview_src));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_MULTIPLE);
  g_signal_connect (G_OBJECT (select), "changed",
                            G_CALLBACK (merge_dialog_changed_src), &mrgdlg);
  /* ja:リストボックス */
#if GTK_CHECK_VERSION(2,8,0)
  store = gtk_list_store_new (3, G_TYPE_POINTER,
                                 G_TYPE_STRING,
                                 GDK_TYPE_PIXBUF);
#else /* not GTK_CHECK_VERSION(2,8,0) */
  store = gtk_list_store_new (2, G_TYPE_POINTER, G_TYPE_STRING);
#endif /* not GTK_CHECK_VERSION(2,8,0) */
  g_signal_connect (G_OBJECT (store), "row-inserted",
                            G_CALLBACK (merge_dialog_row_inserted), &mrgdlg);
  g_signal_connect (G_OBJECT (store), "row-deleted",
                            G_CALLBACK (merge_dialog_row_deleted), &mrgdlg);
  mrgdlg.tview_dst = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  column = gtk_tree_view_column_new ();
  gtk_tree_view_column_set_title (column, _("Merge Destination"));
  gtk_tree_view_append_column (GTK_TREE_VIEW (mrgdlg.tview_dst), column);
#if GTK_CHECK_VERSION(2,8,0)
  renderer = gtk_cell_renderer_pixbuf_new ();
  gtk_tree_view_column_pack_start (column, renderer, FALSE);
  gtk_tree_view_column_set_attributes (column, renderer, "pixbuf", 2, NULL);
#endif /* GTK_CHECK_VERSION(2,8,0) */
  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_column_pack_start (column, renderer, TRUE);
  gtk_tree_view_column_set_attributes (column, renderer, "text", 1, NULL);
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (mrgdlg.tview_dst));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_MULTIPLE);
  g_signal_connect (G_OBJECT (select), "changed",
                            G_CALLBACK (merge_dialog_changed_dst), &mrgdlg);
  /* en:Drag & Drop */
  gtk_tree_view_enable_model_drag_dest (GTK_TREE_VIEW (mrgdlg.tview_dst),
                                            dnd_entries, 1, GDK_ACTION_MOVE);
  gtk_tree_view_enable_model_drag_source (GTK_TREE_VIEW (mrgdlg.tview_dst),
                            GDK_BUTTON1_MASK, dnd_entries, 1, GDK_ACTION_MOVE);
  /* ja:スクロールウインドウ */
  scroll0 = gtk_scrolled_window_new (NULL, NULL);
  scroll1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scroll0), mrgdlg.tview_src);
  gtk_container_add (GTK_CONTAINER (scroll1), mrgdlg.tview_dst);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll0),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll1),
                                    GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  /* ja:フレームとボックス */
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), SPACING);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), mrgdlg.button_add, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mrgdlg.button_remove, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mrgdlg.button_all, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mrgdlg.button_clear, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), scroll0, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), scroll1, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (mrgdlg.dialog)->vbox), hbox);

  /* ja:表示 */
  gtk_widget_set_sensitive (mrgdlg.button_add, FALSE);
  gtk_widget_set_sensitive (mrgdlg.button_remove, FALSE);
  gtk_widget_set_sensitive (mrgdlg.button_clear, FALSE);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (mrgdlg.dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  gtk_widget_show_all (hbox);

  if (gtk_dialog_run (GTK_DIALOG (mrgdlg.dialog)) == GTK_RESPONSE_OK)
    {
      gint count;
      GtkTreeIter iter;
      AviEdit *avi_edit[2];
      VmaidWindow *vmaid;

      g_memset (avi_edit, 0, sizeof (AviEdit *) * 2);
      count = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (store), NULL);
      for (i = 0; i < count; i++)
        if (gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store),
                                                            &iter, NULL, i))
          {
            gint j;

            gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, 0, &vmaid, -1);
            for (j = 0; j < 2; j++)
              if (vmaid->avi_edit[j])
                {
                  if (avi_edit[j])
                    {
                      AviEdit *avi_edit_tmp;

                      avi_edit_tmp = avi_edit_dup (vmaid->avi_edit[j]);
                      if (!avi_edit_paste (avi_edit[j],
                                avi_edit_length (avi_edit[j]), avi_edit_tmp))
                        {
                          GtkWidget *dialog;

                          dialog = gtk_message_dialog_new
                            (GTK_WINDOW (mrgdlg.dialog),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_MESSAGE_WARNING, GTK_BUTTONS_OK,
                            _("AVI Paste Error"));
                          g_signal_connect (G_OBJECT (dialog),
                                    "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
                          gtk_dialog_run (GTK_DIALOG (dialog));
                          gtk_widget_destroy (dialog);
                          for (i = 0; i < 2; i++)
                            {
                              avi_edit_close (avi_edit[i]);
                              avi_edit[i] = NULL;
                            }
                          avi_edit_close (avi_edit_tmp);
                          goto loop;
                        }
                    }
                  else
                    {
                      avi_edit[j] = avi_edit_dup (vmaid->avi_edit[j]);
                    }
                }
          }
      vmaid = g_malloc0 (sizeof (VmaidWindow));
      g_memmove (vmaid->avi_edit, avi_edit, sizeof (AviEdit *) * 2);
      vmaid->selfrm = default_selfrm;
      vmaid->select.stream = -1;
      vmaid->select.frame = -1;
      if (vmaid->avi_edit[0])
        {
          size_set_scale (default_view, &vmaid->width, &vmaid->height,
                                    avi_edit_get_width (vmaid->avi_edit[0]),
                                    avi_edit_get_height (vmaid->avi_edit[0]));
          vmaid->rate = avi_edit_get_rate (vmaid->avi_edit[0]);
          vmaid->scale = avi_edit_get_scale (vmaid->avi_edit[0]);
        }
      else
        {
          size_set_scale (default_view, &vmaid->width, &vmaid->height, -1, -1);
          vmaid->rate = default_rate;
          vmaid->scale = 1;
          if (vmaid->avi_edit[1])
            vmaid->cursor.stream = 1;
        }
      file_open_window (vmaid, NULL);
    }
  loop:
  gtk_widget_destroy (mrgdlg.dialog);
}
