/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.util.ArrayList;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class Word
extends PointerTarget {
    private static final long serialVersionUID = 8591237840924027785L;
    private Synset _synset;
    private int _index;
    private String _lemma;
    private String senseKey;
    private int usageTag = 0;
    private boolean keysLoaded = false;
    private boolean usageLoaded = false;
    private transient String _cachedToString = null;

    public Word(String lemma, String senseKey, int usageCnt) {
        this._lemma = lemma;
        this.setSenseKey(senseKey);
        this.setUsageCount(usageCnt);
    }

    public Word(Synset synset, int index, String lemma) {
        this._synset = synset;
        this._index = index;
        this._lemma = lemma;
    }

    public Word(Synset synset, int index, String lemma, String senseKey, int usageCnt) {
        this._synset = synset;
        this._index = index;
        this._lemma = lemma;
        this.setSenseKey(senseKey);
        this.setUsageCount(usageCnt);
    }

    public boolean equals(Object object) {
        return object instanceof Word && ((Word)object).getSynset().equals(this.getSynset()) && ((Word)object).getIndex() == this.getIndex();
    }

    public int hashCode() {
        return this.getSynset().hashCode() ^ this.getIndex();
    }

    public String toString() {
        if (this._cachedToString == null) {
            Object[] params = new Object[]{this.getPOS(), this.getLemma(), this.getSynset(), new Integer(this.getIndex())};
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_005", params);
        }
        return this._cachedToString;
    }

    public Synset getSynset() {
        return this._synset;
    }

    public POS getPOS() {
        return this._synset.getPOS();
    }

    public int getIndex() {
        return this._index;
    }

    public String getLemma() {
        return this._lemma;
    }

    public void setSenseKey(String sk) {
        this.keysLoaded = true;
        this.senseKey = sk;
    }

    public String getSenseKey() {
        if (!this.keysLoaded) {
            this.senseKey = Dictionary.getInstance().getSenseKey(this.getSynset().getOffset(), this.getLemma());
            this.keysLoaded = true;
        }
        return this.senseKey;
    }

    public Pointer[] getPointers() {
        Pointer[] source = this.getSynset().getPointers();
        ArrayList<Pointer> list = new ArrayList<Pointer>(source.length);
        int i = 0;
        while (i < source.length) {
            Pointer pointer = source[i];
            if (this.equals(pointer.getSource())) {
                list.add(pointer);
            }
            ++i;
        }
        return list.toArray(new Pointer[list.size()]);
    }

    public int getUsageCount() {
        if (!this.usageLoaded) {
            this.usageTag = Dictionary.getInstance().getUsageCount(this.getSynset().getOffset(), this.getLemma());
            this.usageLoaded = true;
        }
        return this.usageTag;
    }

    public void setUsageCount(int usageTag) {
        this.usageTag = usageTag;
        this.usageLoaded = true;
    }
}

