/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import org.tonouchi.vocable.gui.MakeListDialog;
import org.tonouchi.vocable.gui.models.VocablerTreeModel;
import org.tonouchi.vocable.gui.models.VocabularTableModel;
import org.tonouchi.vocable.gui.models.tree.VocablerListsNode;
import org.tonouchi.vocable.gui.models.tree.WordListNode;
import org.tonouchi.vocabulardb.DBService;
import org.tonouchi.vocabulardb.WordList;
import org.tonouchi.vocabularpublisher.PDFExporter;

public class VocabularFrame
extends JFrame {
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JTree jTree1;

    public VocabularFrame() {
        this.initComponents();
        List lists = DBService.getDBService().getWordLists();
        for (WordList list : lists) {
            VocablerListsNode listsNode = ((VocablerTreeModel)this.jTree1.getModel()).getListsNode();
            WordListNode node = new WordListNode(list, listsNode);
            listsNode.add(node);
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem1.setText("\u65b0\u898f\u30ea\u30b9\u30c8\u306e\u4f5c\u6210");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem7.setText("\u3053\u306e\u30ea\u30b9\u30c8\u3092PDF\u306b\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem7);
        this.jMenuItem2.setText("\u3053\u306e\u30ea\u30b9\u30c8\u3092\u524a\u9664");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu2.add(this.jMenuItem2);
        this.setDefaultCloseOperation(3);
        this.jTree1.setModel(new VocablerTreeModel());
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                VocabularFrame.this.jTree1MouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTable1.setModel(new VocabularTableModel());
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jMenu1.setText("\u30d5\u30a1\u30a4\u30eb");
        this.jMenuItem6.setText("\u7d42\u4e86");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VocabularFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 721, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 399, Short.MAX_VALUE));
        this.pack();
    }

    private void jTree1MouseReleased(MouseEvent evt) {
        final MouseEvent _evt = evt;
        VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object obj;
                if (SwingUtilities.isRightMouseButton(_evt)) {
                    obj = VocabularFrame.this.jTree1.getLastSelectedPathComponent();
                    if (obj instanceof VocablerListsNode) {
                        VocabularFrame.this.jPopupMenu1.show(VocabularFrame.this.jTree1, _evt.getX(), _evt.getY());
                    } else if (obj instanceof WordListNode) {
                        VocabularFrame.this.jPopupMenu2.show(VocabularFrame.this.jTree1, _evt.getX(), _evt.getY());
                    }
                }
                if (SwingUtilities.isLeftMouseButton(_evt)) {
                    obj = VocabularFrame.this.jTree1.getLastSelectedPathComponent();
                    if (obj instanceof WordListNode) {
                        ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData(((WordListNode)obj).getWordList());
                    } else {
                        ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData();
                    }
                }
            }
        });
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MakeListDialog((Frame)thisFrame, true).setVisible(true);
            }
        });
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        final VocabularFrame thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = new JFileChooser();
                WordList list = ((WordListNode)VocabularFrame.this.jTree1.getLastSelectedPathComponent()).getWordList();
                List cards = DBService.getDBService().getCards(list);
                switch (chooser.showSaveDialog(thisFrame)) {
                    case 0: {
                        File fileToBesaved = chooser.getSelectedFile();
                        if (fileToBesaved.exists()) {
                            switch (JOptionPane.showConfirmDialog(chooser, "\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 2)) {
                                case 2: {
                                    return;
                                }
                            }
                        }
                        new PDFExporter().export(fileToBesaved, cards);
                    }
                }
            }
        });
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        switch (JOptionPane.showConfirmDialog(this, "\u524a\u9664\u3057\u3066\u3044\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 2)) {
            case 2: {
                return;
            }
        }
        WordListNode listNode = (WordListNode)this.jTree1.getLastSelectedPathComponent();
        ((VocablerTreeModel)this.jTree1.getModel()).getListsNode().remove(listNode);
        WordList list = listNode.getWordList();
        DBService.getDBService().deleteAList(list);
        this.initializePositions();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VocabularFrame().setVisible(true);
            }
        });
    }

    public void addANewLeaf(final WordList newList) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VocablerListsNode listsNode = ((VocablerTreeModel)VocabularFrame.this.jTree1.getModel()).getListsNode();
                WordListNode newNode = new WordListNode(newList, listsNode);
                listsNode.add(newNode);
                ((DefaultTreeModel)VocabularFrame.this.jTree1.getModel()).reload();
            }
        });
    }

    public void initializePositions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VocabularFrame.this.jTree1.setSelectionRow(0);
                ((VocabularTableModel)VocabularFrame.this.jTable1.getModel()).updateTableData();
                ((DefaultTreeModel)VocabularFrame.this.jTree1.getModel()).reload();
            }
        });
    }
}

