/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabularpublisher;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.tonouchi.vocabulardb.WordCard;

public class XMLImporter {
    public List<WordCard> importXML(File file) {
        ArrayList<WordCard> cards = new ArrayList<WordCard>();
        try {
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(new FileInputStream(file));
            XMLEventReader eventReader = XMLInputFactory.newInstance().createFilteredReader(reader, new EventFilter(){

                @Override
                public boolean accept(XMLEvent event) {
                    return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("word");
                }
            });
            QName word = new QName("word");
            QName pos = new QName("pos");
            QName japanese = new QName("japanese");
            QName english = new QName("english");
            QName example = new QName("example");
            while (eventReader.hasNext()) {
                StartElement startElement = eventReader.nextEvent().asStartElement();
                WordCard card = new WordCard();
                card.setWord(startElement.getAttributeByName(word).getValue());
                card.setPos(startElement.getAttributeByName(pos).getValue());
                card.setJapanese(startElement.getAttributeByName(japanese).getValue());
                card.setEnglish(startElement.getAttributeByName(english).getValue());
                card.setExample(startElement.getAttributeByName(example).getValue());
                cards.add(card);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cards;
    }
}

