/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.smartfm.items;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.stream.events.XMLEvent;
import org.tonouchi.vocabulardictionary.smartfm.items.CueCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.ItemCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.ItemsCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.SetDefinitionCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.SetWordCommand;
import org.tonouchi.vocabulardictionary.smartfm.items.SmartFmCommand;

public class SmartFmCommandFactory {
    private Hashtable<String, SmartFmCommand> commandMap = new Hashtable();
    private SmartFmCommand smartFmCommand = new SmartFmCommand();

    public SmartFmCommandFactory() {
        this.commandMap.put("/items", new ItemsCommand());
        this.commandMap.put("/items/item", new ItemCommand());
        this.commandMap.put("/items/item/cue", new CueCommand());
        this.commandMap.put("/items/item/cue/text/@CHARACTERS", new SetWordCommand());
        this.commandMap.put("/items/item/responses/response/text/@CHARACTERS", new SetDefinitionCommand());
    }

    public SmartFmCommand create(Stack<XMLEvent> eventStack) {
        String key = this.toKey(eventStack);
        if (this.commandMap.containsKey(key)) {
            return this.commandMap.get(key);
        }
        return this.smartFmCommand;
    }

    private String toKey(Stack<XMLEvent> eventStack) {
        Enumeration eventEnumeration = eventStack.elements();
        StringBuffer buf = new StringBuffer();
        while (eventEnumeration.hasMoreElements()) {
            XMLEvent event = (XMLEvent)eventEnumeration.nextElement();
            if (event.isStartElement()) {
                buf.append('/').append(event.asStartElement().getName().getLocalPart());
                continue;
            }
            if (!event.isCharacters()) continue;
            buf.append('/').append("@CHARACTERS");
        }
        return buf.toString();
    }
}

