/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.wordnet;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabulardictionary.DictionaryWrapper;
import org.tonouchi.vocabulardictionary.Result;

public class WordNetExamples
implements DictionaryWrapper {
    @Override
    public void initialize(Config config) {
        try {
            if (!JWNL.isInitialized()) {
                JWNL.initialize((InputStream)new FileInputStream(config.getWordNetSettingPath()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (JWNL.isInitialized()) {
            JWNL.shutdown();
        }
    }

    @Override
    public List<Result> lookup(String word) {
        ArrayList<Result> results = new ArrayList<Result>();
        try {
            Dictionary dictionary = Dictionary.getInstance();
            IndexWordSet indexWordSet = dictionary.lookupAllIndexWords(word);
            for (IndexWord indexWord : indexWordSet.getIndexWordArray()) {
                String lemma = indexWord.getLemma();
                String pos = indexWord.getPOS().getLabel();
                for (Synset synset : indexWord.getSenses()) {
                    String gloss = synset.getGloss();
                    StringTokenizer tkn = new StringTokenizer(gloss, ";");
                    while (tkn.hasMoreElements()) {
                        String str = tkn.nextToken().trim();
                        if (!str.matches("\".+\"")) continue;
                        String example = str.trim();
                        Result result = new Result();
                        result.setWord(lemma);
                        result.setCategory(pos);
                        result.setDefinition(example.substring(1, example.length() - 1));
                        results.add(result);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results;
    }
}

