/***************************************************************************/
/*! \file   cecaiacontroller.h
    \brief  饹CEcaIAControllerΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5 28  17:10:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CECAIACONTROLLER_H
#define CECAIACONTROLLER_H

#include <qobject.h>
#include <qvaluevector.h>
#include <qstring.h>
#include <qstringlist.h>
#include <eca-control-interface.h>

/*-------------------------------------------------------------------------*/
/*! \class  CEcaIAController
    \brief  Ecasound󥿥饯ƥ֥⡼ɤ椹뤿Υ饹
*/
/*-------------------------------------------------------------------------*/
class CEcaIAController : public QObject
{
  Q_OBJECT

public:
  enum Status {
    Running,
    NotStarted,
    Stopped,
    Finished,
    NotReady,
    Error
  };

  //! \brief 󥹥ȥ饯
  CEcaIAController();
  //! \brief ǥȥ饯
  virtual ~CEcaIAController();

  //! \brief  󥻥åȥåפϲǽɤ֤
  //! \return (ޤϿ)ǽʾ硢true֤
  bool isValidChainsetup();

public slots:

private:
  //! \brief ԡ󥹥ȥ饯ԡػߤ뤿ᡢprivate
  CEcaIAController(const CEcaIAController&);
  //! \brief 黻ҡػߤ뤿ᡢprivate
  CEcaIAController& operator=(const CEcaIAController&);

  //! Ecasound Control Interface
  ECA_CONTROL_INTERFACE ecaEngine;

protected:
  //! ֥륯
  static const QString DQ;

  //! \brief ecaController˥ޥɤ롣
  //! \param strCommand EIAMޥɡ
  //! \param bOut ʥmessageGeneratedϤ硢trueꡣ
  void command(const QString& strCommand, bool bOut=true);
  //! \brief ecaControllerưޥɤ롣
  //! \param strCommand EIAMޥɡ
  //! \param dArg ưѥ᡼
  //! \param bOut Ϥ˼¹ԤޥɤϤ硢trueꡣ
  void commandFloatArg(const QString& strCommand, double dArg, bool bOut=true);

  int         lastInteger() const;             //!< ecaEngineη̡
  long        lastLongInteger() const;         //!< ecaEngineη̡
  double      lastFloat() const;               //!< ecaEngineη̡
  bool        lastBool() const;                //!< ecaEngineη̡
  QString     lastString() const;              //!< ecaEngineη̡
  QStringList lastStringList() const;          //!< ecaEngineη̡
  int         lastCountOfStringList() const;   //!< ecaEngineη(QStringListΥ)
  QString     lastError() const;               //!< ecaEngineΥ顼
  QString     lastType() const;                //!< 
  bool        occuredError() const;            //!< ecaEngineǥ顼ȯɤ

  bool    areEventsAvailable();
  void    advanceNextEvent();
  QString currentEvent();

  //! \brief ߤξ֤֤
  Status engineStatus();

private slots:

signals:
  //! \brief å줿ȯ륷ʥ롣
  //! \param strMessage å
  void messageGenerated(const QString& strMessage);
};

#endif
