/***************************************************************************/
/*! \file   cecatools.h
    \brief  饹CEcaToolsΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5 27  01:53:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CECATOOLS_H
#define CECATOOLS_H

#include <qdatetime.h>
#include "cecaiacontroller.h"
#include "csourceformat.h"

/*-------------------------------------------------------------------------*/
/*! \class  CEcaTools
    \brief  Ecasound󥿥饯ƥ֥⡼ɤˤäơEcasoundǽ
    Ѥ뤿Υ饹
*/
/*-------------------------------------------------------------------------*/
class CEcaTools : public CEcaIAController
{
public:
  //! \brief 󥹥ȥ饯
  CEcaTools();
  //! \brief ǥȥ饯
  virtual ~CEcaTools();

  //! \brief Ĺ֤
  QTime sourceLength(const QString& strFileName);
  //! \brief Υץ󥰥եޥåȤ֤
  CSourceFormat::SampleFormat sampleFormat(const QString& strFileName);
  //! \brief ֤ͥ
  int channelCount(const QString& strFileName);
  //! \brief ץ󥰥졼Ȥ֤
  int sampleRate(const QString& strFileName);

private:
  //! \brief ԡ󥹥ȥ饯ԡػߤ뤿ᡢprivate
  CEcaTools(const CEcaTools&);
  //! \brief 黻ҡػߤ뤿ᡢprivate
  CEcaTools& operator=(const CEcaTools&);
};

#endif
