/***************************************************************************/
/*! \file   cewf.h
    \brief  饹CEwfΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  17:24:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CEWF_H
#define CEWF_H

#include <qobject.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qfile.h>
#include "ctrackinf.h"

/*-------------------------------------------------------------------------*/
/*! \class  CEwf
    \brief  Ecasound Wave File椹뤿Υ饹
*/
/*-------------------------------------------------------------------------*/
class CEwf : public QObject
{
  Q_OBJECT
public:
  //! \enum ValueType 
  enum ValueType {
    Source, 
    Offset, 
    StartPosition, 
    Length, 
    Looping, 
    Comment, 
    Invalid
  };

  //! \brief  ꤵ줿ե뤬Ecasound Wave Fileե뤫ɤ֤
  //! \param  strFileName ե롣
  //! \return strFileNameEcasound Wave Fileξ硢true֤
  //! \todo   Ʊѿͻ꤬2ٰʾԤƤǤEcasound Wave FileȤ
  //! ᤷƤޤޤͤηˤĤƤϥåʤ
  //! ѿ̾ΤɤĴ٤롣
  static bool isEwf(const QString& strFileName);
  //! \brief  EwfΥɥפ롣
  //! \param  strLine "ѿ="ʸ󡣹˲ԤäƤϤʤʤ
  static ValueType valueType(const QString& strLine);
  //! \brief  ͤ롣
  //! \param  strLine "ѿ="ʸ󡣹˲ԤäƤϤʤʤ
  //! \return ͡
  static QString value(const QString& strLine);

  //! \brief 󥹥ȥ饯
  CEwf();
  //! \brief ԡ󥹥ȥ饯
  //! \param EWfSrc ԡ
  CEwf(const CEwf& src);
  //! \brief 󥹥ȥ饯
  //! \param trackInf ȥå
  CEwf(const CTrackInf& trackInf);
  //! \brief 󥹥ȥ饯
  //! \param strEwfFileName ե롣
  CEwf(const QString& strEwfFileName);
  //! \brief ǥȥ饯
  virtual ~CEwf();
  //! \brief 黻ҡ
  CEwf& operator=(const CEwf& src);

  //! \brief ե̾Τ֤
  QString fileName() const;
  //! \brief եåȤ֤
  QTime offset() const;
  //! \brief ϰ֤֤
  QTime startPosition() const;
  //! \brief Ĺ֤
  QTime length() const;
  //! \brief եåȤư֤
  double offsetInDouble() const;
  //! \brief ϰ֤ư֤
  double startPositionInDouble() const;
  //! \brief Ĺư֤
  double lengthInDouble() const;
  //! \brief 롼פON/OFF֤
  bool looping() const;

  //! \brief EWFѤ̤뤫ɤ֤
  bool hasAdvantage() const;

  //! \brief ֥Ȥꤹ롣
  //! \param trackInf ȥå
  void set(const CTrackInf& trackInf);
  //! \brief ֥Ȥꤹ롣
  //! \param strSrcFile ե̾Ρ
  //! \param timeOffsetFromOrigin եåȡ
  //! \param timePosition ϰ֡
  //! \param timePlayLength Ĺ
  //! \param bDoLoop 롼פON/OFF
  void set(const QString& strSrcFile,
           const QTime&   timeOffsetFromOrigin,
           const QTime&   timePosition, 
           const QTime&   timePlayLength,
           bool           bDoLoop);

  //! \brief  Ecasound Wave Fileؤν񤭹ߤԤ
  //! \param  strEwf EWF̾ΡĥҤ ".ewf" ǤʤСԤ롣
  //! Ʊ̾Υե뤬¸ߤƤ顢񤭤롣
  //! \return true
  bool writeEcasoundWaveFile(const QString& strEwf);

private:
  //! ͭưͤκǾ
  static const double PositiveMinValue;

  //! ե̾Ρ
  QString strFileName;
  //! եåȡ
  QTime timeOffset;
  //! ϰ֡
  QTime timeStartPosition;
  //! Ĺ
  QTime timeLength;
  //! 롼פON/OFF
  bool bLooping;
};

#endif
