/***************************************************************************
                          cladspaeffect.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  16:28:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cladspaeffect.h"

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect()
  : strLabel() // empty label means not available
{
  
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect(
  const QString& strLibFileName,
  const LADSPA_Descriptor* Desc)
{
  bind(strLibFileName, Desc);
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::CLadspaEffect(const CLadspaEffect& src)
{
  nID          = src.nID;
  strFileName  = src.strFileName;
  strLabel     = src.strLabel;
  strName      = src.strName;
  strMaker     = src.strMaker;
  strCopyright = src.strCopyright;
  fxInControlPorts  = src.fxInControlPorts;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect::~CLadspaEffect()
{
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect&
CLadspaEffect::operator=(const CLadspaEffect& src)
{
  nID          = src.nID;
  strFileName  = src.strFileName;
  strLabel     = src.strLabel;
  strName      = src.strName;
  strMaker     = src.strMaker;
  strCopyright = src.strCopyright;
  fxInControlPorts  = src.fxInControlPorts;

  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

bool
CLadspaEffect::operator==(const CLadspaEffect& src) const
{
  if ( this->nID != src.nID ) {
    return false;
  }
  
  if ( this->strFileName != src.strFileName ) {
    return false;
  }

  if ( this->strLabel != src.strLabel ) {
    return false;
  }

  if ( this->strName != src.strName ) {
    return false;
  }

  if ( this->strMaker != src.strMaker ) {
    return false;
  }

  if ( this->strCopyright != src.strCopyright ) {
    return false;
  }

  QValueVector<CEffectPort>::const_iterator itThis = 
    this->fxInControlPorts.begin();
  QValueVector<CEffectPort>::const_iterator itSrc = 
    src.fxInControlPorts.begin();

  while ( itThis != this->fxInControlPorts.end() ) {
    if ( (*itThis) != (*itSrc) ) {
      return false;
    }

    itThis++;
    itSrc++;
  }

  return true;
}

/////////////////////////////////////////////////////////////////////////////
bool 
CLadspaEffect::operator!=(const CLadspaEffect& src) const
{
  return !(this->operator==(src));
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaEffect::bind(
  const QString& strLibFileName, 
  const LADSPA_Descriptor* Desc)
{
  if ( Desc == NULL ) {
    return;
  }

  nID          = Desc->UniqueID;
  strFileName  = strLibFileName;
  strLabel     = Desc->Label;
  strName      = Desc->Name;
  strMaker     = Desc->Maker;
  strCopyright = Desc->Copyright;

  fxInControlPorts.clear();
  int i;
  int nPortCount = Desc->PortCount;
  for ( i = 0; i < nPortCount; i++ ) {
    if ( !(LADSPA_IS_PORT_INPUT(Desc->PortDescriptors[i]) &&
           LADSPA_IS_PORT_CONTROL(Desc->PortDescriptors[i])) ) {
      continue;
    }

    fxInControlPorts.push_back(
      CEffectPort(Desc->PortNames[i], Desc->PortRangeHints[i]));
  }
}

/////////////////////////////////////////////////////////////////////////////

ulong
CLadspaEffect::id() const
{
  return nID;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::libFileName() const
{
  return strFileName;
}

/////////////////////////////////////////////////////////////////////////////

QString 
CLadspaEffect::label() const
{
  return strLabel;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::name() const
{
  return strName;
}

/////////////////////////////////////////////////////////////////////////////

QString
CLadspaEffect::maker() const
{
  return strMaker;
}

/////////////////////////////////////////////////////////////////////////////

QString 
CLadspaEffect::copyright() const
{
  return strCopyright;
}

/////////////////////////////////////////////////////////////////////////////

int
CLadspaEffect::effectPortCount() const
{
  return fxInControlPorts.size();
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort
CLadspaEffect::effectPort(int nIndex) const
{
  if ( (nIndex < 0) || 
       (fxInControlPorts.size() <= static_cast<uint>(nIndex)) ) {
    return CEffectPort();
  }
  
  return fxInControlPorts[nIndex];
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaEffect::setEffectPortParam(int nIndex, NEffectPort::UValue uvParam)
{
  if ( (nIndex < 0) || 
       (fxInControlPorts.size() <= static_cast<uint>(nIndex)) ) {
    return;
  }

  fxInControlPorts[nIndex].setValue(uvParam);
}
  
/////////////////////////////////////////////////////////////////////////////
