/***************************************************************************
                          cladspafactory.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 31  00:06:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qstringlist.h>
#include <qdir.h>
#include "cladspapluginlibrary.h"
#include "cladspafactory.h"

/////////////////////////////////////////////////////////////////////////////

CLadspaFactory* CLadspaFactory::ladspaFactory(NULL);

/////////////////////////////////////////////////////////////////////////////

bool
CLadspaFactory::createInstance(const QString& strLadspaPath)
{
  if ( ladspaFactory != NULL ) {
    return false;
  }

  ladspaFactory = new CLadspaFactory(strLadspaPath);

  return true;
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaFactory::destroyInstance()
{
  if ( ladspaFactory == NULL ) {
    return;
  }

  delete ladspaFactory;
  ladspaFactory = NULL;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaFactory*
CLadspaFactory::instance()
{
  return ladspaFactory;
}

/////////////////////////////////////////////////////////////////////////////

CLadspaFactory::CLadspaFactory(const QString& strLadspaPath)
{
  slotReload(strLadspaPath);
}

/////////////////////////////////////////////////////////////////////////////

CLadspaFactory::~CLadspaFactory()
{
  vEffects.clear();
  mEffectIDs.clear();
}

/////////////////////////////////////////////////////////////////////////////

int
CLadspaFactory::effectCount() const
{
  return vEffects.size();
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect
CLadspaFactory::effect(int nID) const
{
  if ( nID < 0 || static_cast<int>(vEffects.size()) <= nID ) {
    return CLadspaEffect();
  }

  return vEffects[nID];
}

/////////////////////////////////////////////////////////////////////////////

CLadspaEffect
CLadspaFactory::effect(const QString& strLabel) const
{
  QMap<QString, int>::const_iterator it = mEffectIDs.find(strLabel);
  if ( it == mEffectIDs.end() ) {
    return CLadspaEffect();
  }

  return vEffects[it.data()];
}

/////////////////////////////////////////////////////////////////////////////

void 
CLadspaFactory::slotReload(const QString& strLadspaPath)
{
  vEffects.clear();
  mEffectIDs.clear();

  QDir dirLadspa(strLadspaPath);
  dirLadspa.setFilter(QDir::Files);
  int  nFiles = dirLadspa.count();
  int  i;

  for ( i = 0; i < nFiles; i++ ) {
    QString strFileName = dirLadspa.path();
    strFileName += "/" + (dirLadspa.entryList())[i];
    
    CLadspaPluginLibrary pluginLib(strFileName);
    if ( !pluginLib.isLadspaPluginLibrary() ) {
      continue;
    }

    int nEffects = pluginLib.effectCount();
    int j;
    for ( j = 0; j < nEffects; j++ ) {
      vEffects.push_back(pluginLib.effect(j));
      mEffectIDs[pluginLib.effect(j).label()] = j;
    }
  }

  emit reloaded();
}

/////////////////////////////////////////////////////////////////////////////

#include "cladspafactory.moc"
