/***************************************************************************/
/*! \file   ctrackinf.h
    \brief  饹STrackInfΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  16:23:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CTRACKINF_H
#define CTRACKINF_H

#include <qstring.h>
#include <qdatetime.h>
#include <qvaluevector.h>
#include <qdom.h>
#include "csourceformat.h"
#include "cladspaeffect.h"

/*-------------------------------------------------------------------------*/
/*! \class  CTrackInf
    \brief  ȥå
*/
/*-------------------------------------------------------------------------*/
class CTrackInf
{
public:
  //! \brief 󥹥ȥ饯(ǥե)
  CTrackInf();
  //! \brief 󥹥ȥ饯
  //! \param nodTrack DOMΡɡ
  CTrackInf(const QDomNode& nodTrack);
  //! \brief 󥹥ȥ饯(ԡ)
  CTrackInf(const CTrackInf& src);
  //! \brief ǥȥ饯
  virtual ~CTrackInf();
  //! \brief 黻ҡ
  CTrackInf& operator=(const CTrackInf& src);

  //! \brief ȥå̾Τ֤
  QString trackName() const;
  //! \brief ե̾Τ֤
  QString fileName() const;
  //! \brief ϥǥХ֤
  QString inputDevice() const;
  //! \brief ϥǥХ֤
  QString outputDevice() const;
  //! \brief ٥֤
  int  level() const;
  //! \brief ѥ֤
  int  pan() const;
  //! \brief ϰ֤֤
  QTime startPosition() const;
  //! \brief եåȤ֤
  QTime offset() const;
  //! \brief ֤֤
  QTime length() const;
  //! \brief ߥ塼Ⱦ֤֤
  bool isMuted() const;
  //! \brief ϿݡȾ֤֤
  bool isSetRec() const;
  //! \brief LADSPAեȤν֤
  QValueVector<CLadspaEffect> effects() const;
  //! \brief Хѥ֤֤
  bool isBypassed() const;

  //! \brief ȥå̾Τꤹ롣
  void setTrackName(const QString& strName);
  //! \brief ե̾Τꤹ롣
  void setFileName(const QString& strFileName);
  //! \brief ϥǥХꤹ롣
  void setInputDevice(const QString& strDeviceName);
  //! \brief ϥǥХꤹ롣
  void setOutputDevice(const QString& strDeviceName);
  //! \brief ٥ꤹ롣
  void setLevel(int nValue);
  //! \brief ѥꤹ롣
  void setPan(int nValue);
  //! \brief ϰ֤ꤹ롣
  void setStartPosition(const QTime& time);
  //! \brief եåȤꤹ롣
  void setOffset(const QTime& time);
  //! \brief ֤ꤹ롣
  void setLength(const QTime& time);
  //! \brief ߥ塼Ⱦ֤ꤹ롣
  void setMute(bool bState);
  //! \brief ϿݡȾ֤ꤹ롣
  void setRec(bool bState);
  //! \brief LADSPAեȤνꤹ롣
  void setEffects(const QValueVector<CLadspaEffect>& effects);
  //! \brief Хѥ֤ꤹ롣
  void setBypass(bool bState);

  //! \brief  ȥåξ֤DOMꤹ롣
  //! \param  nodTrack DOMΡɡ
  void setStateByDom(const QDomNode& nodTrack);
  //! \brief  󥹥󥹤ξ֤DOM֤
  //! \param  pDoc   DOMɥȡ
  //! \return DOMΡɡ
  QDomNode stateInDOM(QDomDocument* pDoc) const;

private:
  //! ȥå̾Ρ
  QString strTrackName;
  //! ե̾Ρ
  QString strFileName;
  //! ϥǥХ
  QString strInputDevice;
  //! ϥǥХ
  QString strOutputDevice;
  //! ٥롣
  int  nLevel;
  //! ѥ
  int  nPan;
  //! ϰ()
  QTime timeStartPosition;
  //! եåȡ
  QTime timeOffset;
  //! ֡
  QTime timeLength;
  //! ߥ塼Ⱦ֡
  bool bMute;
  //! ϿݡȾ֡
  bool bRecPort;
  //! LADSPAեȤν硣
  QValueVector<CLadspaEffect> vEffects;
  //! Хѥ֡
  bool bBypass;

  void copy(const CTrackInf& src);
};

/////////////////////////////////////////////////////////////////////////////
// CTrackInf inline functions
/////////////////////////////////////////////////////////////////////////////

inline QString
CTrackInf::trackName() const
{
  return strTrackName;
}

/////////////////////////////////////////////////////////////////////////////

inline QString
CTrackInf::fileName() const
{
  return strFileName;
}

/////////////////////////////////////////////////////////////////////////////

inline QString
CTrackInf::inputDevice() const
{
  return strInputDevice;
}

/////////////////////////////////////////////////////////////////////////////

inline QString
CTrackInf::outputDevice() const
{
  return strOutputDevice;
}

/////////////////////////////////////////////////////////////////////////////

inline int
CTrackInf::level() const
{
  return nLevel;
}

/////////////////////////////////////////////////////////////////////////////

inline int 
CTrackInf::pan() const
{
  return nPan;
}
  
/////////////////////////////////////////////////////////////////////////////

inline QTime 
CTrackInf::startPosition() const
{
  return timeStartPosition;
}

/////////////////////////////////////////////////////////////////////////////

inline QTime 
CTrackInf::offset() const
{
  return timeOffset;
}

/////////////////////////////////////////////////////////////////////////////

inline QTime 
CTrackInf::length() const
{
  return timeLength;
}

/////////////////////////////////////////////////////////////////////////////

inline bool 
CTrackInf::isMuted() const
{
  return bMute;
}

/////////////////////////////////////////////////////////////////////////////

inline bool 
CTrackInf::isSetRec() const
{
  return bRecPort;
}

/////////////////////////////////////////////////////////////////////////////

inline QValueVector<CLadspaEffect> 
CTrackInf::effects() const
{
  return vEffects;
}

/////////////////////////////////////////////////////////////////////////////

inline bool 
CTrackInf::isBypassed() const
{
  return bBypass;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setTrackName(const QString& strName)
{
  this->strTrackName = strName;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setFileName(const QString& strFileName)
{
  this->strFileName = strFileName;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setInputDevice(const QString& strDeviceName)
{
  this->strInputDevice = strDeviceName;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setOutputDevice(const QString& strDeviceName)
{
  this->strOutputDevice = strDeviceName;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setLevel(int nValue)
{
  this->nLevel = nValue;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setPan(int nValue)
{
  this->nPan = nValue;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setStartPosition(const QTime& time)
{
  this->timeStartPosition = time;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setOffset(const QTime& time)
{
  this->timeOffset = time;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setLength(const QTime& time)
{
  this->timeLength = time;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setMute(bool bState)
{
  this->bMute = bState;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setRec(bool bState)
{
  this->bRecPort = bState;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setEffects(const QValueVector<CLadspaEffect>& effects)
{
  this->vEffects = effects;
}

/////////////////////////////////////////////////////////////////////////////

inline void 
CTrackInf::setBypass(bool bState)
{
  this->bBypass = bState;
}

/////////////////////////////////////////////////////////////////////////////

#endif
