/***************************************************************************
                          wmixdowndialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 19  00:14:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qfileinfo.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "wmixdowndialog.h"

/////////////////////////////////////////////////////////////////////////////

WMixdownDialog::WMixdownDialog(QWidget* WidgetParent, const char* cName)
  : KDialogBase(KDialogBase::Plain,
                "Mixdown",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  QFrame *FramePage = plainPage();
  FramePage->setMinimumHeight(120);
  FramePage->setMinimumWidth(240);

  QVBoxLayout* Layout = new QVBoxLayout(FramePage);

  CheckBoxWithPlaying = new QCheckBox(i18n("&Play with Mixdown"), FramePage);
  Layout->addWidget(CheckBoxWithPlaying);

  Layout->addStretch();

  QLabel* Label = new QLabel(i18n("File to save mixdown sound"), FramePage);
  Layout->addWidget(Label);
  FileChooserMixdown = new WFileChooser(
                             "", 
                             i18n("Detect mixdown sound file"), 
                             FramePage);
  FileChooserMixdown->setFileType(
                        i18n("*.wav *.mp3|Sound files (*.wav; *.mp3)\n*"
                        "|All files (*)"));
  Layout->addWidget(FileChooserMixdown);

  enableButtonOK(false);

  connect(FileChooserMixdown, 
          SIGNAL(fileNameChanged(const QString&)), 
          this, 
          SLOT(slotChangedFileName(const QString&)));
}

/////////////////////////////////////////////////////////////////////////////

WMixdownDialog::~WMixdownDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

bool 
WMixdownDialog::mixesWithPlaying() const
{
  return CheckBoxWithPlaying->isOn();
}

/////////////////////////////////////////////////////////////////////////////

QString
WMixdownDialog::fileName() const
{
  return FileChooserMixdown->fileName();
}

/////////////////////////////////////////////////////////////////////////////

void 
WMixdownDialog::slotOk()
{
  QFileInfo fileInfo(FileChooserMixdown->fileName());
  if ( fileInfo.exists() ) {
    if ( KMessageBox::warningYesNo(
           this, 
           QString(i18n("A file named \"%1\" already exists. "
                "Are you sure you want to overwrite it?").arg(fileInfo.filePath())), 
           "Overwrite File?") != KMessageBox::Yes ) {
      return;
    }
  }

  emit okClicked();
  accept();
}

/////////////////////////////////////////////////////////////////////////////

void 
WMixdownDialog::slotChangedFileName(const QString& strFileName)
{
  if ( strFileName.isEmpty() ) {
    enableButtonOK(false);
  } else {
    enableButtonOK(true);
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wmixdowndialog.moc"
