/***************************************************************************
                          wtimedialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:36:12 JST
    copyright            : (C) 2003 by Black Sabbath
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include "wtimedialog.h"

/////////////////////////////////////////////////////////////////////////////

WTimeDialog::WTimeDialog(QWidget* WidgetParent, const char* cName)
  : KDialogBase(KDialogBase::Plain,
                "Set Time",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  QFrame *FramePage = plainPage();
  FramePage->setMaximumHeight(80);
  FramePage->setMinimumHeight(80);
  FramePage->setMinimumWidth(240);

  QHBoxLayout* Layout = new QHBoxLayout(FramePage);

  QLabel* LabelMMSS = new QLabel("MM:SS ", FramePage);
  Layout->addWidget(LabelMMSS);

  TimeEdit = new QTimeEdit(FramePage);
  Layout->addWidget(TimeEdit);

  QLabel* LabelAnd = new QLabel(" and ", FramePage);
  Layout->addWidget(LabelAnd);

  IntSpinMilliSec = new KIntSpinBox(0, 999, 1, 0, 10, FramePage);
  Layout->addWidget(IntSpinMilliSec);

  QLabel* LabelMilliSec = new QLabel(" milliseconds ", FramePage);
  Layout->addWidget(LabelMilliSec);
}

/////////////////////////////////////////////////////////////////////////////

WTimeDialog::~WTimeDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WTimeDialog::setDisplay(uint disp)
{
  TimeEdit->setDisplay(disp ^ MilliSecs);
  if ( disp & MilliSecs ) {
    IntSpinMilliSec->show();
  } else {
    IntSpinMilliSec->hide();
  }
}

/////////////////////////////////////////////////////////////////////////////

QTime 
WTimeDialog::time() const
{
  QTime TimeReturn = TimeEdit->time();
  if ( IntSpinMilliSec->isVisible() ) {
    return TimeReturn.addSecs(IntSpinMilliSec->value());
  } else {
    return TimeReturn;
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WTimeDialog::setTime(const QTime& time)
{
  TimeEdit->setTime(time);
}

/////////////////////////////////////////////////////////////////////////////

#include "wtimedialog.moc"
