/***************************************************************************
                          wprefdialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:44:12 JST
    copyright            : (C) 2003 by Black Sabbath
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <sys/types.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kglobal.h>
#include "wprefdialog.h"
#include "cvoxstormglobal.h"

/////////////////////////////////////////////////////////////////////////////

WPrefDialog::WPrefDialog(QWidget *WidgetParent, const char *cName)
  : KDialogBase(KDialogBase::IconList,
                "Configure VoxStorm", 
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  // ǥХڡ
  setupDevicesPage();
  // եڡ
  setupFilePage();
  // ɥڥåڡ
  setupSoundSpecPage();
  // ȥåڡ
  setupTrackPage();
  // ̥ڡ
  setupGenericPage();

  setMinimumHeight(320);
}

/////////////////////////////////////////////////////////////////////////////

WPrefDialog::~WPrefDialog()
{

}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setFields(const SPreferences& PreferencesSet)
{
  FileChooserPlay->setFileName(PreferencesSet.strPlayDevice);
  FileChooserRec->setFileName(PreferencesSet.strRecDevice);
 
  switch ( PreferencesSet.FileType ) {
  case CVoxStormGlobal::ecaWAV:
    ComboBoxFileType->setCurrentItem(0);
    break;
  case CVoxStormGlobal::ecaMP3:
    ComboBoxFileType->setCurrentItem(1);
    break;
  default:
    ComboBoxFileType->setCurrentItem(0);
    break;
  }
  DirChooserProject->setFileName(PreferencesSet.strProjectPath);

  switch ( PreferencesSet.uiSampleRate ) {
  case 44100:
    ComboBoxSampleRate->setCurrentItem(0);
    break;
  case 48000:
    ComboBoxSampleRate->setCurrentItem(1);
    break;
  case 96000:
    ComboBoxSampleRate->setCurrentItem(2);
    break;
  default:
    ComboBoxSampleRate->setCurrentItem(0);
    break;
  }
  switch ( PreferencesSet.uiBuffer ) {
  case 64:
    ComboBoxBuffer->setCurrentItem(0);
    break;
  case 128:
    ComboBoxBuffer->setCurrentItem(1);
    break;
  case 256:
    ComboBoxBuffer->setCurrentItem(2);
    break;
  case 512:
    ComboBoxBuffer->setCurrentItem(3);
    break;
  default:
    ComboBoxBuffer->setCurrentItem(4);
    break;
  }

  ListBoxTracks->clear();
  ListBoxTracks->insertStringList(PreferencesSet.strlDefaultTracks);

  IntNumInputFrameSeconds->setValue(PreferencesSet.iFrameSeconds);
}

/////////////////////////////////////////////////////////////////////////////

SPreferences
WPrefDialog::fields()
{
  SPreferences PreferencesReturn;
  PreferencesReturn.strPlayDevice = FileChooserPlay->fileName();
  PreferencesReturn.strRecDevice = FileChooserRec->fileName();

  switch ( ComboBoxFileType->currentItem() ) {
  case 0:
    PreferencesReturn.FileType = CVoxStormGlobal::ecaWAV;
    break;
  case 1:
    PreferencesReturn.FileType = CVoxStormGlobal::ecaMP3;
    break;
  default:
    PreferencesReturn.FileType = CVoxStormGlobal::ecaWAV;
    break;
  }
  PreferencesReturn.strProjectPath = DirChooserProject->fileName();

  PreferencesReturn.uiSampleRate = ComboBoxSampleRate->currentText().toUInt();
  PreferencesReturn.uiBuffer     = ComboBoxBuffer->currentText().toUInt();

  int i, nTrack;
  nTrack = ListBoxTracks->count();
  for ( i = 0; i < nTrack; i++ ) {
    PreferencesReturn.strlDefaultTracks.append(ListBoxTracks->item(i)->text());
  }

  PreferencesReturn.iFrameSeconds = IntNumInputFrameSeconds->value();

  return PreferencesReturn;
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupDevicesPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_hardware", KIcon::NoGroup, 32);
  QVBox *VBoxDevices = addVBoxPage(QString("Devices"),
                          "Detecting default devices for new track",
                          Pix);
  VBoxDevices->setMinimumHeight(120);

  // ǥХ
  FileChooserPlay = new WFileChooser("  Play", "Select device file", VBoxDevices);
  FileChooserPlay->setSearchDir("file:///dev");
  FileChooserPlay->setFileType("*|All files");
  FileChooserPlay->setFileName("/dev/dsp");

  // ϿǥХ
  FileChooserRec = new WFileChooser("Record", "Select device file", VBoxDevices);
  FileChooserRec->setSearchDir("file:///dev");
  FileChooserRec->setFileType("*|All files");
  FileChooserRec->setFileName("/dev/dsp");
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupFilePage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_sound", KIcon::NoGroup, 32);
  QVBox *VBoxFile = addVBoxPage(QString("File"),
                          "Detecting file types etc", 
                          Pix);
  VBoxFile->setMinimumHeight(120);

  // ե륿׻ΤΥåȷꡣ
  QVGroupBox *GroupBoxFileType = new QVGroupBox(
          "File type", VBoxFile);
  ComboBoxFileType = new KComboBox(GroupBoxFileType);
  ComboBoxFileType->insertItem("MP3 (*.mp3)");
  ComboBoxFileType->insertItem("WAVE (*.wav)");
  ComboBoxFileType->setCurrentItem(0);

  // ץȤΥǥե¸ѥΤΥåȷꡣ
  QVGroupBox *GroupBoxProjectPath = new QVGroupBox(
          "VoxStorm session file saving directory", VBoxFile);
  DirChooserProject = new WFileChooser(
                            "",
                            "Select VoxStorm session file saving directory",
                            GroupBoxProjectPath);
  DirChooserProject->setUsageForDir(true);
  DirChooserProject->setFileName("~/voxstorm");
}

/////////////////////////////////////////////////////////////////////////////

void 
WPrefDialog::setupSoundSpecPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_soundspec", KIcon::NoGroup, 32);
  QVBox *VBoxSound = addVBoxPage(QString("Sound Spec"),
                          "Detecting sound spec",
                          Pix);
  QGridLayout *GridLayout = new QGridLayout(VBoxSound, 2, 1);

  // sampling rate
  QHGroupBox *GroupBoxSampling = new QHGroupBox(
          "Sampling rate", VBoxSound);
  GridLayout->addWidget(GroupBoxSampling, 0, 0);
  ComboBoxSampleRate = new KComboBox(GroupBoxSampling);
  ComboBoxSampleRate->insertItem("44100");
  ComboBoxSampleRate->insertItem("48000");
  ComboBoxSampleRate->insertItem("96000");

  // size of buffer in samples (must be an exponent of 2)
  QVGroupBox *GroupBoxBuffer   = new QVGroupBox(
          "Buffer size in samples", VBoxSound);
  GridLayout->addWidget(GroupBoxBuffer, 1, 0);
  ComboBoxBuffer = new KComboBox(GroupBoxBuffer);
  ComboBoxBuffer->insertItem("64");
  ComboBoxBuffer->insertItem("128");
  ComboBoxBuffer->insertItem("256");
  ComboBoxBuffer->insertItem("512");
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupTrackPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_track", KIcon::NoGroup, 32);
  QVBox *VBoxTrack = addVBoxPage(QString("Track"),
                          "Detecting default tracks etc",
                          Pix);

  // åΥǥեȥȥåΤΥåȷ
  QHGroupBox *GroupBoxTracks = new QHGroupBox(
          "Default track names", VBoxTrack, "GroupBoxTracks");

  // ɲ
  LineEditName = new KRestrictedLine(GroupBoxTracks);
  LineEditName->setValidChars(CVoxStormGlobal::ValidCharsTrack);
  connect(LineEditName, SIGNAL(textChanged(const QString&)),
          this, SLOT(slotChangeAddState(const QString&)));
  PushButtonAdd = new QPushButton("Add", GroupBoxTracks);
  PushButtonAdd->setEnabled(false);
  connect(PushButtonAdd, SIGNAL(clicked()),
          this, SLOT(slotAddTrackToList()));

  // ǥեȥȥåꥹ
  ListBoxTracks = new KListBox(GroupBoxTracks);
  connect(ListBoxTracks, SIGNAL(selectionChanged()),
          this, SLOT(slotChangeTrackSelection()));

  // ԽΤΥåȷꡣ
  QWidget     *WidgetBase = new QWidget(GroupBoxTracks);
  QGridLayout *GridLayout = new QGridLayout(WidgetBase, 5, 2);
  PushButtonUp     = new QPushButton("Up", WidgetBase);
  GridLayout->addWidget(PushButtonUp, 0, 0);
  connect(PushButtonUp, SIGNAL(clicked()),
          this, SLOT(slotTrackUp()));
  PushButtonDown   = new QPushButton("Down", WidgetBase);
  GridLayout->addWidget(PushButtonDown, 1, 0);
  connect(PushButtonDown, SIGNAL(clicked()),
          this, SLOT(slotTrackDown()));
  PushButtonRemove = new QPushButton("Remove", WidgetBase);
  GridLayout->addWidget(PushButtonRemove, 4, 0);
  connect(PushButtonRemove, SIGNAL(clicked()),
          this, SLOT(slotRemoveTrackFromList()));
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupGenericPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_generic", KIcon::NoGroup, 32);
  QVBox *VBoxGeneric = addVBoxPage(QString("Generic"),
                          "VoxStorm generic settings",
                          Pix);

  // ᤷÿΤΥåȷ
  QHGroupBox *GroupBoxFrameSeconds = new QHGroupBox(
          "Seconds of rewind and forward", VBoxGeneric, "GroupBoxFrameSeconds");
  IntNumInputFrameSeconds = new KIntNumInput(GroupBoxFrameSeconds);
  IntNumInputFrameSeconds->setRange(1, 240);
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotChangeAddState(const QString& strTrack)
{
  if ( strTrack != "" ) {
    PushButtonAdd->setEnabled(true);
  } else {
    PushButtonAdd->setEnabled(false);
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotAddTrackToList()
{
  QString strTrack = LineEditName->text();
  if ( strTrack == "" ) {
    return;
  }

  QListBoxItem *ItemFound = ListBoxTracks->findItem(strTrack);
  if ( ItemFound != NULL ) {
    QString strMessage;
    strMessage  = "The name \"";
    strMessage += strTrack;
    strMessage += "\" is already existing.";
    KMessageBox::sorry(this, strMessage);
    return;
  }

  ListBoxTracks->insertItem(strTrack);
  LineEditName->clear();
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotChangeTrackSelection()
{
  if ( ListBoxTracks->selectedItem() == NULL ) {  // not selected
    PushButtonUp->setEnabled(false);
    PushButtonDown->setEnabled(false);
    PushButtonRemove->setEnabled(false);
  } else {
    PushButtonUp->setEnabled(true);
    PushButtonDown->setEnabled(true);
    PushButtonRemove->setEnabled(true);
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotTrackUp()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  if ( ListBoxTracks->firstItem() == ItemSelected ) {  // top item
    return;
  }

  QString strTmp = ItemSelected->text();
  int     nIndex = ListBoxTracks->index(ItemSelected);
  ListBoxTracks->changeItem(ListBoxTracks->item(nIndex - 1)->text(), nIndex);
  ListBoxTracks->changeItem(strTmp, nIndex - 1);
  ListBoxTracks->setSelected(nIndex - 1, true);
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotTrackDown()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  int     nIndex = ListBoxTracks->index(ItemSelected);
  if ( (ListBoxTracks->count() - 1) == (u_int)nIndex ) {  // bottom item
    return;
  }

  QString strTmp = ItemSelected->text();
  ListBoxTracks->changeItem(ListBoxTracks->item(nIndex + 1)->text(), nIndex);
  ListBoxTracks->changeItem(strTmp, nIndex + 1);
  ListBoxTracks->setSelected(nIndex + 1, true);
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotRemoveTrackFromList()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  ListBoxTracks->removeItem(ListBoxTracks->index(ItemSelected));
}

/////////////////////////////////////////////////////////////////////////////

#include "wprefdialog.moc"
