/*
 The MIT License

Copyright (C) 2005 ߓ@ e.RvcIQ33o

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*******************************************************************************

VPL3 (Vipper Public License)

Copyright (C) 2005 ߓ@ e.RvcIQ33o

0.͂߂
T[o[̌N𑹂Ȃꂪ܂̂
Ղ肷ɒӂ܂傤B

1.ĔЕz̎R
\[XR[hύXۂ͕ύXcƁB
oCî݂̔Еz͔F߂ȂB
Ƃ͎RiOցOj

2.CZX
@2-1.CZXƂ̋
@@̃CZX悯΂̃CZXȊÕ\[XR[hgĂB
@2-2.CZX̕ύX
@@ɂ₪B

3.̃CZXKp@
͂̕\[XɖߍނA
"LICENSE"ƂÕt@CuA\[XR[hCopyright"LICENSE: VPL3"ƂĒuƁB
*/

/* ToDo:
        \XVƂɃXN[o[̈ʒuςȂ悤ɂB
*/


#define _WIN32_IE 0x300 //gXgr[X^Cg߂̂܂Ȃ(^^) 

#include <windows.h>
#include <commctrl.h>
#include <tlhelp32.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "main.h"

/*  Make the class name into a global variable  */
char szClassName[ ] = "WindowsApp";

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
    HWND hwnd;               /* This is the handle for our window */
    HACCEL haccel;
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = "PSMENU";                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default color as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "ps",                /* Title Text */
           WS_OVERLAPPEDWINDOW, /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           544,                 /* The programs width */
           375,                 /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nFunsterStil);
    
    hInstance = hThisInstance;
    
    haccel = LoadAccelerators(hThisInstance, "PSACCEL");

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
          if (!TranslateAccelerator(hwnd , haccel , &messages))
          {
                                         TranslateMessage(&messages);
                                         DispatchMessage(&messages);
          }
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}


/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        RECT rect;
        INITCOMMONCONTROLSEX ic;
        POINT pt;
        HMENU hMenu, hSubMenu;
    switch (message)                  /* handle the messages */
    {
        case WM_DESTROY:
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
        case WM_CREATE:
             ic.dwSize = sizeof(INITCOMMONCONTROLSEX);
             ic.dwICC = ICC_LISTVIEW_CLASSES;
             InitCommonControlsEx(&ic);
             GetClientRect(hwnd, &rect);
             hListView = CreateWindowEx(0, WC_LISTVIEW, 0,
                               WS_CHILD|WS_VISIBLE|LVS_REPORT,
                               0, 0, rect.right, rect.bottom, hwnd, (HMENU)ID_LISTVIEW, 
                               ((LPCREATESTRUCT)lParam)->hInstance , NULL);
             hListView = InitListView();
             SetItems(hwnd);
             
             //SetTimer(hwnd, TIMER_F5, TIMER_INTERVAL, NULL);
             

             break;
        case WM_SIZE:
             MoveWindow(hListView, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
             break;
        case WM_COMMAND:
             switch(LOWORD(wParam))
             {
                                   case IDM_END:
                                        SendMessage(hwnd, WM_CLOSE, 0, 0L);
                                        break;
                                   case IDM_F5:
                                        SetItems(hwnd);
                                        break;
                                   case IDM_TERM:
                                        TermProcess();
                                        break;
                                   case IDM_PRI_REAL:
                                        SetPri(REALTIME_PRIORITY_CLASS);
                                        break;
                                   case IDM_PRI_HIGH:
                                        SetPri(HIGH_PRIORITY_CLASS);
                                        break;
                                   case IDM_PRI_NORMAL:
                                        SetPri(NORMAL_PRIORITY_CLASS);
                                        break;
                                   case IDM_PRI_IDLE:
                                        SetPri(IDLE_PRIORITY_CLASS);
                                        break;
                                   case IDM_RUN:
                                        DialogBox(hInstance, "DIALOG0", hwnd, (DLGPROC)Dialog0Proc);
                                        break;
                                   case IDM_DEBUG0:
                                        ListView_DeleteAllItems(hListView);
                                        break;
                                   case IDM_DEBUG1:
                                        UpdateWindow(hListView);
                                        break;
             }
             break;
        case WM_TIMER:
             switch(wParam)
             {
                           case TIMER_F5:
                                SetItems(hwnd);
                                break;
                           default:
                                   break;
             }
             break;
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

LRESULT CALLBACK Dialog0Proc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        char buf[2048];
        switch(message)
        {
                       case WM_INITDIALOG:
                            return FALSE;
                       case WM_COMMAND:
                            switch(LOWORD(wParam))
                            {
                                                  case IDOK:
                                                       GetDlgItemText(hwnd,
                                                                           IDC_EDIT,
                                                                           buf,
                                                                           sizeof(buf));
                                                       NewProcess(buf);
                                                       EndDialog(hwnd, IDOK);
                                                       break;
                                                  case IDCANCEL:
                                                       EndDialog(hwnd, IDCANCEL);
                                                       break;
                                                  default:
                                                          return FALSE;
                            }
                       default:
                               return FALSE;
        }
        return TRUE;
}

HWND InitListView()
{
     DWORD dwStyle;
     
     dwStyle = ListView_GetExtendedListViewStyle(hListView);
     dwStyle |= LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES | LVS_EX_HEADERDRAGDROP;
     ListView_SetExtendedListViewStyle(hListView, dwStyle);
     LVCOLUMN col;
     col.mask = LVCF_FMT|LVCF_SUBITEM|LVCF_TEXT|LVCF_WIDTH;
     col.fmt = LVCFMT_LEFT;
     col.cx = 50;
     col.pszText = "PID";
     col.iSubItem = 0;
     ListView_InsertColumn(hListView, 0, &col);
     
     col.cx = 50;
     col.pszText = "PPID";
     col.iSubItem = 1;
     ListView_InsertColumn(hListView, 1, &col);
     
     col.cx = 80;
     col.pszText = "Priority";
     col.iSubItem = 2;
     ListView_InsertColumn(hListView, 2, &col);
     
     col.cx = 200;
     col.pszText = "Name";
     col.iSubItem = 3;
     ListView_InsertColumn(hListView, 3, &col);
             
     col.cx = 60;
     col.pszText = "Threads";
     col.iSubItem = 4;
     ListView_InsertColumn(hListView, 4, &col);
     
     return hListView;
}

void SetItems(HWND hwnd)
{
     ListView_DeleteAllItems(hListView);
     
     int i = 0;
     HANDLE hSs;
     PROCESSENTRY32 psentry;
     OSVERSIONINFO osver;
     LVITEM item;
     
     ZeroMemory(&psentry, sizeof(PROCESSENTRY32));
     psentry.dwSize = sizeof(PROCESSENTRY32);
     
     hSs = CreateToolhelp32Snapshot(TH32CS_SNAPALL, 0);
     if( hSs == (HANDLE)-1 )
     {
         MessageBox(hwnd, "Cannot open snapshot", "Error", MB_OK);
         return;
     }
         
     if( Process32First(hSs, &psentry) != TRUE )
     {
         MessageBox(hwnd, "Cannot get process entry.", "Error", MB_OK);
         return;
     }
     item.mask = LVIF_TEXT;//|LVIF_STATE;
     //item.state = LVIS_FOCUSED|LVIS_SELECTED;
     while(1)
     {
             char buf[32], buf2[128];
             ListView_GetItemText(hListView, i, 0, buf2, sizeof(buf2));
             itoa(psentry.th32ProcessID, buf, 10);
             if( !strcmp(buf, buf2) )
                 goto setPPID;
             item.iItem = i;
             item.iSubItem = 0;
             item.pszText = (LPTSTR)buf;
             ListView_InsertItem(hListView, &item);

setPPID:
             memset(buf, 0, 32);
             itoa(psentry.th32ParentProcessID, buf, 10);
             item.iItem = i;
             item.iSubItem = 1;
             item.pszText = (LPTSTR)buf;
             ListView_SetItem(hListView, &item);
             
             item.iItem = i;
             item.iSubItem = 2;
             item.pszText = DistPri(GetPri(psentry.th32ProcessID));
             ListView_SetItem(hListView, &item);
             
             item.iItem = i;
             item.iSubItem = 3;
             item.pszText = (LPTSTR)psentry.szExeFile;
             ListView_SetItem(hListView, &item);
             
             memset(buf, 0, 32);
             itoa(psentry.cntThreads, buf, 10);
             item.iItem = i;
             item.iSubItem = 4;
             item.pszText = (LPTSTR)buf;
             ListView_SetItem(hListView, &item);
             
             i++;
             
             if( Process32Next(hSs, &psentry) != TRUE )
                 break;
     }
}

DWORD GetPri(DWORD ps)
{
      HANDLE hProc = OpenProcess(PROCESS_ALL_ACCESS, TRUE, ps);
      DWORD ret = GetPriorityClass(hProc);
      CloseHandle(hProc);
      return ret;
}

LPTSTR DistPri(DWORD pri)
{
       switch(pri)
       {
                  case HIGH_PRIORITY_CLASS:
                       return "High";
                  case IDLE_PRIORITY_CLASS:
                       return "Idle";
                  case NORMAL_PRIORITY_CLASS:
                       return "Normal";
                  case REALTIME_PRIORITY_CLASS:
                       return "Realtime";
                  default:
                          return "unknown";
       }
       return "unknown";
}

void SetPri(UINT pri)
{
     int i = 0;
     int lasti;
     int count = ListView_GetItemCount(hListView);
     int mod;
     WORD pid;
     char buf[128], pristr[512];
     HANDLE hProc;
     
     for( ; i < count ; i++ )
     {
          UINT itemState = ListView_GetItemState(hListView, i, LVIS_SELECTED);
          if( itemState & LVIS_SELECTED )
          {
              ListView_GetItemText(hListView, i ,0, buf, sizeof(buf));
              pid = atoi(buf);
              
              hProc = OpenProcess(PROCESS_ALL_ACCESS, TRUE, pid);
              SetPriorityClass(hProc, pri);
              CloseHandle(hProc);
              lasti = i;
              mod = TRUE;
          }
     }
     if( mod == TRUE )
          SetItems(hListView);
     ListView_EnsureVisible(hListView, lasti, FALSE);
}

void TermProcess()
{
     int i = 0;
     int count = ListView_GetItemCount(hListView);
     char buf[128], str[512];
     HANDLE hProc;
     
     for( ; i < count ; i++ )
     {
          UINT itemState = ListView_GetItemState(hListView, i, LVIS_SELECTED);
          if( itemState & LVIS_SELECTED )
          {

              ListView_GetItemText(hListView, i, 0, buf, sizeof(buf));
              /*
              wsprintf(str, "%d", atoi(buf));
              MessageBox(NULL, str, "debug", MB_OK);
              */
              hProc = OpenProcess(PROCESS_ALL_ACCESS, TRUE, atoi(buf));
              if( TerminateProcess(hProc, 1) != TRUE )
              {
                  MessageBox(hListView, "vZX̏IɎs", "Error", MB_OK|MB_ICONWARNING);
                  ListView_SetItemState(hListView, i, LVIS_SELECTED, 0);
                  continue;
              }
              CloseHandle(hProc);
              ListView_DeleteItem(hListView, i);
              ListView_SetItemState(hListView, i, LVIS_SELECTED, 0);
          }
     }
}

void NewProcess(char *s)
{
     char *p, *exefile, *cmdline;
     SECURITY_ATTRIBUTES scattr;
     STARTUPINFO sinfo;
     PROCESS_INFORMATION psinfo;
     
     ZeroMemory(&scattr, sizeof(SECURITY_ATTRIBUTES));
     ZeroMemory(&sinfo, sizeof(STARTUPINFO));
     sinfo.cb = sizeof(STARTUPINFO);
     scattr.nLength = sizeof(SECURITY_ATTRIBUTES);
     scattr.lpSecurityDescriptor = 0;
     scattr.bInheritHandle = FALSE;
     
     sinfo.lpReserved = NULL;
     sinfo.lpDesktop = NULL;
     sinfo.lpTitle = NULL;
     sinfo.dwFlags = 0;
     sinfo.cbReserved2 = (WORD)NULL;
     sinfo.lpReserved2 = NULL;
     
     cmdline = (char*)malloc(1);
     p = strtok(s, " ");
     exefile = p;
     while( p != NULL )
     {
            p = strtok(NULL, " ");
            if( p != NULL )
            {
                cmdline = (char*)realloc(cmdline, strlen(cmdline)+strlen(p)+2);
                strncat(cmdline, " ", 2);
                strncat(cmdline, p, strlen(p));
            }
     }
     //MessageBox(NULL, cmdline, exefile, MB_OK);
     CreateProcess(exefile, cmdline, &scattr, &scattr,
                            FALSE, CREATE_NEW_PROCESS_GROUP,
                            NULL, NULL, &sinfo, &psinfo);
     SetItems(hListView);
     //MessageBox(NULL, "܂ĂȂ(^^;)", "Warning", MB_OK);
     free(cmdline);
} 
