/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SimpleLookup
extends Lookup {
    private Collection allItems;

    SimpleLookup(Collection collection) {
        this.allItems = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem(iterator.next()));
        }
    }

    SimpleLookup(Collection collection, InstanceContent.Convertor convertor) {
        this.allItems = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.allItems.add(new InstanceContent.ConvertingItem(iterator.next(), convertor));
        }
    }

    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult(template);
    }

    public Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    private static boolean matches(Lookup.Template template, AbstractLookup.Pair pair) {
        if (!AbstractLookup.matches(template, pair)) {
            return false;
        }
        Class clazz = template.getType();
        return clazz == null || clazz.isAssignableFrom(pair.getType());
    }

    private class SimpleResult
    extends Lookup.Result {
        private Set classes;
        private Collection items;
        private Lookup.Template template;
        private Collection results;

        SimpleResult(Lookup.Template template) {
            this.template = template;
        }

        public void addLookupListener(LookupListener lookupListener) {
        }

        public void removeLookupListener(LookupListener lookupListener) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Collection allInstances() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.results != null) {
                    return this.results;
                }
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(SimpleLookup.this.allItems.size());
            Iterator iterator = this.allItems().iterator();
            while (iterator.hasNext()) {
                arrayList.add(((Lookup.Item)iterator.next()).getInstance());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.results = Collections.unmodifiableCollection(arrayList);
                return this.results;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set allClasses() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.classes != null) {
                    return this.classes;
                }
            }
            TreeSet<Class> treeSet = new TreeSet<Class>();
            Iterator iterator = this.allItems().iterator();
            while (iterator.hasNext()) {
                treeSet.add(((Lookup.Item)iterator.next()).getType());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.classes = Collections.unmodifiableSet(treeSet);
                return this.classes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Collection allItems() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.items != null) {
                    return this.items;
                }
            }
            ArrayList arrayList = new ArrayList(SimpleLookup.this.allItems.size());
            Iterator iterator = SimpleLookup.this.allItems.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)e)) continue;
                arrayList.add(e);
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.items = Collections.unmodifiableCollection(arrayList);
                return this.items;
            }
        }
    }
}

